/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.gradle.auth;

import com.azure.core.management.AzureEnvironment;
import com.microsoft.azure.gradle.auth.GradleAuthConfig;
import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class GradleAuthHelper {
    protected static final String SUBSCRIPTION_TEMPLATE = "Subscription: %s(%s)";
    private static final String USING_AZURE_ENVIRONMENT = "Using Azure environment: %s.";
    private static final String SUBSCRIPTION_NOT_FOUND = "Subscription %s was not found in current account.";
    private static final String INVALID_AZURE_ENVIRONMENT = "Invalid environment string '%s', please replace it with one of " + AzureEnvironment.knownEnvironments().stream().map(AzureEnvironmentUtils::getCloudName).collect(Collectors.joining(",")) + ".";

    public static String login(GradleAuthConfig auth, String subscriptionId) {
        try {
            Account account = GradleAuthHelper.login(GradleAuthHelper.toAuthConfiguration((GradleAuthConfig)ObjectUtils.firstNonNull((Object[])new GradleAuthConfig[]{auth, new GradleAuthConfig()})));
            List subscriptions = account.getSubscriptions();
            String targetSubscriptionId = GradleAuthHelper.getTargetSubscriptionId(subscriptionId, subscriptions, account.getSelectedSubscriptions());
            GradleAuthHelper.checkSubscription(subscriptions, targetSubscriptionId);
            ((AzureAccount)Azure.az(AzureAccount.class)).account().setSelectedSubscriptions(Collections.singletonList(targetSubscriptionId));
            GradleAuthHelper.printCurrentSubscription(account);
            return targetSubscriptionId;
        }
        catch (InvalidConfigurationException e) {
            throw new AzureToolkitAuthenticationException("Failed to authenticate with Azure due to error: " + e.getMessage());
        }
    }

    private static void printCurrentSubscription(Account account) {
        if (account == null || account.getSelectedSubscriptions().isEmpty()) {
            return;
        }
        Subscription subscription = (Subscription)account.getSelectedSubscriptions().get(0);
        if (subscription != null) {
            AzureMessager.getMessager().info(String.format(SUBSCRIPTION_TEMPLATE, subscription.getName(), subscription.getId()));
        }
    }

    private static void checkSubscription(List<Subscription> subscriptions, String targetSubscriptionId) {
        if (StringUtils.isEmpty((CharSequence)targetSubscriptionId)) {
            return;
        }
        Optional<Subscription> optionalSubscription = subscriptions.stream().filter(subscription -> StringUtils.equals((CharSequence)subscription.getId(), (CharSequence)targetSubscriptionId)).findAny();
        if (!optionalSubscription.isPresent()) {
            throw new AzureToolkitAuthenticationException(String.format(SUBSCRIPTION_NOT_FOUND, targetSubscriptionId));
        }
    }

    private static String getTargetSubscriptionId(String defaultSubscriptionId, List<Subscription> subscriptions, List<Subscription> selectedSubscriptions) {
        String targetSubscriptionId = defaultSubscriptionId;
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId) && !selectedSubscriptions.isEmpty()) {
            targetSubscriptionId = selectedSubscriptions.stream().filter(Subscription::isSelected).map(Subscription::getId).findFirst().orElse(null);
        }
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId) && !subscriptions.isEmpty()) {
            targetSubscriptionId = subscriptions.stream().map(Subscription::getId).findFirst().orElse(null);
        }
        TelemetryAgent.getInstance().addDefaultProperty("subscriptionId", targetSubscriptionId);
        return targetSubscriptionId;
    }

    private static Account login(@Nonnull AuthConfiguration auth) {
        AzureEnvironment azureEnvironment = AzureEnvironmentUtils.stringToAzureEnvironment((String)auth.getEnvironment());
        GradleAuthHelper.promptAzureEnvironment(azureEnvironment);
        Account account = GradleAuthHelper.accountLogin(auth);
        boolean isInteractiveLogin = account.getType() == AuthType.OAUTH2 || account.getType() == AuthType.DEVICE_CODE;
        AzureEnvironment env = account.getEnvironment();
        String environmentName = AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env);
        if (env != AzureEnvironment.AZURE && env != azureEnvironment) {
            AzureMessager.getMessager().info(AzureString.format((String)USING_AZURE_ENVIRONMENT, (Object[])new Object[]{environmentName}));
        }
        GradleAuthHelper.printCredentialDescription(account, isInteractiveLogin);
        TelemetryAgent.getInstance().addDefaultProperty("authType", Objects.toString(auth.getType()));
        TelemetryAgent.getInstance().addDefaultProperty("authMethod", Objects.toString(account.getType()));
        TelemetryAgent.getInstance().addDefaultProperty("azureEnvironment", environmentName);
        return account;
    }

    private static void printCredentialDescription(Account account, boolean skipType) {
        if (skipType) {
            List selectedSubscriptions;
            if (CollectionUtils.isNotEmpty((Collection)account.getSubscriptions()) && (selectedSubscriptions = account.getSelectedSubscriptions()) != null && selectedSubscriptions.size() == 1) {
                AzureMessager.getMessager().info(AzureString.format((String)"Default subscription: %s(%s)", (Object[])new Object[]{((Subscription)selectedSubscriptions.get(0)).getName(), ((Subscription)selectedSubscriptions.get(0)).getId()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)account.getUsername())) {
                AzureMessager.getMessager().info(AzureString.format((String)"Username: %s", (Object[])new Object[]{account.getUsername()}));
            }
        } else {
            AzureMessager.getMessager().info(account.toString());
        }
    }

    private static void promptAzureEnvironment(AzureEnvironment env) {
        if (env != null && env != AzureEnvironment.AZURE) {
            AzureMessager.getMessager().info(AzureString.format((String)"Auth environment: %s", (Object[])new Object[]{AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env)}));
        }
    }

    private static Account accountLogin(AuthConfiguration auth) {
        AzureAccount azureAccount = (AzureAccount)Azure.az(AzureAccount.class);
        if (azureAccount.isLoggedIn() || azureAccount.isLoggingIn()) {
            azureAccount.logout();
        }
        if (auth.getEnvironment() != null) {
            ((AzureCloud)Azure.az(AzureCloud.class)).set(AzureEnvironmentUtils.stringToAzureEnvironment((String)auth.getEnvironment()));
        }
        if (auth.getType() == AuthType.DEVICE_CODE) {
            auth.setDeviceCodeConsumer(info -> {
                String message = StringUtils.replace((String)info.getMessage(), (String)info.getUserCode(), (String)TextUtils.cyan((String)info.getUserCode()));
                AzureMessager.getMessager().info(message);
            });
        }
        if (auth.getType() == AuthType.AUTO) {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{auth.getCertificate(), auth.getCertificatePassword(), auth.getKey()})) {
                return azureAccount.login(auth, false);
            }
            auth.setType(AuthType.SERVICE_PRINCIPAL);
            return azureAccount.login(auth);
        }
        return azureAccount.login(auth, false);
    }

    private static AuthConfiguration toAuthConfiguration(GradleAuthConfig gradleAuthConfig) throws InvalidConfigurationException {
        AuthConfiguration authConfiguration = new AuthConfiguration(AuthType.parseAuthType((String)gradleAuthConfig.getType()));
        authConfiguration.setClient(gradleAuthConfig.getClient());
        authConfiguration.setTenant(gradleAuthConfig.getTenant());
        authConfiguration.setCertificate(gradleAuthConfig.getCertificate());
        authConfiguration.setCertificatePassword(gradleAuthConfig.getCertificatePassword());
        authConfiguration.setKey(gradleAuthConfig.getKey());
        authConfiguration.setEnvironment(gradleAuthConfig.getEnvironment());
        if (StringUtils.isNotBlank((CharSequence)gradleAuthConfig.getEnvironment()) && Objects.isNull(authConfiguration.getEnvironment())) {
            throw new InvalidConfigurationException(String.format(INVALID_AZURE_ENVIRONMENT, gradleAuthConfig.getEnvironment()));
        }
        return authConfiguration;
    }
}

