/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.gradle.util;

import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.logging.Logger;

public class GradleAzureMessager
implements IAzureMessager,
IAzureMessage.ValueDecorator {
    private Logger log;

    public boolean show(IAzureMessage message) {
        switch (message.getType()) {
            case ALERT: 
            case CONFIRM: 
            case WARNING: {
                this.log.warn(message.getContent());
                return true;
            }
            case ERROR: {
                this.log.error(message.getContent(), (Throwable)message.getPayload());
                return true;
            }
        }
        this.log.lifecycle(message.getContent());
        return true;
    }

    public String decorateValue(@Nonnull Object p, @Nullable IAzureMessage message) {
        return TextUtils.cyan((String)p.toString());
    }

    public GradleAzureMessager(Logger log) {
        this.log = log;
    }
}

