/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.AsymmetricSignatureAlgorithm;
import com.microsoft.azure.keyvault.cryptography.ISignatureTransform;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Signature;

public abstract class Ecdsa
extends AsymmetricSignatureAlgorithm {
    protected Ecdsa() {
        super("NONEwithEDCSA");
    }

    public ISignatureTransform createSignatureTransform(KeyPair key, Provider provider) {
        return new EcdsaSignatureTransform(key, provider);
    }

    abstract void checkDigestLength(byte[] var1);

    class EcdsaSignatureTransform
    implements ISignatureTransform {
        private final String ALGORITHM = "NONEwithECDSA";
        private final KeyPair _keyPair;
        private final Provider _provider;

        public EcdsaSignatureTransform(KeyPair keyPair, Provider provider) {
            this._keyPair = keyPair;
            this._provider = provider;
        }

        @Override
        public byte[] sign(byte[] digest) throws GeneralSecurityException {
            Ecdsa.this.checkDigestLength(digest);
            Signature signature = Signature.getInstance("NONEwithECDSA", this._provider);
            signature.initSign(this._keyPair.getPrivate());
            signature.update(digest);
            return signature.sign();
        }

        @Override
        public boolean verify(byte[] digest, byte[] signature) throws GeneralSecurityException {
            Signature verify = Signature.getInstance("NONEwithECDSA", this._provider);
            Ecdsa.this.checkDigestLength(digest);
            verify.initVerify(this._keyPair.getPublic());
            verify.update(digest);
            return verify.verify(signature);
        }
    }
}

