/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography;

import com.microsoft.azure.keyvault.cryptography.Algorithm;
import com.microsoft.azure.keyvault.cryptography.AlgorithmResolver;
import com.microsoft.azure.keyvault.cryptography.Asn1DerSignatureEncoding;
import com.microsoft.azure.keyvault.cryptography.algorithms.Ecdsa;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public final class SignatureEncoding {
    private SignatureEncoding() {
    }

    public static byte[] fromAsn1Der(byte[] asn1DerSignature, String algorithm) throws NoSuchAlgorithmException {
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw new IllegalArgumentException("Invalid algorithm; must be an instance of ECDSA.");
        }
        return SignatureEncoding.fromAsn1Der(asn1DerSignature, (Ecdsa)baseAlgorithm);
    }

    public static byte[] fromAsn1Der(byte[] asn1DerSignature, Ecdsa algorithm) {
        try {
            return Asn1DerSignatureEncoding.Decode(asn1DerSignature, algorithm);
        }
        catch (IllegalArgumentException ex) {
            throw (IllegalArgumentException)new IllegalArgumentException(ex.getMessage() + " " + Hex.encodeHexString((byte[])asn1DerSignature)).initCause(ex);
        }
    }

    public static byte[] toAsn1Der(byte[] signature, String algorithm) throws NoSuchAlgorithmException {
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw new IllegalArgumentException("Invalid algorithm; must be an instance of ECDSA.");
        }
        return SignatureEncoding.toAsn1Der(signature, (Ecdsa)baseAlgorithm);
    }

    public static byte[] toAsn1Der(byte[] signature, Ecdsa algorithm) {
        try {
            return Asn1DerSignatureEncoding.Encode(signature, algorithm);
        }
        catch (IllegalArgumentException ex) {
            throw (IllegalArgumentException)new IllegalArgumentException(ex.getMessage() + " " + Hex.encodeHexString((byte[])signature)).initCause(ex);
        }
    }
}

