/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.ByteExtensions;
import com.microsoft.azure.keyvault.cryptography.ISignatureTransform;
import com.microsoft.azure.keyvault.cryptography.algorithms.RsaSignature;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class Rs256
extends RsaSignature {
    static final String RsaNone = "RSA/ECB/PKCS1Padding";
    public static final String ALGORITHM_NAME = "RS256";

    public Rs256() {
        super(ALGORITHM_NAME);
    }

    @Override
    public ISignatureTransform createSignatureTransform(KeyPair keyPair) {
        return new Rs256SignatureTransform(keyPair);
    }

    class Rs256SignatureTransform
    implements ISignatureTransform {
        private final KeyPair _keyPair;
        private final int _emLen;

        Rs256SignatureTransform(KeyPair keyPair) {
            this._keyPair = keyPair;
            BigInteger modulus = ((RSAPublicKey)this._keyPair.getPublic()).getModulus();
            this._emLen = Rs256.this.getOctetLength(modulus.bitLength());
        }

        @Override
        public byte[] sign(byte[] digest) throws NoSuchAlgorithmException {
            if (this._keyPair.getPrivate() == null) {
                // empty if block
            }
            byte[] EM = Rs256.this.EMSA_PKCS1_V1_5_ENCODE_HASH(digest, this._emLen, "SHA-256");
            BigInteger s = Rs256.this.OS2IP(EM);
            s = Rs256.this.RSASP1((RSAPrivateKey)this._keyPair.getPrivate(), s);
            return Rs256.this.I2OSP(s, this._emLen);
        }

        @Override
        public boolean verify(byte[] digest, byte[] signature) throws NoSuchAlgorithmException {
            if (signature.length != this._emLen) {
                throw new IllegalArgumentException("invalid signature length");
            }
            BigInteger s = Rs256.this.OS2IP(signature);
            BigInteger m = Rs256.this.RSAVP1((RSAPublicKey)this._keyPair.getPublic(), s);
            byte[] EM = Rs256.this.I2OSP(m, this._emLen);
            byte[] EM2 = Rs256.this.EMSA_PKCS1_V1_5_ENCODE_HASH(digest, this._emLen, "SHA-256");
            return ByteExtensions.sequenceEqualConstantTime(EM, EM2);
        }
    }
}

