/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring.boot;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.keyvault.models.SecretItem;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class KeyVaultOperation {
    private static final long CACHE_REFRESH_INTERVAL_IN_MS = 1800000L;
    private final Object refreshLock = new Object();
    private KeyVaultClient keyVaultClient;
    private String vaultUri;
    private ConcurrentHashMap<String, Object> propertyNamesHashMap;
    private AtomicLong lastUpdateTime = new AtomicLong();
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public KeyVaultOperation(KeyVaultClient keyVaultClient, String vaultUri) {
        this.keyVaultClient = keyVaultClient;
        this.vaultUri = vaultUri;
        if (vaultUri.endsWith("/")) {
            this.vaultUri = vaultUri.substring(0, vaultUri.length() - 1);
        }
        this.createOrUpdateHashMap();
    }

    public String[] list() {
        try {
            this.rwLock.readLock().lock();
            String[] stringArray = Collections.list(this.propertyNamesHashMap.keys()).toArray(new String[this.propertyNamesHashMap.size()]);
            return stringArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String secretName) {
        secretName = secretName.replace(".", "-");
        if (System.currentTimeMillis() - this.lastUpdateTime.get() > 1800000L) {
            Object object = this.refreshLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.lastUpdateTime.get() > 1800000L) {
                    this.lastUpdateTime.set(System.currentTimeMillis());
                    this.createOrUpdateHashMap();
                }
            }
        }
        if (this.propertyNamesHashMap.containsKey(secretName)) {
            SecretBundle secretBundle = this.keyVaultClient.getSecret(this.vaultUri, secretName);
            return secretBundle.value();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdateHashMap() {
        if (this.propertyNamesHashMap == null) {
            this.propertyNamesHashMap = new ConcurrentHashMap();
        }
        try {
            this.rwLock.writeLock().lock();
            this.propertyNamesHashMap.clear();
            PagedList secrets = this.keyVaultClient.listSecrets(this.vaultUri);
            secrets.loadAll();
            for (SecretItem secret : secrets) {
                this.propertyNamesHashMap.putIfAbsent(secret.id().replaceFirst(this.vaultUri + "/secrets/", ""), secret.id());
            }
            this.lastUpdateTime.set(System.currentTimeMillis());
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

