/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring.boot;

import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.spring.boot.AzureKeyVaultCredential;
import com.microsoft.azure.keyvault.spring.boot.KeyVaultOperation;
import com.microsoft.azure.keyvault.spring.boot.KeyVaultPropertySource;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class KeyVaultPropertyInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext ctx) {
        ConfigurableEnvironment env = ctx.getEnvironment();
        String clientId = this.getProperty(env, "azure.client-id");
        String clientKey = this.getProperty(env, "azure.client-key");
        String vaultUri = this.getProperty(env, "azure.keyvault.uri");
        boolean enabled = true;
        if (env.getProperty("azure.keyvault.enabled") != null) {
            enabled = Boolean.parseBoolean(env.getProperty("azure.keyvault.enabled"));
        }
        long timeAcquringTimeoutInSeconds = 60L;
        if (env.getProperty("azure.token.acquire.timeout.seconds") != null) {
            timeAcquringTimeoutInSeconds = Long.parseLong(env.getProperty("azure.token.acquire.timeout.seconds"));
        }
        if (enabled) {
            KeyVaultClient kvClient = new KeyVaultClient((ServiceClientCredentials)new AzureKeyVaultCredential(clientId, clientKey, timeAcquringTimeoutInSeconds));
            try {
                MutablePropertySources sources = env.getPropertySources();
                sources.addFirst((PropertySource)new KeyVaultPropertySource(new KeyVaultOperation(kvClient, vaultUri)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getProperty(ConfigurableEnvironment env, String propertyName) {
        Assert.notNull((Object)env, (String)"env must not be null!");
        Assert.notNull((Object)propertyName, (String)"propertyName must not be null!");
        String property = env.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property " + propertyName + " must not be null!");
        }
        return property;
    }
}

