/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.webkey;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.microsoft.azure.keyvault.webkey.Base64UrlJsonDeserializer;
import com.microsoft.azure.keyvault.webkey.Base64UrlJsonSerializer;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyCurveName;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class JsonWebKey {
    @JsonProperty(value="kid")
    private String kid;
    @JsonProperty(value="kty")
    private JsonWebKeyType kty;
    @JsonProperty(value="key_ops")
    private List<JsonWebKeyOperation> keyOps;
    @JsonProperty(value="n")
    private byte[] n;
    @JsonProperty(value="e")
    private byte[] e;
    @JsonProperty(value="d")
    private byte[] d;
    @JsonProperty(value="dp")
    private byte[] dp;
    @JsonProperty(value="dq")
    private byte[] dq;
    @JsonProperty(value="qi")
    private byte[] qi;
    @JsonProperty(value="p")
    private byte[] p;
    @JsonProperty(value="q")
    private byte[] q;
    @JsonProperty(value="k")
    private byte[] k;
    @JsonProperty(value="key_hsm")
    private byte[] t;
    @JsonProperty(value="crv")
    private JsonWebKeyCurveName crv;
    @JsonProperty(value="x")
    private byte[] x;
    @JsonProperty(value="y")
    private byte[] y;
    private static final Map<JsonWebKeyCurveName, String> CURVE_TO_SPEC_NAME = ImmutableMap.builder().put((Object)JsonWebKeyCurveName.P_256, (Object)"secp256r1").put((Object)JsonWebKeyCurveName.P_384, (Object)"secp384r1").put((Object)JsonWebKeyCurveName.P_521, (Object)"secp521r1").put((Object)JsonWebKeyCurveName.P_256K, (Object)"secp256k1").build();

    @JsonProperty(value="kid")
    public String kid() {
        return this.kid;
    }

    public JsonWebKey withKid(String kid) {
        this.kid = kid;
        return this;
    }

    @JsonProperty(value="kty")
    public JsonWebKeyType kty() {
        return this.kty;
    }

    public JsonWebKey withKty(JsonWebKeyType kty) {
        this.kty = kty;
        return this;
    }

    @JsonProperty(value="key_ops")
    public List<JsonWebKeyOperation> keyOps() {
        return this.keyOps;
    }

    public JsonWebKey withKeyOps(List<JsonWebKeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    @JsonProperty(value="n")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] n() {
        return this.n;
    }

    public JsonWebKey withN(byte[] n) {
        this.n = n;
        return this;
    }

    @JsonProperty(value="e")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] e() {
        return this.e;
    }

    public JsonWebKey withE(byte[] e) {
        this.e = e;
        return this;
    }

    @JsonProperty(value="d")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] d() {
        return this.d;
    }

    public JsonWebKey withD(byte[] d) {
        this.d = d;
        return this;
    }

    @JsonProperty(value="dp")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] dp() {
        return this.dp;
    }

    public JsonWebKey withDp(byte[] dp) {
        this.dp = dp;
        return this;
    }

    @JsonProperty(value="dq")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] dq() {
        return this.dq;
    }

    public JsonWebKey withDq(byte[] dq) {
        this.dq = dq;
        return this;
    }

    @JsonProperty(value="qi")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] qi() {
        return this.qi;
    }

    public JsonWebKey withQi(byte[] qi) {
        this.qi = qi;
        return this;
    }

    @JsonProperty(value="p")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] p() {
        return this.p;
    }

    public JsonWebKey withP(byte[] p) {
        this.p = p;
        return this;
    }

    @JsonProperty(value="q")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] q() {
        return this.q;
    }

    public JsonWebKey withQ(byte[] q) {
        this.q = q;
        return this;
    }

    @JsonProperty(value="k")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] k() {
        return this.k;
    }

    public JsonWebKey withK(byte[] k) {
        this.k = k;
        return this;
    }

    @JsonProperty(value="key_hsm")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] t() {
        return this.t;
    }

    public JsonWebKey withT(byte[] t) {
        this.t = t;
        return this;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @JsonProperty(value="crv")
    public JsonWebKeyCurveName crv() {
        return this.crv;
    }

    public JsonWebKey withCrv(JsonWebKeyCurveName crv) {
        this.crv = crv;
        return this;
    }

    @JsonProperty(value="x")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] x() {
        return this.x;
    }

    public JsonWebKey withX(byte[] x) {
        this.x = x;
        return this;
    }

    @JsonProperty(value="y")
    @JsonSerialize(using=Base64UrlJsonSerializer.class)
    @JsonDeserialize(using=Base64UrlJsonDeserializer.class)
    public byte[] y() {
        return this.y;
    }

    public JsonWebKey withY(byte[] y) {
        this.y = y;
        return this;
    }

    private RSAPublicKeySpec getRSAPublicKeySpec() {
        return new RSAPublicKeySpec(JsonWebKey.toBigInteger(this.n), JsonWebKey.toBigInteger(this.e));
    }

    private RSAPrivateKeySpec getRSAPrivateKeySpec() {
        return new RSAPrivateCrtKeySpec(JsonWebKey.toBigInteger(this.n), JsonWebKey.toBigInteger(this.e), JsonWebKey.toBigInteger(this.d), JsonWebKey.toBigInteger(this.p), JsonWebKey.toBigInteger(this.q), JsonWebKey.toBigInteger(this.dp), JsonWebKey.toBigInteger(this.dq), JsonWebKey.toBigInteger(this.qi));
    }

    private PublicKey getRSAPublicKey(Provider provider) {
        try {
            RSAPublicKeySpec publicKeySpec = this.getRSAPublicKeySpec();
            KeyFactory factory = provider != null ? KeyFactory.getInstance("RSA", provider) : KeyFactory.getInstance("RSA");
            return factory.generatePublic(publicKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private PrivateKey getRSAPrivateKey(Provider provider) {
        try {
            RSAPrivateKeySpec privateKeySpec = this.getRSAPrivateKeySpec();
            KeyFactory factory = provider != null ? KeyFactory.getInstance("RSA", provider) : KeyFactory.getInstance("RSA");
            return factory.generatePrivate(privateKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static PublicKey getECPublicKey(ECPoint ecPoint, ECParameterSpec curveSpec, Provider provider) {
        try {
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(ecPoint, curveSpec);
            KeyFactory kf = provider != null ? KeyFactory.getInstance("EC", provider) : KeyFactory.getInstance("EC", "SunEC");
            return (ECPublicKey)kf.generatePublic(pubSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static PrivateKey getECPrivateKey(byte[] d, ECParameterSpec curveSpec, Provider provider) {
        try {
            ECPrivateKeySpec priSpec = new ECPrivateKeySpec(new BigInteger(1, d), curveSpec);
            KeyFactory kf = provider != null ? KeyFactory.getInstance("EC", provider) : KeyFactory.getInstance("EC", "SunEC");
            return (ECPrivateKey)kf.generatePrivate(priSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkRSACompatible() {
        if (!JsonWebKeyType.RSA.equals(this.kty) && !JsonWebKeyType.RSA_HSM.equals(this.kty)) {
            throw new UnsupportedOperationException("Not an RSA key");
        }
    }

    private static byte[] toByteArray(BigInteger n) {
        byte[] result = n.toByteArray();
        if (result[0] == 0) {
            return Arrays.copyOfRange(result, 1, result.length);
        }
        return result;
    }

    private static BigInteger toBigInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[1 + b.length];
            System.arraycopy(b, 0, temp, 1, b.length);
            b = temp;
        }
        return new BigInteger(b);
    }

    public static JsonWebKey fromRSA(KeyPair keyPair) {
        RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)keyPair.getPrivate();
        JsonWebKey key = null;
        if (privateKey != null) {
            key = new JsonWebKey().withKty(JsonWebKeyType.RSA).withN(JsonWebKey.toByteArray(privateKey.getModulus())).withE(JsonWebKey.toByteArray(privateKey.getPublicExponent())).withD(JsonWebKey.toByteArray(privateKey.getPrivateExponent())).withP(JsonWebKey.toByteArray(privateKey.getPrimeP())).withQ(JsonWebKey.toByteArray(privateKey.getPrimeQ())).withDp(JsonWebKey.toByteArray(privateKey.getPrimeExponentP())).withDq(JsonWebKey.toByteArray(privateKey.getPrimeExponentQ())).withQi(JsonWebKey.toByteArray(privateKey.getCrtCoefficient()));
        } else {
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            key = new JsonWebKey().withKty(JsonWebKeyType.RSA).withN(JsonWebKey.toByteArray(publicKey.getModulus())).withE(JsonWebKey.toByteArray(publicKey.getPublicExponent())).withD(null).withP(null).withQ(null).withDp(null).withDq(null).withQi(null);
        }
        return key;
    }

    public KeyPair toRSA() {
        return this.toRSA(false);
    }

    public KeyPair toRSA(boolean includePrivateParameters) {
        return this.toRSA(includePrivateParameters, null);
    }

    public KeyPair toRSA(boolean includePrivateParameters, Provider provider) {
        this.checkRSACompatible();
        if (includePrivateParameters) {
            return new KeyPair(this.getRSAPublicKey(provider), this.getRSAPrivateKey(provider));
        }
        return new KeyPair(this.getRSAPublicKey(provider), null);
    }

    public KeyPair toEC() {
        return this.toEC(false, null);
    }

    public KeyPair toEC(boolean includePrivateParameters) {
        return this.toEC(includePrivateParameters, null);
    }

    public KeyPair toEC(boolean includePrivateParameters, Provider provider) {
        if (provider == null) {
            provider = Security.getProvider("SunEC");
        }
        if (!JsonWebKeyType.EC.equals(this.kty) && !JsonWebKeyType.EC_HSM.equals(this.kty)) {
            throw new IllegalArgumentException("Not an EC key.");
        }
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", provider);
            ECGenParameterSpec gps = new ECGenParameterSpec(CURVE_TO_SPEC_NAME.get(this.crv));
            kpg.initialize(gps);
            KeyPair apair = kpg.generateKeyPair();
            ECPublicKey apub = (ECPublicKey)apair.getPublic();
            ECParameterSpec aspec = apub.getParams();
            ECPoint ecPoint = new ECPoint(new BigInteger(1, this.x), new BigInteger(1, this.y));
            KeyPair realKeyPair = includePrivateParameters ? new KeyPair(JsonWebKey.getECPublicKey(ecPoint, aspec, provider), JsonWebKey.getECPrivateKey(this.d, aspec, provider)) : new KeyPair(JsonWebKey.getECPublicKey(ecPoint, aspec, provider), null);
            return realKeyPair;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JsonWebKey fromEC(KeyPair keyPair, Provider provider) {
        ECPublicKey apub = (ECPublicKey)keyPair.getPublic();
        ECPoint point = apub.getW();
        ECPrivateKey apriv = (ECPrivateKey)keyPair.getPrivate();
        if (apriv != null) {
            return new JsonWebKey().withKty(JsonWebKeyType.EC).withCrv(JsonWebKey.getCurveFromKeyPair(keyPair, provider)).withX(point.getAffineX().toByteArray()).withY(point.getAffineY().toByteArray()).withD(apriv.getS().toByteArray()).withKty(JsonWebKeyType.EC);
        }
        return new JsonWebKey().withKty(JsonWebKeyType.EC).withCrv(JsonWebKey.getCurveFromKeyPair(keyPair, provider)).withX(point.getAffineX().toByteArray()).withY(point.getAffineY().toByteArray()).withKty(JsonWebKeyType.EC);
    }

    private static JsonWebKeyCurveName getCurveFromKeyPair(KeyPair keyPair, Provider provider) {
        try {
            ECPublicKey key = (ECPublicKey)keyPair.getPublic();
            ECParameterSpec spec = key.getParams();
            EllipticCurve crv = spec.getCurve();
            List<JsonWebKeyCurveName> curveList = Arrays.asList(JsonWebKeyCurveName.P_256, JsonWebKeyCurveName.P_384, JsonWebKeyCurveName.P_521, JsonWebKeyCurveName.P_256K);
            for (JsonWebKeyCurveName curve : curveList) {
                ECGenParameterSpec gps = new ECGenParameterSpec(CURVE_TO_SPEC_NAME.get(curve));
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", provider);
                kpg.initialize(gps);
                KeyPair apair = kpg.generateKeyPair();
                ECPublicKey apub = (ECPublicKey)apair.getPublic();
                ECParameterSpec aspec = apub.getParams();
                EllipticCurve acurve = aspec.getCurve();
                if (!acurve.equals(crv)) continue;
                return curve;
            }
            throw new NoSuchAlgorithmException("Curve not supported.");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JsonWebKey fromAes(SecretKey secretKey) {
        if (secretKey == null) {
            return null;
        }
        return new JsonWebKey().withK(secretKey.getEncoded()).withKty(JsonWebKeyType.OCT);
    }

    public SecretKey toAes() {
        if (this.k == null) {
            return null;
        }
        SecretKeySpec secretKey = new SecretKeySpec(this.k, "AES");
        return secretKey;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JsonWebKey) {
            return this.equals((JsonWebKey)obj);
        }
        return super.equals(obj);
    }

    public boolean equals(JsonWebKey jwk) {
        if (jwk == null) {
            return false;
        }
        if (!Objects.equal((Object)this.kid, (Object)jwk.kid)) {
            return false;
        }
        if (!Objects.equal((Object)this.kty, (Object)jwk.kty)) {
            return false;
        }
        if (!Objects.equal(this.keyOps, jwk.keyOps)) {
            return false;
        }
        if (!Objects.equal((Object)this.crv, (Object)jwk.crv)) {
            return false;
        }
        if (!Arrays.equals(this.k, jwk.k)) {
            return false;
        }
        if (!Arrays.equals(this.n, jwk.n)) {
            return false;
        }
        if (!Arrays.equals(this.e, jwk.e)) {
            return false;
        }
        if (!Arrays.equals(this.d, jwk.d)) {
            return false;
        }
        if (!Arrays.equals(this.dp, jwk.dp)) {
            return false;
        }
        if (!Arrays.equals(this.dq, jwk.dq)) {
            return false;
        }
        if (!Arrays.equals(this.qi, jwk.qi)) {
            return false;
        }
        if (!Arrays.equals(this.p, jwk.p)) {
            return false;
        }
        if (!Arrays.equals(this.q, jwk.q)) {
            return false;
        }
        if (!Arrays.equals(this.x, jwk.x)) {
            return false;
        }
        if (!Arrays.equals(this.y, jwk.y)) {
            return false;
        }
        return Arrays.equals(this.t, jwk.t);
    }

    public boolean hasPrivateKey() {
        if (JsonWebKeyType.OCT.equals(this.kty)) {
            return this.k != null;
        }
        if (JsonWebKeyType.RSA.equals(this.kty) || JsonWebKeyType.RSA_HSM.equals(this.kty)) {
            return this.d != null && this.dp != null && this.dq != null && this.qi != null && this.p != null && this.q != null;
        }
        if (JsonWebKeyType.EC.equals(this.kty) || JsonWebKeyType.EC_HSM.equals(this.kty)) {
            return this.d != null;
        }
        return false;
    }

    @JsonIgnore
    public boolean isValid() {
        if (this.kty == null) {
            return false;
        }
        if (this.keyOps != null) {
            HashSet<JsonWebKeyOperation> set = new HashSet<JsonWebKeyOperation>(JsonWebKeyOperation.ALL_OPERATIONS);
            for (int i = 0; i < this.keyOps.size(); ++i) {
                if (set.contains(this.keyOps.get(i))) continue;
                return false;
            }
        }
        if (JsonWebKeyType.OCT.equals(this.kty)) {
            return this.isValidOctet();
        }
        if (JsonWebKeyType.RSA.equals(this.kty)) {
            return this.isValidRsa();
        }
        if (JsonWebKeyType.RSA_HSM.equals(this.kty)) {
            return this.isValidRsaHsm();
        }
        if (JsonWebKeyType.EC.equals(this.kty)) {
            return this.isValidEc();
        }
        if (JsonWebKeyType.EC_HSM.equals(this.kty)) {
            return this.isValidEcHsm();
        }
        return false;
    }

    private boolean isValidOctet() {
        return this.k != null;
    }

    private boolean isValidRsa() {
        if (this.n == null || this.e == null) {
            return false;
        }
        return this.hasPrivateKey() || this.d == null && this.dp == null && this.dq == null && this.qi == null && this.p == null && this.q == null;
    }

    private boolean isValidRsaHsm() {
        boolean publicParameters;
        if (this.n == null && this.e != null || this.n != null && this.e == null) {
            return false;
        }
        if (this.hasPrivateKey()) {
            return false;
        }
        boolean tokenParameters = this.t != null;
        boolean bl = publicParameters = this.n != null && this.e != null;
        if (tokenParameters && publicParameters) {
            return false;
        }
        return tokenParameters || publicParameters;
    }

    private boolean isValidEc() {
        boolean ecPointParameters;
        boolean bl = ecPointParameters = this.x != null && this.y != null;
        if (!ecPointParameters || this.crv == null) {
            return false;
        }
        return this.hasPrivateKey() || this.d == null;
    }

    private boolean isValidEcHsm() {
        boolean tokenParameters;
        boolean ecPointParameters;
        boolean bl = ecPointParameters = this.x != null && this.y != null;
        if (ecPointParameters && this.crv == null || !ecPointParameters && this.crv != null) {
            return false;
        }
        if (this.hasPrivateKey()) {
            return false;
        }
        boolean publicParameters = ecPointParameters && this.crv != null;
        boolean bl2 = tokenParameters = this.t != null;
        if (tokenParameters && publicParameters) {
            return false;
        }
        return tokenParameters || publicParameters;
    }

    public void clearMemory() {
        JsonWebKey.zeroArray(this.k);
        this.k = null;
        JsonWebKey.zeroArray(this.n);
        this.n = null;
        JsonWebKey.zeroArray(this.e);
        this.e = null;
        JsonWebKey.zeroArray(this.d);
        this.d = null;
        JsonWebKey.zeroArray(this.dp);
        this.dp = null;
        JsonWebKey.zeroArray(this.dq);
        this.dq = null;
        JsonWebKey.zeroArray(this.qi);
        this.qi = null;
        JsonWebKey.zeroArray(this.p);
        this.p = null;
        JsonWebKey.zeroArray(this.q);
        this.q = null;
        JsonWebKey.zeroArray(this.t);
        this.t = null;
        JsonWebKey.zeroArray(this.x);
        this.x = null;
        JsonWebKey.zeroArray(this.y);
        this.y = null;
    }

    private static void zeroArray(byte[] bytes) {
        if (bytes != null) {
            Arrays.fill(bytes, (byte)0);
        }
    }

    public int hashCode() {
        int hashCode = 48313;
        if (this.kid != null) {
            hashCode += this.kid.hashCode();
        }
        if (JsonWebKeyType.OCT.equals(this.kty)) {
            hashCode += JsonWebKey.hashCode(this.k);
        } else if (JsonWebKeyType.RSA.equals(this.kty)) {
            hashCode += JsonWebKey.hashCode(this.n);
        } else if (JsonWebKeyType.EC.equals(this.kty)) {
            hashCode += JsonWebKey.hashCode(this.x);
            hashCode += JsonWebKey.hashCode(this.y);
            hashCode += this.crv.hashCode();
        } else if (JsonWebKeyType.RSA_HSM.equals(this.kty) || JsonWebKeyType.EC_HSM.equals(this.kty)) {
            hashCode += JsonWebKey.hashCode(this.t);
        }
        return hashCode;
    }

    private static int hashCode(byte[] obj) {
        int hashCode = 0;
        if (obj == null || obj.length == 0) {
            return 0;
        }
        for (int i = 0; i < obj.length; ++i) {
            hashCode = hashCode << 3 | hashCode >> 29 ^ obj[i];
        }
        return hashCode;
    }
}

