/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.loganalytics.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A table column.
 * A column in a table.
 */
public class Column {
    /**
     * The name of this column.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * The data type of this column.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Get the name of this column.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of this column.
     *
     * @param name the name value to set
     * @return the Column object itself.
     */
    public Column withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the data type of this column.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the data type of this column.
     *
     * @param type the type value to set
     * @return the Column object itself.
     */
    public Column withType(String type) {
        this.type = type;
        return this;
    }

}
