/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.loganalytics.models;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Error details.
 */
public class ErrorDetail {
    /**
     * The error's code.
     */
    @JsonProperty(value = "code", required = true)
    private String code;

    /**
     * A human readable error message.
     */
    @JsonProperty(value = "message", required = true)
    private String message;

    /**
     * Indicates which property in the request is responsible for the error.
     */
    @JsonProperty(value = "target")
    private String target;

    /**
     * Indicates which value in 'target' is responsible for the error.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Indicates resources which were responsible for the error.
     */
    @JsonProperty(value = "resources")
    private List<String> resources;

    /**
     * The additionalProperties property.
     */
    @JsonProperty(value = "additionalProperties")
    private Object additionalProperties;

    /**
     * Get the error's code.
     *
     * @return the code value
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the error's code.
     *
     * @param code the code value to set
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get a human readable error message.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Set a human readable error message.
     *
     * @param message the message value to set
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get indicates which property in the request is responsible for the error.
     *
     * @return the target value
     */
    public String target() {
        return this.target;
    }

    /**
     * Set indicates which property in the request is responsible for the error.
     *
     * @param target the target value to set
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get indicates which value in 'target' is responsible for the error.
     *
     * @return the value value
     */
    public String value() {
        return this.value;
    }

    /**
     * Set indicates which value in 'target' is responsible for the error.
     *
     * @param value the value value to set
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get indicates resources which were responsible for the error.
     *
     * @return the resources value
     */
    public List<String> resources() {
        return this.resources;
    }

    /**
     * Set indicates resources which were responsible for the error.
     *
     * @param resources the resources value to set
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Get the additionalProperties value.
     *
     * @return the additionalProperties value
     */
    public Object additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties value.
     *
     * @param additionalProperties the additionalProperties value to set
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail withAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

}
