/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.loganalytics.models;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The code and message for an error.
 */
public class ErrorInfo {
    /**
     * A machine readable error code.
     */
    @JsonProperty(value = "code", required = true)
    private String code;

    /**
     * A human readable error message.
     */
    @JsonProperty(value = "message", required = true)
    private String message;

    /**
     * error details.
     */
    @JsonProperty(value = "details")
    private List<ErrorDetail> details;

    /**
     * Inner error details if they exist.
     */
    @JsonProperty(value = "innererror")
    private ErrorInfo innererror;

    /**
     * The additionalProperties property.
     */
    @JsonProperty(value = "additionalProperties")
    private Object additionalProperties;

    /**
     * Get a machine readable error code.
     *
     * @return the code value
     */
    public String code() {
        return this.code;
    }

    /**
     * Set a machine readable error code.
     *
     * @param code the code value to set
     * @return the ErrorInfo object itself.
     */
    public ErrorInfo withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get a human readable error message.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Set a human readable error message.
     *
     * @param message the message value to set
     * @return the ErrorInfo object itself.
     */
    public ErrorInfo withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get error details.
     *
     * @return the details value
     */
    public List<ErrorDetail> details() {
        return this.details;
    }

    /**
     * Set error details.
     *
     * @param details the details value to set
     * @return the ErrorInfo object itself.
     */
    public ErrorInfo withDetails(List<ErrorDetail> details) {
        this.details = details;
        return this;
    }

    /**
     * Get inner error details if they exist.
     *
     * @return the innererror value
     */
    public ErrorInfo innererror() {
        return this.innererror;
    }

    /**
     * Set inner error details if they exist.
     *
     * @param innererror the innererror value to set
     * @return the ErrorInfo object itself.
     */
    public ErrorInfo withInnererror(ErrorInfo innererror) {
        this.innererror = innererror;
        return this;
    }

    /**
     * Get the additionalProperties value.
     *
     * @return the additionalProperties value
     */
    public Object additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties value.
     *
     * @param additionalProperties the additionalProperties value to set
     * @return the ErrorInfo object itself.
     */
    public ErrorInfo withAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

}
