/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.loganalytics.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.loganalytics.LogAnalyticsDataClient;
import com.microsoft.azure.loganalytics.models.ErrorResponseException;
import com.microsoft.azure.loganalytics.models.QueryBody;
import com.microsoft.azure.loganalytics.models.QueryResults;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import rx.Observable;
import rx.functions.Func1;

public class LogAnalyticsDataClientImpl
extends AzureServiceClient
implements LogAnalyticsDataClient {
    private LogAnalyticsDataClientService service;
    private AzureClient azureClient;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public LogAnalyticsDataClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public LogAnalyticsDataClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public LogAnalyticsDataClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public LogAnalyticsDataClientImpl(ServiceClientCredentials credentials) {
        this("https://api.loganalytics.io/v1", credentials);
    }

    public LogAnalyticsDataClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public LogAnalyticsDataClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "LogAnalyticsDataClient", "v1");
    }

    private void initializeService() {
        this.service = (LogAnalyticsDataClientService)this.restClient().retrofit().create(LogAnalyticsDataClientService.class);
    }

    @Override
    public QueryResults query(String workspaceId, QueryBody body) {
        return (QueryResults)((ServiceResponse)this.queryWithServiceResponseAsync(workspaceId, body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<QueryResults> queryAsync(String workspaceId, QueryBody body, ServiceCallback<QueryResults> serviceCallback) {
        return ServiceFuture.fromResponse(this.queryWithServiceResponseAsync(workspaceId, body), serviceCallback);
    }

    @Override
    public Observable<QueryResults> queryAsync(String workspaceId, QueryBody body) {
        return this.queryWithServiceResponseAsync(workspaceId, body).map((Func1)new Func1<ServiceResponse<QueryResults>, QueryResults>(){

            public QueryResults call(ServiceResponse<QueryResults> response) {
                return (QueryResults)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<QueryResults>> queryWithServiceResponseAsync(String workspaceId, QueryBody body) {
        if (workspaceId == null) {
            throw new IllegalArgumentException("Parameter workspaceId is required and cannot be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.query(workspaceId, body, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<QueryResults>>>(){

            public Observable<ServiceResponse<QueryResults>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LogAnalyticsDataClientImpl.this.queryDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<QueryResults> queryDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<QueryResults>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface LogAnalyticsDataClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.loganalytics.LogAnalyticsDataClient query"})
        @POST(value="workspaces/{workspaceId}/query")
        public Observable<Response<ResponseBody>> query(@Path(value="workspaceId") String var1, @Body QueryBody var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

