/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskCreateResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskUpdateResponse;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/**
* The Service Management API includes operations for managing the disks in your
* subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/jj157188.aspx for more
* information)
*/
public class VirtualMachineDiskOperationsImpl implements ServiceOperations<ComputeManagementClientImpl>, VirtualMachineDiskOperations {
    /**
    * Initializes a new instance of the VirtualMachineDiskOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    VirtualMachineDiskOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }
    
    private ComputeManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.compute.ComputeManagementClientImpl.
    * @return The Client value.
    */
    public ComputeManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Create Data Disk operation adds a data disk to a virtual machine.
    * There are three ways to create the data disk using the Add Data Disk
    * operation. Option 1 - Attach an empty data disk to the role by
    * specifying the disk label and location of the disk image. Do not include
    * the DiskName and SourceMediaLink elements in the request body. Include
    * the MediaLink element and reference a blob that is in the same
    * geographical region as the role. You can also omit the MediaLink
    * element. In this usage, Azure will create the data disk in the storage
    * account configured as default for the role. Option 2 - Attach an
    * existing data disk that is in the image repository. Do not include the
    * DiskName and SourceMediaLink elements in the request body. Specify the
    * data disk to use by including the DiskName element. Note: If included
    * the in the response body, the MediaLink and LogicalDiskSizeInGB elements
    * are ignored. Option 3 - Specify the location of a blob in your storage
    * account that contain a disk image to use. Include the SourceMediaLink
    * element. Note: If the MediaLink element isincluded, it is ignored.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157199.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to add the data disk to.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Data Disk operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginCreatingDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final VirtualMachineDataDiskCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginCreatingDataDisk(serviceName, deploymentName, roleName, parameters);
            }
         });
    }
    
    /**
    * The Create Data Disk operation adds a data disk to a virtual machine.
    * There are three ways to create the data disk using the Add Data Disk
    * operation. Option 1 - Attach an empty data disk to the role by
    * specifying the disk label and location of the disk image. Do not include
    * the DiskName and SourceMediaLink elements in the request body. Include
    * the MediaLink element and reference a blob that is in the same
    * geographical region as the role. You can also omit the MediaLink
    * element. In this usage, Azure will create the data disk in the storage
    * account configured as default for the role. Option 2 - Attach an
    * existing data disk that is in the image repository. Do not include the
    * DiskName and SourceMediaLink elements in the request body. Specify the
    * data disk to use by including the DiskName element. Note: If included
    * the in the response body, the MediaLink and LogicalDiskSizeInGB elements
    * are ignored. Option 3 - Specify the location of a blob in your storage
    * account that contain a disk image to use. Include the SourceMediaLink
    * element. Note: If the MediaLink element isincluded, it is ignored.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157199.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to add the data disk to.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Data Disk operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginCreatingDataDisk(String serviceName, String deploymentName, String roleName, VirtualMachineDataDiskCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getHostCaching() == null) {
            throw new NullPointerException("parameters.HostCaching");
        }
        if (parameters.getMediaLinkUri() == null) {
            throw new NullPointerException("parameters.MediaLinkUri");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreatingDataDiskAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roles/" + roleName.trim() + "/DataDisks";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element dataVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk");
        requestDoc.appendChild(dataVirtualHardDiskElement);
        
        Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
        hostCachingElement.appendChild(requestDoc.createTextNode(parameters.getHostCaching()));
        dataVirtualHardDiskElement.appendChild(hostCachingElement);
        
        if (parameters.getLabel() != null) {
            Element diskLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
            diskLabelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            dataVirtualHardDiskElement.appendChild(diskLabelElement);
        }
        
        if (parameters.getName() != null) {
            Element diskNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
            diskNameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            dataVirtualHardDiskElement.appendChild(diskNameElement);
        }
        
        if (parameters.getLogicalUnitNumber() != null) {
            Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
            lunElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getLogicalUnitNumber())));
            dataVirtualHardDiskElement.appendChild(lunElement);
        }
        
        Element logicalDiskSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
        logicalDiskSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getLogicalDiskSizeInGB())));
        dataVirtualHardDiskElement.appendChild(logicalDiskSizeInGBElement);
        
        Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
        mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
        dataVirtualHardDiskElement.appendChild(mediaLinkElement);
        
        if (parameters.getSourceMediaLinkUri() != null) {
            Element sourceMediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceMediaLink");
            sourceMediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getSourceMediaLinkUri().toString()));
            dataVirtualHardDiskElement.appendChild(sourceMediaLinkElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Deleting Data Disk operation removes the specified data disk
    * from a virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157179.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to delete the data disk
    * from.
    * @param logicalUnitNumber Required. The logical unit number of the disk.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginDeletingDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final int logicalUnitNumber, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginDeletingDataDisk(serviceName, deploymentName, roleName, logicalUnitNumber, deleteFromStorage);
            }
         });
    }
    
    /**
    * The Begin Deleting Data Disk operation removes the specified data disk
    * from a virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157179.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to delete the data disk
    * from.
    * @param logicalUnitNumber Required. The logical unit number of the disk.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginDeletingDataDisk(String serviceName, String deploymentName, String roleName, int logicalUnitNumber, boolean deleteFromStorage) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("logicalUnitNumber", logicalUnitNumber);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter(invocationId, this, "beginDeletingDataDiskAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roles/" + roleName.trim() + "/DataDisks/" + logicalUnitNumber + "?";
        if (deleteFromStorage == true) {
            url = url + "comp=" + "media";
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Create Data Disk operation adds a data disk to a virtual machine.
    * There are three ways to create the data disk using the Add Data Disk
    * operation. Option 1 - Attach an empty data disk to the role by
    * specifying the disk label and location of the disk image. Do not include
    * the DiskName and SourceMediaLink elements in the request body. Include
    * the MediaLink element and reference a blob that is in the same
    * geographical region as the role. You can also omit the MediaLink
    * element. In this usage, Azure will create the data disk in the storage
    * account configured as default for the role. Option 2 - Attach an
    * existing data disk that is in the image repository. Do not include the
    * DiskName and SourceMediaLink elements in the request body. Specify the
    * data disk to use by including the DiskName element. Note: If included
    * the in the response body, the MediaLink and LogicalDiskSizeInGB elements
    * are ignored. Option 3 - Specify the location of a blob in your storage
    * account that contain a disk image to use. Include the SourceMediaLink
    * element. Note: If the MediaLink element isincluded, it is ignored.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157199.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to add the data disk to.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Data Disk operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> createDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final VirtualMachineDataDiskCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return createDataDisk(serviceName, deploymentName, roleName, parameters);
            }
         });
    }
    
    /**
    * The Create Data Disk operation adds a data disk to a virtual machine.
    * There are three ways to create the data disk using the Add Data Disk
    * operation. Option 1 - Attach an empty data disk to the role by
    * specifying the disk label and location of the disk image. Do not include
    * the DiskName and SourceMediaLink elements in the request body. Include
    * the MediaLink element and reference a blob that is in the same
    * geographical region as the role. You can also omit the MediaLink
    * element. In this usage, Azure will create the data disk in the storage
    * account configured as default for the role. Option 2 - Attach an
    * existing data disk that is in the image repository. Do not include the
    * DiskName and SourceMediaLink elements in the request body. Specify the
    * data disk to use by including the DiskName element. Note: If included
    * the in the response body, the MediaLink and LogicalDiskSizeInGB elements
    * are ignored. Option 3 - Specify the location of a blob in your storage
    * account that contain a disk image to use. Include the SourceMediaLink
    * element. Note: If the MediaLink element isincluded, it is ignored.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157199.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to add the data disk to.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Data Disk operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse createDataDisk(String serviceName, String deploymentName, String roleName, VirtualMachineDataDiskCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createDataDiskAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getVirtualMachineDisksOperations().beginCreatingDataDiskAsync(serviceName, deploymentName, roleName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Create Disk operation adds a disk to the user image repository. The
    * disk can be an operating system disk or a data disk.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157178.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Disk operation.
    * @return A virtual machine disk associated with your subscription.
    */
    @Override
    public Future<VirtualMachineDiskCreateResponse> createDiskAsync(final VirtualMachineDiskCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDiskCreateResponse>() { 
            @Override
            public VirtualMachineDiskCreateResponse call() throws Exception {
                return createDisk(parameters);
            }
         });
    }
    
    /**
    * The Create Disk operation adds a disk to the user image repository. The
    * disk can be an operating system disk or a data disk.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157178.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine Disk operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A virtual machine disk associated with your subscription.
    */
    @Override
    public VirtualMachineDiskCreateResponse createDisk(VirtualMachineDiskCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getMediaLinkUri() == null) {
            throw new NullPointerException("parameters.MediaLinkUri");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createDiskAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element diskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Disk");
        requestDoc.appendChild(diskElement);
        
        if (parameters.getOperatingSystemType() != null) {
            Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
            osElement.appendChild(requestDoc.createTextNode(parameters.getOperatingSystemType()));
            diskElement.appendChild(osElement);
        }
        
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        diskElement.appendChild(labelElement);
        
        Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
        mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
        diskElement.appendChild(mediaLinkElement);
        
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        diskElement.appendChild(nameElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineDiskCreateResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDiskCreateResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
            
            Element diskElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Disk");
            if (diskElement2 != null) {
                Element osElement2 = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "OS");
                if (osElement2 != null) {
                    String osInstance;
                    osInstance = osElement2.getTextContent();
                    result.setOperatingSystem(osInstance);
                }
                
                Element labelElement2 = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "Label");
                if (labelElement2 != null) {
                    String labelInstance;
                    labelInstance = labelElement2.getTextContent();
                    result.setLabel(labelInstance);
                }
                
                Element affinityGroupElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "AffinityGroup");
                if (affinityGroupElement != null) {
                    String affinityGroupInstance;
                    affinityGroupInstance = affinityGroupElement.getTextContent();
                    result.setAffinityGroup(affinityGroupInstance);
                }
                
                Element locationElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "Location");
                if (locationElement != null) {
                    String locationInstance;
                    locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                
                Element logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                if (logicalDiskSizeInGBElement != null) {
                    int logicalDiskSizeInGBInstance;
                    logicalDiskSizeInGBInstance = DatatypeConverter.parseInt(logicalDiskSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalDiskSizeInGBInstance);
                }
                
                Element mediaLinkElement2 = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                if (mediaLinkElement2 != null) {
                    URI mediaLinkInstance;
                    mediaLinkInstance = new URI(mediaLinkElement2.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                
                Element nameElement2 = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                if (nameElement2 != null) {
                    String nameInstance;
                    nameInstance = nameElement2.getTextContent();
                    result.setName(nameInstance);
                }
                
                Element sourceImageNameElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "SourceImageName");
                if (sourceImageNameElement != null) {
                    String sourceImageNameInstance;
                    sourceImageNameInstance = sourceImageNameElement.getTextContent();
                    result.setSourceImageName(sourceImageNameInstance);
                }
                
                Element attachedToElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "AttachedTo");
                if (attachedToElement != null) {
                    VirtualMachineDiskCreateResponse.VirtualMachineDiskUsageDetails attachedToInstance = new VirtualMachineDiskCreateResponse.VirtualMachineDiskUsageDetails();
                    result.setUsageDetails(attachedToInstance);
                    
                    Element hostedServiceNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "HostedServiceName");
                    if (hostedServiceNameElement != null) {
                        String hostedServiceNameInstance;
                        hostedServiceNameInstance = hostedServiceNameElement.getTextContent();
                        attachedToInstance.setHostedServiceName(hostedServiceNameInstance);
                    }
                    
                    Element deploymentNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "DeploymentName");
                    if (deploymentNameElement != null) {
                        String deploymentNameInstance;
                        deploymentNameInstance = deploymentNameElement.getTextContent();
                        attachedToInstance.setDeploymentName(deploymentNameInstance);
                    }
                    
                    Element roleNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                    if (roleNameElement != null) {
                        String roleNameInstance;
                        roleNameInstance = roleNameElement.getTextContent();
                        attachedToInstance.setRoleName(roleNameInstance);
                    }
                }
                
                Element isPremiumElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "IsPremium");
                if (isPremiumElement != null && (isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty() == true) == false) {
                    boolean isPremiumInstance;
                    isPremiumInstance = DatatypeConverter.parseBoolean(isPremiumElement.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                
                Element iOTypeElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "IOType");
                if (iOTypeElement != null) {
                    String iOTypeInstance;
                    iOTypeInstance = iOTypeElement.getTextContent();
                    result.setIOType(iOTypeInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Delete Data Disk operation removes the specified data disk from a
    * virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157179.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to delete the data disk
    * from.
    * @param logicalUnitNumber Required. The logical unit number of the disk.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> deleteDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final int logicalUnitNumber, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return deleteDataDisk(serviceName, deploymentName, roleName, logicalUnitNumber, deleteFromStorage);
            }
         });
    }
    
    /**
    * The Delete Data Disk operation removes the specified data disk from a
    * virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157179.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to delete the data disk
    * from.
    * @param logicalUnitNumber Required. The logical unit number of the disk.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse deleteDataDisk(String serviceName, String deploymentName, String roleName, int logicalUnitNumber, boolean deleteFromStorage) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("logicalUnitNumber", logicalUnitNumber);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter(invocationId, this, "deleteDataDiskAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getVirtualMachineDisksOperations().beginDeletingDataDiskAsync(serviceName, deploymentName, roleName, logicalUnitNumber, deleteFromStorage).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete Disk operation deletes the specified data or operating system
    * disk from your image repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157200.aspx for
    * more information)
    *
    * @param name Required. The name of the disk to delete.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteDiskAsync(final String name, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteDisk(name, deleteFromStorage);
            }
         });
    }
    
    /**
    * The Delete Disk operation deletes the specified data or operating system
    * disk from your image repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157200.aspx for
    * more information)
    *
    * @param name Required. The name of the disk to delete.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteDisk(String name, boolean deleteFromStorage) throws IOException, ServiceException {
        // Validate
        if (name == null) {
            throw new NullPointerException("name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("name", name);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter(invocationId, this, "deleteDiskAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks/" + name.trim() + "?";
        if (deleteFromStorage == true) {
            url = url + "comp=" + "media";
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Data Disk operation retrieves the specified data disk from a
    * virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157180.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role.
    * @param logicalUnitNumber Required. The logical unit number of the disk.
    * @return The Get Data Disk operation response.
    */
    @Override
    public Future<VirtualMachineDataDiskGetResponse> getDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final int logicalUnitNumber) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDataDiskGetResponse>() { 
            @Override
            public VirtualMachineDataDiskGetResponse call() throws Exception {
                return getDataDisk(serviceName, deploymentName, roleName, logicalUnitNumber);
            }
         });
    }
    
    /**
    * The Get Data Disk operation retrieves the specified data disk from a
    * virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157180.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role.
    * @param logicalUnitNumber Required. The logical unit number of the disk.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Data Disk operation response.
    */
    @Override
    public VirtualMachineDataDiskGetResponse getDataDisk(String serviceName, String deploymentName, String roleName, int logicalUnitNumber) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("logicalUnitNumber", logicalUnitNumber);
            CloudTracing.enter(invocationId, this, "getDataDiskAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roles/" + roleName.trim() + "/DataDisks/" + logicalUnitNumber;
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineDataDiskGetResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDataDiskGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element dataVirtualHardDiskElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk");
            if (dataVirtualHardDiskElement != null) {
                Element hostCachingElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "HostCaching");
                if (hostCachingElement != null) {
                    String hostCachingInstance;
                    hostCachingInstance = hostCachingElement.getTextContent();
                    result.setHostCaching(hostCachingInstance);
                }
                
                Element diskLabelElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "DiskLabel");
                if (diskLabelElement != null) {
                    String diskLabelInstance;
                    diskLabelInstance = diskLabelElement.getTextContent();
                    result.setLabel(diskLabelInstance);
                }
                
                Element diskNameElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "DiskName");
                if (diskNameElement != null) {
                    String diskNameInstance;
                    diskNameInstance = diskNameElement.getTextContent();
                    result.setName(diskNameInstance);
                }
                
                Element lunElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "Lun");
                if (lunElement != null && (lunElement.getTextContent() == null || lunElement.getTextContent().isEmpty() == true) == false) {
                    int lunInstance;
                    lunInstance = DatatypeConverter.parseInt(lunElement.getTextContent());
                    result.setLogicalUnitNumber(lunInstance);
                }
                
                Element logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                if (logicalDiskSizeInGBElement != null) {
                    int logicalDiskSizeInGBInstance;
                    logicalDiskSizeInGBInstance = DatatypeConverter.parseInt(logicalDiskSizeInGBElement.getTextContent());
                    result.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                }
                
                Element mediaLinkElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                if (mediaLinkElement != null) {
                    URI mediaLinkInstance;
                    mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                
                Element iOTypeElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "IOType");
                if (iOTypeElement != null) {
                    String iOTypeInstance;
                    iOTypeInstance = iOTypeElement.getTextContent();
                    result.setIOType(iOTypeInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Disk operation retrieves a disk from the user image repository.
    * The disk can be an operating system disk or a data disk.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157178.aspx for
    * more information)
    *
    * @param name Required. The name of the disk.
    * @return A virtual machine disk associated with your subscription.
    */
    @Override
    public Future<VirtualMachineDiskGetResponse> getDiskAsync(final String name) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDiskGetResponse>() { 
            @Override
            public VirtualMachineDiskGetResponse call() throws Exception {
                return getDisk(name);
            }
         });
    }
    
    /**
    * The Get Disk operation retrieves a disk from the user image repository.
    * The disk can be an operating system disk or a data disk.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157178.aspx for
    * more information)
    *
    * @param name Required. The name of the disk.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A virtual machine disk associated with your subscription.
    */
    @Override
    public VirtualMachineDiskGetResponse getDisk(String name) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (name == null) {
            throw new NullPointerException("name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("name", name);
            CloudTracing.enter(invocationId, this, "getDiskAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks/" + name.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineDiskGetResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDiskGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element diskElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Disk");
            if (diskElement != null) {
                Element affinityGroupElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "AffinityGroup");
                if (affinityGroupElement != null) {
                    String affinityGroupInstance;
                    affinityGroupInstance = affinityGroupElement.getTextContent();
                    result.setAffinityGroup(affinityGroupInstance);
                }
                
                Element locationElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "Location");
                if (locationElement != null) {
                    String locationInstance;
                    locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                
                Element labelElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "Label");
                if (labelElement != null) {
                    String labelInstance;
                    labelInstance = labelElement.getTextContent();
                    result.setLabel(labelInstance);
                }
                
                Element logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                if (logicalDiskSizeInGBElement != null) {
                    int logicalDiskSizeInGBInstance;
                    logicalDiskSizeInGBInstance = DatatypeConverter.parseInt(logicalDiskSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalDiskSizeInGBInstance);
                }
                
                Element mediaLinkElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                if (mediaLinkElement != null) {
                    URI mediaLinkInstance;
                    mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                
                Element nameElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "Name");
                if (nameElement != null) {
                    String nameInstance;
                    nameInstance = nameElement.getTextContent();
                    result.setName(nameInstance);
                }
                
                Element osElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "OS");
                if (osElement != null) {
                    String osInstance;
                    osInstance = osElement.getTextContent();
                    result.setOperatingSystemType(osInstance);
                }
                
                Element sourceImageNameElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "SourceImageName");
                if (sourceImageNameElement != null) {
                    String sourceImageNameInstance;
                    sourceImageNameInstance = sourceImageNameElement.getTextContent();
                    result.setSourceImageName(sourceImageNameInstance);
                }
                
                Element attachedToElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "AttachedTo");
                if (attachedToElement != null) {
                    VirtualMachineDiskGetResponse.VirtualMachineDiskUsageDetails attachedToInstance = new VirtualMachineDiskGetResponse.VirtualMachineDiskUsageDetails();
                    result.setUsageDetails(attachedToInstance);
                    
                    Element hostedServiceNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "HostedServiceName");
                    if (hostedServiceNameElement != null) {
                        String hostedServiceNameInstance;
                        hostedServiceNameInstance = hostedServiceNameElement.getTextContent();
                        attachedToInstance.setHostedServiceName(hostedServiceNameInstance);
                    }
                    
                    Element deploymentNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "DeploymentName");
                    if (deploymentNameElement != null) {
                        String deploymentNameInstance;
                        deploymentNameInstance = deploymentNameElement.getTextContent();
                        attachedToInstance.setDeploymentName(deploymentNameInstance);
                    }
                    
                    Element roleNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                    if (roleNameElement != null) {
                        String roleNameInstance;
                        roleNameInstance = roleNameElement.getTextContent();
                        attachedToInstance.setRoleName(roleNameInstance);
                    }
                }
                
                Element isCorruptedElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "IsCorrupted");
                if (isCorruptedElement != null && (isCorruptedElement.getTextContent() == null || isCorruptedElement.getTextContent().isEmpty() == true) == false) {
                    boolean isCorruptedInstance;
                    isCorruptedInstance = DatatypeConverter.parseBoolean(isCorruptedElement.getTextContent().toLowerCase());
                    result.setIsCorrupted(isCorruptedInstance);
                }
                
                Element isPremiumElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "IsPremium");
                if (isPremiumElement != null && (isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty() == true) == false) {
                    boolean isPremiumInstance;
                    isPremiumInstance = DatatypeConverter.parseBoolean(isPremiumElement.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                
                Element iOTypeElement = XmlUtility.getElementByTagNameNS(diskElement, "http://schemas.microsoft.com/windowsazure", "IOType");
                if (iOTypeElement != null) {
                    String iOTypeInstance;
                    iOTypeInstance = iOTypeElement.getTextContent();
                    result.setIOType(iOTypeInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List Disks operation retrieves a list of the disks in your image
    * repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157176.aspx for
    * more information)
    *
    * @return The List Disks operation response.
    */
    @Override
    public Future<VirtualMachineDiskListResponse> listDisksAsync() {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDiskListResponse>() { 
            @Override
            public VirtualMachineDiskListResponse call() throws Exception {
                return listDisks();
            }
         });
    }
    
    /**
    * The List Disks operation retrieves a list of the disks in your image
    * repository.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157176.aspx for
    * more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Disks operation response.
    */
    @Override
    public VirtualMachineDiskListResponse listDisks() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listDisksAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineDiskListResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDiskListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element disksSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Disks");
            if (disksSequenceElement != null) {
                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(disksSequenceElement, "http://schemas.microsoft.com/windowsazure", "Disk").size(); i1 = i1 + 1) {
                    org.w3c.dom.Element disksElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(disksSequenceElement, "http://schemas.microsoft.com/windowsazure", "Disk").get(i1));
                    VirtualMachineDiskListResponse.VirtualMachineDisk diskInstance = new VirtualMachineDiskListResponse.VirtualMachineDisk();
                    result.getDisks().add(diskInstance);
                    
                    Element affinityGroupElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "AffinityGroup");
                    if (affinityGroupElement != null) {
                        String affinityGroupInstance;
                        affinityGroupInstance = affinityGroupElement.getTextContent();
                        diskInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    
                    Element locationElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "Location");
                    if (locationElement != null) {
                        String locationInstance;
                        locationInstance = locationElement.getTextContent();
                        diskInstance.setLocation(locationInstance);
                    }
                    
                    Element labelElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "Label");
                    if (labelElement != null) {
                        String labelInstance;
                        labelInstance = labelElement.getTextContent();
                        diskInstance.setLabel(labelInstance);
                    }
                    
                    Element logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                    if (logicalDiskSizeInGBElement != null) {
                        int logicalDiskSizeInGBInstance;
                        logicalDiskSizeInGBInstance = DatatypeConverter.parseInt(logicalDiskSizeInGBElement.getTextContent());
                        diskInstance.setLogicalSizeInGB(logicalDiskSizeInGBInstance);
                    }
                    
                    Element mediaLinkElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                    if (mediaLinkElement != null) {
                        URI mediaLinkInstance;
                        mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                        diskInstance.setMediaLinkUri(mediaLinkInstance);
                    }
                    
                    Element nameElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement != null) {
                        String nameInstance;
                        nameInstance = nameElement.getTextContent();
                        diskInstance.setName(nameInstance);
                    }
                    
                    Element osElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "OS");
                    if (osElement != null) {
                        String osInstance;
                        osInstance = osElement.getTextContent();
                        diskInstance.setOperatingSystemType(osInstance);
                    }
                    
                    Element sourceImageNameElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "SourceImageName");
                    if (sourceImageNameElement != null) {
                        String sourceImageNameInstance;
                        sourceImageNameInstance = sourceImageNameElement.getTextContent();
                        diskInstance.setSourceImageName(sourceImageNameInstance);
                    }
                    
                    Element attachedToElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "AttachedTo");
                    if (attachedToElement != null) {
                        VirtualMachineDiskListResponse.VirtualMachineDiskUsageDetails attachedToInstance = new VirtualMachineDiskListResponse.VirtualMachineDiskUsageDetails();
                        diskInstance.setUsageDetails(attachedToInstance);
                        
                        Element hostedServiceNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "HostedServiceName");
                        if (hostedServiceNameElement != null) {
                            String hostedServiceNameInstance;
                            hostedServiceNameInstance = hostedServiceNameElement.getTextContent();
                            attachedToInstance.setHostedServiceName(hostedServiceNameInstance);
                        }
                        
                        Element deploymentNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "DeploymentName");
                        if (deploymentNameElement != null) {
                            String deploymentNameInstance;
                            deploymentNameInstance = deploymentNameElement.getTextContent();
                            attachedToInstance.setDeploymentName(deploymentNameInstance);
                        }
                        
                        Element roleNameElement = XmlUtility.getElementByTagNameNS(attachedToElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                        if (roleNameElement != null) {
                            String roleNameInstance;
                            roleNameInstance = roleNameElement.getTextContent();
                            attachedToInstance.setRoleName(roleNameInstance);
                        }
                    }
                    
                    Element isCorruptedElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "IsCorrupted");
                    if (isCorruptedElement != null && (isCorruptedElement.getTextContent() == null || isCorruptedElement.getTextContent().isEmpty() == true) == false) {
                        boolean isCorruptedInstance;
                        isCorruptedInstance = DatatypeConverter.parseBoolean(isCorruptedElement.getTextContent().toLowerCase());
                        diskInstance.setIsCorrupted(isCorruptedInstance);
                    }
                    
                    Element isPremiumElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "IsPremium");
                    if (isPremiumElement != null && (isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty() == true) == false) {
                        boolean isPremiumInstance;
                        isPremiumInstance = DatatypeConverter.parseBoolean(isPremiumElement.getTextContent().toLowerCase());
                        diskInstance.setIsPremium(isPremiumInstance);
                    }
                    
                    Element iOTypeElement = XmlUtility.getElementByTagNameNS(disksElement, "http://schemas.microsoft.com/windowsazure", "IOType");
                    if (iOTypeElement != null) {
                        String iOTypeInstance;
                        iOTypeInstance = iOTypeElement.getTextContent();
                        diskInstance.setIOType(iOTypeInstance);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Update Data Disk operation updates the specified data disk attached
    * to the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157190.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to add the data disk to.
    * @param logicalUnitNumber Required. The logical unit number of the disk.
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Data Disk operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> updateDataDiskAsync(final String serviceName, final String deploymentName, final String roleName, final int logicalUnitNumber, final VirtualMachineDataDiskUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return updateDataDisk(serviceName, deploymentName, roleName, logicalUnitNumber, parameters);
            }
         });
    }
    
    /**
    * The Update Data Disk operation updates the specified data disk attached
    * to the specified virtual machine.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157190.aspx for
    * more information)
    *
    * @param serviceName Required. The name of your service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleName Required. The name of the role to add the data disk to.
    * @param logicalUnitNumber Required. The logical unit number of the disk.
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Data Disk operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse updateDataDisk(String serviceName, String deploymentName, String roleName, int logicalUnitNumber, VirtualMachineDataDiskUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleName == null) {
            throw new NullPointerException("roleName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getHostCaching() == null) {
            throw new NullPointerException("parameters.HostCaching");
        }
        if (parameters.getMediaLinkUri() == null) {
            throw new NullPointerException("parameters.MediaLinkUri");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleName", roleName);
            tracingParameters.put("logicalUnitNumber", logicalUnitNumber);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateDataDiskAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roles/" + roleName.trim() + "/DataDisks/" + logicalUnitNumber;
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element dataVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk");
        requestDoc.appendChild(dataVirtualHardDiskElement);
        
        Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
        hostCachingElement.appendChild(requestDoc.createTextNode(parameters.getHostCaching()));
        dataVirtualHardDiskElement.appendChild(hostCachingElement);
        
        if (parameters.getLabel() != null) {
            Element diskLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
            diskLabelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            dataVirtualHardDiskElement.appendChild(diskLabelElement);
        }
        
        if (parameters.getName() != null) {
            Element diskNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
            diskNameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            dataVirtualHardDiskElement.appendChild(diskNameElement);
        }
        
        if (parameters.getLogicalUnitNumber() != null) {
            Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
            lunElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getLogicalUnitNumber())));
            dataVirtualHardDiskElement.appendChild(lunElement);
        }
        
        Element logicalDiskSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
        logicalDiskSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getLogicalDiskSizeInGB())));
        dataVirtualHardDiskElement.appendChild(logicalDiskSizeInGBElement);
        
        Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
        mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
        dataVirtualHardDiskElement.appendChild(mediaLinkElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Add Disk operation adds a disk to the user image repository. The disk
    * can be an operating system disk or a data disk.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157178.aspx for
    * more information)
    *
    * @param name Required. The name of the disk being updated.
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Disk operation.
    * @return A virtual machine disk associated with your subscription.
    */
    @Override
    public Future<VirtualMachineDiskUpdateResponse> updateDiskAsync(final String name, final VirtualMachineDiskUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineDiskUpdateResponse>() { 
            @Override
            public VirtualMachineDiskUpdateResponse call() throws Exception {
                return updateDisk(name, parameters);
            }
         });
    }
    
    /**
    * The Add Disk operation adds a disk to the user image repository. The disk
    * can be an operating system disk or a data disk.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157178.aspx for
    * more information)
    *
    * @param name Required. The name of the disk being updated.
    * @param parameters Required. Parameters supplied to the Update Virtual
    * Machine Disk operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A virtual machine disk associated with your subscription.
    */
    @Override
    public VirtualMachineDiskUpdateResponse updateDisk(String name, VirtualMachineDiskUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        // Validate
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("name", name);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateDiskAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/disks/" + name.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element diskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Disk");
        requestDoc.appendChild(diskElement);
        
        if (parameters.isHasOperatingSystem() != null) {
            Element hasOperatingSystemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HasOperatingSystem");
            hasOperatingSystemElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isHasOperatingSystem()).toLowerCase()));
            diskElement.appendChild(hasOperatingSystemElement);
        }
        
        if (parameters.getOperatingSystemType() != null) {
            Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
            osElement.appendChild(requestDoc.createTextNode(parameters.getOperatingSystemType()));
            diskElement.appendChild(osElement);
        }
        
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        diskElement.appendChild(labelElement);
        
        if (parameters.getMediaLinkUri() != null) {
            Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
            mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
            diskElement.appendChild(mediaLinkElement);
        }
        
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        diskElement.appendChild(nameElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineDiskUpdateResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineDiskUpdateResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
            
            Element diskElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Disk");
            if (diskElement2 != null) {
                Element osElement2 = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "OS");
                if (osElement2 != null) {
                    String osInstance;
                    osInstance = osElement2.getTextContent();
                    result.setOperatingSystem(osInstance);
                }
                
                Element labelElement2 = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "Label");
                if (labelElement2 != null) {
                    String labelInstance;
                    labelInstance = labelElement2.getTextContent();
                    result.setLabel(labelInstance);
                }
                
                Element affinityGroupElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "AffinityGroup");
                if (affinityGroupElement != null) {
                    String affinityGroupInstance;
                    affinityGroupInstance = affinityGroupElement.getTextContent();
                    result.setAffinityGroup(affinityGroupInstance);
                }
                
                Element locationElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "Location");
                if (locationElement != null) {
                    String locationInstance;
                    locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                
                Element logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                if (logicalDiskSizeInGBElement != null) {
                    int logicalDiskSizeInGBInstance;
                    logicalDiskSizeInGBInstance = DatatypeConverter.parseInt(logicalDiskSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalDiskSizeInGBInstance);
                }
                
                Element mediaLinkElement2 = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                if (mediaLinkElement2 != null) {
                    URI mediaLinkInstance;
                    mediaLinkInstance = new URI(mediaLinkElement2.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                
                Element nameElement2 = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                if (nameElement2 != null) {
                    String nameInstance;
                    nameInstance = nameElement2.getTextContent();
                    result.setName(nameInstance);
                }
                
                Element isPremiumElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "IsPremium");
                if (isPremiumElement != null && (isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty() == true) == false) {
                    boolean isPremiumInstance;
                    isPremiumInstance = DatatypeConverter.parseBoolean(isPremiumElement.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                
                Element iOTypeElement = XmlUtility.getElementByTagNameNS(diskElement2, "http://schemas.microsoft.com/windowsazure", "IOType");
                if (iOTypeElement != null) {
                    String iOTypeInstance;
                    iOTypeInstance = iOTypeElement.getTextContent();
                    result.setIOType(iOTypeInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
