/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyHashMap;
import java.util.HashMap;

/**
* Parameters supplied to the Update Hosted Service operation.
*/
public class HostedServiceUpdateParameters {
    private String description;
    
    /**
    * Optional. A description for the cloud service. The description may be up
    * to 1024 characters in length. You must specify a value for at least one
    * of Label or Description.
    * @return The Description value.
    */
    public String getDescription() {
        return this.description;
    }
    
    /**
    * Optional. A description for the cloud service. The description may be up
    * to 1024 characters in length. You must specify a value for at least one
    * of Label or Description.
    * @param descriptionValue The Description value.
    */
    public void setDescription(final String descriptionValue) {
        this.description = descriptionValue;
    }
    
    private HashMap<String, String> extendedProperties;
    
    /**
    * Optional. Represents the name of an extended cloud service property. Each
    * extended property must have a defined name and a value. You can have a
    * maximum of 50 extended property name and value pairs. The maximum length
    * of the name element is 64 characters, only alphanumeric characters and
    * underscores are valid in the name, and it must start with a letter.
    * Attempting to use other characters, starting with a non-letter
    * character, or entering a name that is identical to that of another
    * extended property owned by the same service will result in a status code
    * 400 (Bad Request) error. Each extended property value has a maximum
    * length of 255 characters.
    * @return The ExtendedProperties value.
    */
    public HashMap<String, String> getExtendedProperties() {
        return this.extendedProperties;
    }
    
    /**
    * Optional. Represents the name of an extended cloud service property. Each
    * extended property must have a defined name and a value. You can have a
    * maximum of 50 extended property name and value pairs. The maximum length
    * of the name element is 64 characters, only alphanumeric characters and
    * underscores are valid in the name, and it must start with a letter.
    * Attempting to use other characters, starting with a non-letter
    * character, or entering a name that is identical to that of another
    * extended property owned by the same service will result in a status code
    * 400 (Bad Request) error. Each extended property value has a maximum
    * length of 255 characters.
    * @param extendedPropertiesValue The ExtendedProperties value.
    */
    public void setExtendedProperties(final HashMap<String, String> extendedPropertiesValue) {
        this.extendedProperties = extendedPropertiesValue;
    }
    
    private String label;
    
    /**
    * Optional. A name for the cloud service. The name may be up to 100
    * characters in length. You must specify a value for at least one of Label
    * or Description. It is recommended that the label be unique within the
    * subscription. The name can be used identify the service for your
    * tracking purposes.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. A name for the cloud service. The name may be up to 100
    * characters in length. You must specify a value for at least one of Label
    * or Description. It is recommended that the label be unique within the
    * subscription. The name can be used identify the service for your
    * tracking purposes.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private String reverseDnsFqdn;
    
    /**
    * Optional. Dns address to which the cloud service's IP address resolves
    * when queried using a reverse Dns query.
    * @return The ReverseDnsFqdn value.
    */
    public String getReverseDnsFqdn() {
        return this.reverseDnsFqdn;
    }
    
    /**
    * Optional. Dns address to which the cloud service's IP address resolves
    * when queried using a reverse Dns query.
    * @param reverseDnsFqdnValue The ReverseDnsFqdn value.
    */
    public void setReverseDnsFqdn(final String reverseDnsFqdnValue) {
        this.reverseDnsFqdn = reverseDnsFqdnValue;
    }
    
    /**
    * Initializes a new instance of the HostedServiceUpdateParameters class.
    *
    */
    public HostedServiceUpdateParameters() {
        this.setExtendedProperties(new LazyHashMap<String, String>());
    }
}
