/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import java.util.ArrayList;
import java.util.Calendar;

/**
* The status information of the settings passed to the Resource Extension.
*/
public class ResourceExtensionConfigurationStatus {
    private Integer code;
    
    /**
    * Optional. Integer status code from the result of applying the
    * configuration settings.
    * @return The Code value.
    */
    public Integer getCode() {
        return this.code;
    }
    
    /**
    * Optional. Integer status code from the result of applying the
    * configuration settings.
    * @param codeValue The Code value.
    */
    public void setCode(final Integer codeValue) {
        this.code = codeValue;
    }
    
    private Calendar configurationAppliedTime;
    
    /**
    * Optional. UTC time at which the configuration was applied.
    * @return The ConfigurationAppliedTime value.
    */
    public Calendar getConfigurationAppliedTime() {
        return this.configurationAppliedTime;
    }
    
    /**
    * Optional. UTC time at which the configuration was applied.
    * @param configurationAppliedTimeValue The ConfigurationAppliedTime value.
    */
    public void setConfigurationAppliedTime(final Calendar configurationAppliedTimeValue) {
        this.configurationAppliedTime = configurationAppliedTimeValue;
    }
    
    private GuestAgentFormattedMessage formattedMessage;
    
    /**
    * Optional. This object encapsulates a formatted localized status message.
    * @return The FormattedMessage value.
    */
    public GuestAgentFormattedMessage getFormattedMessage() {
        return this.formattedMessage;
    }
    
    /**
    * Optional. This object encapsulates a formatted localized status message.
    * @param formattedMessageValue The FormattedMessage value.
    */
    public void setFormattedMessage(final GuestAgentFormattedMessage formattedMessageValue) {
        this.formattedMessage = formattedMessageValue;
    }
    
    private GuestAgentMessage message;
    
    /**
    * Optional. This object encapsulates a localized status message.
    * @return The Message value.
    */
    public GuestAgentMessage getMessage() {
        return this.message;
    }
    
    /**
    * Optional. This object encapsulates a localized status message.
    * @param messageValue The Message value.
    */
    public void setMessage(final GuestAgentMessage messageValue) {
        this.message = messageValue;
    }
    
    private String name;
    
    /**
    * Optional. Name of the settings passed to the Resource Extension.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Name of the settings passed to the Resource Extension.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String operation;
    
    /**
    * Optional. Operation executed by the Resource Extension for the settings
    * passed to it.
    * @return The Operation value.
    */
    public String getOperation() {
        return this.operation;
    }
    
    /**
    * Optional. Operation executed by the Resource Extension for the settings
    * passed to it.
    * @param operationValue The Operation value.
    */
    public void setOperation(final String operationValue) {
        this.operation = operationValue;
    }
    
    private String status;
    
    /**
    * Optional. The status of the resourse extension, containing values like
    * Transitioning, Error, Success, or Warning.
    * @return The Status value.
    */
    public String getStatus() {
        return this.status;
    }
    
    /**
    * Optional. The status of the resourse extension, containing values like
    * Transitioning, Error, Success, or Warning.
    * @param statusValue The Status value.
    */
    public void setStatus(final String statusValue) {
        this.status = statusValue;
    }
    
    private ArrayList<ResourceExtensionSubStatus> subStatusList;
    
    /**
    * Optional. List of substatus objects which contain additional status
    * information reported by the Resource Extension.
    * @return The SubStatusList value.
    */
    public ArrayList<ResourceExtensionSubStatus> getSubStatusList() {
        return this.subStatusList;
    }
    
    /**
    * Optional. List of substatus objects which contain additional status
    * information reported by the Resource Extension.
    * @param subStatusListValue The SubStatusList value.
    */
    public void setSubStatusList(final ArrayList<ResourceExtensionSubStatus> subStatusListValue) {
        this.subStatusList = subStatusListValue;
    }
    
    private Calendar timestamp;
    
    /**
    * Optional. UTC time at which the status was reported.
    * @return The Timestamp value.
    */
    public Calendar getTimestamp() {
        return this.timestamp;
    }
    
    /**
    * Optional. UTC time at which the status was reported.
    * @param timestampValue The Timestamp value.
    */
    public void setTimestamp(final Calendar timestampValue) {
        this.timestamp = timestampValue;
    }
    
    /**
    * Initializes a new instance of the ResourceExtensionConfigurationStatus
    * class.
    *
    */
    public ResourceExtensionConfigurationStatus() {
        this.setSubStatusList(new LazyArrayList<ResourceExtensionSubStatus>());
    }
}
