/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import java.util.ArrayList;

/**
* Specifies the properties of a resource extension that should be installed on
* the Virtual Machine.
*/
public class ResourceExtensionReference {
    private String name;
    
    /**
    * Optional. Specifies the name of the resource extension. You can use List
    * Resource Extensions to find the names of available resource extensions.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Specifies the name of the resource extension. You can use List
    * Resource Extensions to find the names of available resource extensions.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String publisher;
    
    /**
    * Optional. Specifies the name of the publisher who created the resource
    * extension. You can use List Resource Extensions to find the publisher
    * name of a resource extension.
    * @return The Publisher value.
    */
    public String getPublisher() {
        return this.publisher;
    }
    
    /**
    * Optional. Specifies the name of the publisher who created the resource
    * extension. You can use List Resource Extensions to find the publisher
    * name of a resource extension.
    * @param publisherValue The Publisher value.
    */
    public void setPublisher(final String publisherValue) {
        this.publisher = publisherValue;
    }
    
    private String referenceName;
    
    /**
    * Optional. Specifies the reference name of the resource extension.
    * @return The ReferenceName value.
    */
    public String getReferenceName() {
        return this.referenceName;
    }
    
    /**
    * Optional. Specifies the reference name of the resource extension.
    * @param referenceNameValue The ReferenceName value.
    */
    public void setReferenceName(final String referenceNameValue) {
        this.referenceName = referenceNameValue;
    }
    
    private ArrayList<ResourceExtensionParameterValue> resourceExtensionParameterValues;
    
    /**
    * Optional. Contains a collection of parameters that are passed to the
    * resource extension when it is installed.
    * @return The ResourceExtensionParameterValues value.
    */
    public ArrayList<ResourceExtensionParameterValue> getResourceExtensionParameterValues() {
        return this.resourceExtensionParameterValues;
    }
    
    /**
    * Optional. Contains a collection of parameters that are passed to the
    * resource extension when it is installed.
    * @param resourceExtensionParameterValuesValue The
    * ResourceExtensionParameterValues value.
    */
    public void setResourceExtensionParameterValues(final ArrayList<ResourceExtensionParameterValue> resourceExtensionParameterValuesValue) {
        this.resourceExtensionParameterValues = resourceExtensionParameterValuesValue;
    }
    
    private String state;
    
    /**
    * Optional. Specifies the state of the resource extension.Possible values
    * are: Enable | Disable. The default value is Enable.
    * @return The State value.
    */
    public String getState() {
        return this.state;
    }
    
    /**
    * Optional. Specifies the state of the resource extension.Possible values
    * are: Enable | Disable. The default value is Enable.
    * @param stateValue The State value.
    */
    public void setState(final String stateValue) {
        this.state = stateValue;
    }
    
    private String version;
    
    /**
    * Optional. Specifies the version of the resource extension. You can use
    * List Resource Extension Versions to find the version of the resource
    * extension.
    * @return The Version value.
    */
    public String getVersion() {
        return this.version;
    }
    
    /**
    * Optional. Specifies the version of the resource extension. You can use
    * List Resource Extension Versions to find the version of the resource
    * extension.
    * @param versionValue The Version value.
    */
    public void setVersion(final String versionValue) {
        this.version = versionValue;
    }
    
    /**
    * Initializes a new instance of the ResourceExtensionReference class.
    *
    */
    public ResourceExtensionReference() {
        this.setResourceExtensionParameterValues(new LazyArrayList<ResourceExtensionParameterValue>());
    }
}
