/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* A substatus object containing additional status information reported by the
* Resource Extension.
*/
public class ResourceExtensionSubStatus {
    private Integer code;
    
    /**
    * Optional. Integer status code from the result of applying the substatus
    * settings.
    * @return The Code value.
    */
    public Integer getCode() {
        return this.code;
    }
    
    /**
    * Optional. Integer status code from the result of applying the substatus
    * settings.
    * @param codeValue The Code value.
    */
    public void setCode(final Integer codeValue) {
        this.code = codeValue;
    }
    
    private GuestAgentFormattedMessage formattedMessage;
    
    /**
    * Optional. This object encapsulates a formatted localized status message.
    * @return The FormattedMessage value.
    */
    public GuestAgentFormattedMessage getFormattedMessage() {
        return this.formattedMessage;
    }
    
    /**
    * Optional. This object encapsulates a formatted localized status message.
    * @param formattedMessageValue The FormattedMessage value.
    */
    public void setFormattedMessage(final GuestAgentFormattedMessage formattedMessageValue) {
        this.formattedMessage = formattedMessageValue;
    }
    
    private GuestAgentMessage message;
    
    /**
    * Optional. This object encapsulates a localized status message.
    * @return The Message value.
    */
    public GuestAgentMessage getMessage() {
        return this.message;
    }
    
    /**
    * Optional. This object encapsulates a localized status message.
    * @param messageValue The Message value.
    */
    public void setMessage(final GuestAgentMessage messageValue) {
        this.message = messageValue;
    }
    
    private String name;
    
    /**
    * Optional. A name for the substatus.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. A name for the substatus.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String status;
    
    /**
    * Optional. The resource extension substatus, containing values like
    * Transitioning, Error, Success, or Warning.
    * @return The Status value.
    */
    public String getStatus() {
        return this.status;
    }
    
    /**
    * Optional. The resource extension substatus, containing values like
    * Transitioning, Error, Success, or Warning.
    * @param statusValue The Status value.
    */
    public void setStatus(final String statusValue) {
        this.status = statusValue;
    }
}
