/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

/**
* The List Resource Extensions operation response.
*/
public class VirtualMachineExtensionListResponse extends OperationResponse implements Iterable<VirtualMachineExtensionListResponse.ResourceExtension> {
    private ArrayList<VirtualMachineExtensionListResponse.ResourceExtension> resourceExtensions;
    
    /**
    * Optional. The extensions that are available to add to your cloud service.
    * @return The ResourceExtensions value.
    */
    public ArrayList<VirtualMachineExtensionListResponse.ResourceExtension> getResourceExtensions() {
        return this.resourceExtensions;
    }
    
    /**
    * Optional. The extensions that are available to add to your cloud service.
    * @param resourceExtensionsValue The ResourceExtensions value.
    */
    public void setResourceExtensions(final ArrayList<VirtualMachineExtensionListResponse.ResourceExtension> resourceExtensionsValue) {
        this.resourceExtensions = resourceExtensionsValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineExtensionListResponse
    * class.
    *
    */
    public VirtualMachineExtensionListResponse() {
        super();
        this.setResourceExtensions(new LazyArrayList<VirtualMachineExtensionListResponse.ResourceExtension>());
    }
    
    /**
    * Gets the sequence of ResourceExtensions.
    *
    */
    public Iterator<VirtualMachineExtensionListResponse.ResourceExtension> iterator() {
        return this.getResourceExtensions().iterator();
    }
    
    /**
    * An extension available to add to your virtual machine.
    */
    public static class ResourceExtension {
        private String companyName;
        
        /**
        * Optional. String property containing the name of the
        * company/organization who publishes the extension.
        * @return The CompanyName value.
        */
        public String getCompanyName() {
            return this.companyName;
        }
        
        /**
        * Optional. String property containing the name of the
        * company/organization who publishes the extension.
        * @param companyNameValue The CompanyName value.
        */
        public void setCompanyName(final String companyNameValue) {
            this.companyName = companyNameValue;
        }
        
        private String description;
        
        /**
        * Optional. The description of the extension.
        * @return The Description value.
        */
        public String getDescription() {
            return this.description;
        }
        
        /**
        * Optional. The description of the extension.
        * @param descriptionValue The Description value.
        */
        public void setDescription(final String descriptionValue) {
            this.description = descriptionValue;
        }
        
        private Boolean disallowMajorVersionUpgrade;
        
        /**
        * Optional. Boolean property indicating whether the extension allows
        * major version upgrade.
        * @return The DisallowMajorVersionUpgrade value.
        */
        public Boolean isDisallowMajorVersionUpgrade() {
            return this.disallowMajorVersionUpgrade;
        }
        
        /**
        * Optional. Boolean property indicating whether the extension allows
        * major version upgrade.
        * @param disallowMajorVersionUpgradeValue The
        * DisallowMajorVersionUpgrade value.
        */
        public void setDisallowMajorVersionUpgrade(final Boolean disallowMajorVersionUpgradeValue) {
            this.disallowMajorVersionUpgrade = disallowMajorVersionUpgradeValue;
        }
        
        private URI eula;
        
        /**
        * Optional. URI string pointing to the EULA (End User License
        * Agreement) of this version of extension. This is optionally
        * specified by the third-party publishing the extension instead of
        * Azure, at the time of extension creation or update.
        * @return The Eula value.
        */
        public URI getEula() {
            return this.eula;
        }
        
        /**
        * Optional. URI string pointing to the EULA (End User License
        * Agreement) of this version of extension. This is optionally
        * specified by the third-party publishing the extension instead of
        * Azure, at the time of extension creation or update.
        * @param eulaValue The Eula value.
        */
        public void setEula(final URI eulaValue) {
            this.eula = eulaValue;
        }
        
        private URI homepageUri;
        
        /**
        * Optional. URI string pointing to the homepage of this version of
        * extension. This is optionally specified by the third-party
        * publishing the extension instead of Azure, at the time of extension
        * creation or update.
        * @return The HomepageUri value.
        */
        public URI getHomepageUri() {
            return this.homepageUri;
        }
        
        /**
        * Optional. URI string pointing to the homepage of this version of
        * extension. This is optionally specified by the third-party
        * publishing the extension instead of Azure, at the time of extension
        * creation or update.
        * @param homepageUriValue The HomepageUri value.
        */
        public void setHomepageUri(final URI homepageUriValue) {
            this.homepageUri = homepageUriValue;
        }
        
        private Boolean isInternalExtension;
        
        /**
        * Optional. Boolean property indicating whether the extension is
        * internal or public.
        * @return The IsInternalExtension value.
        */
        public Boolean isInternalExtension() {
            return this.isInternalExtension;
        }
        
        /**
        * Optional. Boolean property indicating whether the extension is
        * internal or public.
        * @param isInternalExtensionValue The IsInternalExtension value.
        */
        public void setIsInternalExtension(final Boolean isInternalExtensionValue) {
            this.isInternalExtension = isInternalExtensionValue;
        }
        
        private Boolean isJsonExtension;
        
        /**
        * Optional. Indicates whether the extension accepts JSON or XML based
        * configuration. If this property is 'true' the extension accepts JSON
        * based configuration. If this property is 'false' the extension
        * accepts XML based configuration.
        * @return The IsJsonExtension value.
        */
        public Boolean isJsonExtension() {
            return this.isJsonExtension;
        }
        
        /**
        * Optional. Indicates whether the extension accepts JSON or XML based
        * configuration. If this property is 'true' the extension accepts JSON
        * based configuration. If this property is 'false' the extension
        * accepts XML based configuration.
        * @param isJsonExtensionValue The IsJsonExtension value.
        */
        public void setIsJsonExtension(final Boolean isJsonExtensionValue) {
            this.isJsonExtension = isJsonExtensionValue;
        }
        
        private String label;
        
        /**
        * Optional. The label that is used to identify the extension.
        * @return The Label value.
        */
        public String getLabel() {
            return this.label;
        }
        
        /**
        * Optional. The label that is used to identify the extension.
        * @param labelValue The Label value.
        */
        public void setLabel(final String labelValue) {
            this.label = labelValue;
        }
        
        private String name;
        
        /**
        * Optional. The name of the extension.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. The name of the extension.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
        
        private URI privacyUri;
        
        /**
        * Optional. URI string pointing to the privacy document of this version
        * of extension. This is optionally specified by the third-party
        * publishing the extension instead of Azure, at the time of extension
        * creation or update.
        * @return The PrivacyUri value.
        */
        public URI getPrivacyUri() {
            return this.privacyUri;
        }
        
        /**
        * Optional. URI string pointing to the privacy document of this version
        * of extension. This is optionally specified by the third-party
        * publishing the extension instead of Azure, at the time of extension
        * creation or update.
        * @param privacyUriValue The PrivacyUri value.
        */
        public void setPrivacyUri(final URI privacyUriValue) {
            this.privacyUri = privacyUriValue;
        }
        
        private String privateConfigurationSchema;
        
        /**
        * Optional. The base64-encoded schema of the private configuration.
        * @return The PrivateConfigurationSchema value.
        */
        public String getPrivateConfigurationSchema() {
            return this.privateConfigurationSchema;
        }
        
        /**
        * Optional. The base64-encoded schema of the private configuration.
        * @param privateConfigurationSchemaValue The PrivateConfigurationSchema
        * value.
        */
        public void setPrivateConfigurationSchema(final String privateConfigurationSchemaValue) {
            this.privateConfigurationSchema = privateConfigurationSchemaValue;
        }
        
        private String publicConfigurationSchema;
        
        /**
        * Optional. The base64-encoded schema of the public configuration.
        * @return The PublicConfigurationSchema value.
        */
        public String getPublicConfigurationSchema() {
            return this.publicConfigurationSchema;
        }
        
        /**
        * Optional. The base64-encoded schema of the public configuration.
        * @param publicConfigurationSchemaValue The PublicConfigurationSchema
        * value.
        */
        public void setPublicConfigurationSchema(final String publicConfigurationSchemaValue) {
            this.publicConfigurationSchema = publicConfigurationSchemaValue;
        }
        
        private Calendar publishedDate;
        
        /**
        * Optional. Publisher can set it to any arbitrary date, and this is
        * only for display purpose. If not specified by publisher, Azure will
        * automatically assign the UTC time when the extension request was
        * received.
        * @return The PublishedDate value.
        */
        public Calendar getPublishedDate() {
            return this.publishedDate;
        }
        
        /**
        * Optional. Publisher can set it to any arbitrary date, and this is
        * only for display purpose. If not specified by publisher, Azure will
        * automatically assign the UTC time when the extension request was
        * received.
        * @param publishedDateValue The PublishedDate value.
        */
        public void setPublishedDate(final Calendar publishedDateValue) {
            this.publishedDate = publishedDateValue;
        }
        
        private String publisher;
        
        /**
        * Optional. The provider namespace of the extension. The provider
        * namespace for Azure extensions is Microsoft.Compute.
        * @return The Publisher value.
        */
        public String getPublisher() {
            return this.publisher;
        }
        
        /**
        * Optional. The provider namespace of the extension. The provider
        * namespace for Azure extensions is Microsoft.Compute.
        * @param publisherValue The Publisher value.
        */
        public void setPublisher(final String publisherValue) {
            this.publisher = publisherValue;
        }
        
        private Boolean replicationCompleted;
        
        /**
        * Optional. Indicates whether this version of extension has been
        * replicated to all regions or not. If true, then the given extension
        * version can be used in creating or updating deployments. Otherwise,
        * the given extension version might cause failure in creating or
        * updating deployments. The typical time is 20 minutes for a
        * newly-registered or newly-updated extension to replicate completely
        * by Azure.
        * @return The ReplicationCompleted value.
        */
        public Boolean isReplicationCompleted() {
            return this.replicationCompleted;
        }
        
        /**
        * Optional. Indicates whether this version of extension has been
        * replicated to all regions or not. If true, then the given extension
        * version can be used in creating or updating deployments. Otherwise,
        * the given extension version might cause failure in creating or
        * updating deployments. The typical time is 20 minutes for a
        * newly-registered or newly-updated extension to replicate completely
        * by Azure.
        * @param replicationCompletedValue The ReplicationCompleted value.
        */
        public void setReplicationCompleted(final Boolean replicationCompletedValue) {
            this.replicationCompleted = replicationCompletedValue;
        }
        
        private String sampleConfig;
        
        /**
        * Optional. A sample configuration file for the resource extension.
        * @return The SampleConfig value.
        */
        public String getSampleConfig() {
            return this.sampleConfig;
        }
        
        /**
        * Optional. A sample configuration file for the resource extension.
        * @param sampleConfigValue The SampleConfig value.
        */
        public void setSampleConfig(final String sampleConfigValue) {
            this.sampleConfig = sampleConfigValue;
        }
        
        private String supportedOS;
        
        /**
        * Optional. String property indicating the OS which the extension
        * supports. Current values are 'Windows' or 'Linux'.
        * @return The SupportedOS value.
        */
        public String getSupportedOS() {
            return this.supportedOS;
        }
        
        /**
        * Optional. String property indicating the OS which the extension
        * supports. Current values are 'Windows' or 'Linux'.
        * @param supportedOSValue The SupportedOS value.
        */
        public void setSupportedOS(final String supportedOSValue) {
            this.supportedOS = supportedOSValue;
        }
        
        private String version;
        
        /**
        * Optional. The version of the extension.
        * @return The Version value.
        */
        public String getVersion() {
            return this.version;
        }
        
        /**
        * Optional. The version of the extension.
        * @param versionValue The Version value.
        */
        public void setVersion(final String versionValue) {
            this.version = versionValue;
        }
    }
}
