/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.models.GatewayConnectDisconnectOrTestParameters;
import com.microsoft.windowsazure.management.network.models.GatewayCreateParameters;
import com.microsoft.windowsazure.management.network.models.GatewayDiagnosticsStatus;
import com.microsoft.windowsazure.management.network.models.GatewayGenerateVpnClientPackageParameters;
import com.microsoft.windowsazure.management.network.models.GatewayGetDeviceConfigurationScriptParameters;
import com.microsoft.windowsazure.management.network.models.GatewayGetDeviceConfigurationScriptResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetOperationStatusResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetSharedKeyResponse;
import com.microsoft.windowsazure.management.network.models.GatewayListConnectionsResponse;
import com.microsoft.windowsazure.management.network.models.GatewayListSupportedDevicesResponse;
import com.microsoft.windowsazure.management.network.models.GatewayOperationResponse;
import com.microsoft.windowsazure.management.network.models.GatewayResetSharedKeyParameters;
import com.microsoft.windowsazure.management.network.models.GatewaySetDefaultSiteListParameters;
import com.microsoft.windowsazure.management.network.models.GatewaySetSharedKeyParameters;
import com.microsoft.windowsazure.management.network.models.ResizeGatewayParameters;
import com.microsoft.windowsazure.management.network.models.UpdateGatewayPublicDiagnostics;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

/**
* The Network Management API includes operations for managing the gateways for
* your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/jj154113.aspx for more
* information)
*/
public interface GatewayOperations {
    /**
    * To connect to, disconnect from, or test your connection to a local
    * network site, access the connection resource representing the local
    * network and specify Connect, Disconnect or Test to perform the desired
    * operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154107.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkSiteName Required. The name of the site to connect to.
    * @param parameters Required. Parameters supplied to the Begin Connect
    * Disconnect Or Testing Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginConnectDisconnectOrTesting(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * To connect to, disconnect from, or test your connection to a local
    * network site, access the connection resource representing the local
    * network and specify Connect, Disconnect or Test to perform the desired
    * operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154107.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkSiteName Required. The name of the site to connect to.
    * @param parameters Required. Parameters supplied to the Begin Connect
    * Disconnect Or Testing Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginConnectDisconnectOrTestingAsync(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters);
    
    /**
    * The Begin Creating Virtual network Gateway operation creates a new
    * network gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginCreating(String networkName, GatewayCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Creating Virtual network Gateway operation creates a new
    * network gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginCreatingAsync(String networkName, GatewayCreateParameters parameters);
    
    /**
    * The Begin Deleting Virtual Network Gateway operation deletes a network
    * gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154129.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginDeleting(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Deleting Virtual Network Gateway operation deletes a network
    * gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154129.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginDeletingAsync(String networkName);
    
    /**
    * The Begin Failover Virtual Network Gateway operation causes a network
    * gateway failover for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154118.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network in Azure.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginFailover(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Failover Virtual Network Gateway operation causes a network
    * gateway failover for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154118.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network in Azure.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginFailoverAsync(String networkName);
    
    /**
    * The Generate VPN Client Package operation creates a VPN client package
    * for the specified virtual network and gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn205126.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Generate VPN
    * Client Package operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginGenerateVpnClientPackage(String networkName, GatewayGenerateVpnClientPackageParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Generate VPN Client Package operation creates a VPN client package
    * for the specified virtual network and gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn205126.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Generate VPN
    * Client Package operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginGenerateVpnClientPackageAsync(String networkName, GatewayGenerateVpnClientPackageParameters parameters);
    
    /**
    * The Begin Remove Virtual Network Gateway Shared Key operation removes the
    * default sites on the virtual network gateway for the specified virtual
    * network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginRemoveDefaultSites(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Remove Virtual Network Gateway Shared Key operation removes the
    * default sites on the virtual network gateway for the specified virtual
    * network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginRemoveDefaultSitesAsync(String networkName);
    
    /**
    * The Begin Reset Virtual Network Gateway Shared Key operation resets the
    * shared key on the virtual network gateway for the specified virtual
    * network connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Reset Shared Key request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginResetSharedKey(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Reset Virtual Network Gateway Shared Key operation resets the
    * shared key on the virtual network gateway for the specified virtual
    * network connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Reset Shared Key request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginResetSharedKeyAsync(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters);
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Resize
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginResize(String networkName, ResizeGatewayParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Resize
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginResizeAsync(String networkName, ResizeGatewayParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key operation sets the
    * default sites on the virtual network gateway for the specified virtual
    * network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Default Sites request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginSetDefaultSites(String networkName, GatewaySetDefaultSiteListParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key operation sets the
    * default sites on the virtual network gateway for the specified virtual
    * network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Default Sites request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginSetDefaultSitesAsync(String networkName, GatewaySetDefaultSiteListParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key operation sets the
    * shared key on the virtual network gateway for the specified virtual
    * network connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Shared Key request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginSetSharedKey(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key operation sets the
    * shared key on the virtual network gateway for the specified virtual
    * network connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Shared Key request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginSetSharedKeyAsync(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters);
    
    /**
    * The Begin Update Diagnostics operation begins an asynchronous operation
    * to starta diagnostics session for the specified virtual network gateway
    * in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginUpdateDiagnostics(String networkName, UpdateGatewayPublicDiagnostics parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Update Diagnostics operation begins an asynchronous operation
    * to starta diagnostics session for the specified virtual network gateway
    * in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginUpdateDiagnosticsAsync(String networkName, UpdateGatewayPublicDiagnostics parameters);
    
    /**
    * To connect to, disconnect from, or test your connection to a local
    * network site, access the connection resource representing the local
    * network and specify Connect, Disconnect or Test to perform the desired
    * operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154107.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkSiteName Required. The name of the site to connect to.
    * @param parameters Required. Parameters supplied to the Connect Disconnect
    * Or Testing Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse connectDisconnectOrTest(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * To connect to, disconnect from, or test your connection to a local
    * network site, access the connection resource representing the local
    * network and specify Connect, Disconnect or Test to perform the desired
    * operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154107.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkSiteName Required. The name of the site to connect to.
    * @param parameters Required. Parameters supplied to the Connect Disconnect
    * Or Testing Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> connectDisconnectOrTestAsync(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters);
    
    /**
    * The Create Virtual network Gateway operation creates a new network
    * gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Network Gateway operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse create(String networkName, GatewayCreateParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException, InterruptedException, ExecutionException;
    
    /**
    * The Create Virtual network Gateway operation creates a new network
    * gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Network Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> createAsync(String networkName, GatewayCreateParameters parameters);
    
    /**
    * The Delete Virtual Network Gateway operation deletes a network gateway
    * for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154129.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse delete(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException, InterruptedException, ExecutionException;
    
    /**
    * The Delete Virtual Network Gateway operation deletes a network gateway
    * for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154129.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> deleteAsync(String networkName);
    
    /**
    * The Failover Virtual Network Gateway operation causes a network gateway
    * failover for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154118.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network in Azure.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse failover(String networkName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Failover Virtual Network Gateway operation causes a network gateway
    * failover for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154118.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network in Azure.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> failoverAsync(String networkName);
    
    /**
    * The Generate VPN Client Package operation creates a VPN client package
    * for the specified virtual network and gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Generate VPN
    * Client Package operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse generateVpnClientPackage(String networkName, GatewayGenerateVpnClientPackageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Generate VPN Client Package operation creates a VPN client package
    * for the specified virtual network and gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Generate VPN
    * Client Package operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> generateVpnClientPackageAsync(String networkName, GatewayGenerateVpnClientPackageParameters parameters);
    
    /**
    * The Get Virtual Network Gateway operation gets information about the
    * network gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154109.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayGetResponse get(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway operation gets information about the
    * network gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154109.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayGetResponse> getAsync(String networkName);
    
    /**
    * The Get Device Configuration Script operation returns a script that you
    * can use to configure local VPN devices to connect to the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154115.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. The parameters for the Get Device
    * Configuration Script operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The configuration script returned from the get device
    * configuration script operation.
    */
    GatewayGetDeviceConfigurationScriptResponse getDeviceConfigurationScript(String networkName, GatewayGetDeviceConfigurationScriptParameters parameters) throws IOException, ServiceException;
    
    /**
    * The Get Device Configuration Script operation returns a script that you
    * can use to configure local VPN devices to connect to the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154115.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. The parameters for the Get Device
    * Configuration Script operation.
    * @return The configuration script returned from the get device
    * configuration script operation.
    */
    Future<GatewayGetDeviceConfigurationScriptResponse> getDeviceConfigurationScriptAsync(String networkName, GatewayGetDeviceConfigurationScriptParameters parameters);
    
    /**
    * The Get Diagnostics operation gets information about the current gateway
    * diagnostics session for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The status of a gateway diagnostics operation.
    */
    GatewayDiagnosticsStatus getDiagnostics(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Diagnostics operation gets information about the current gateway
    * diagnostics session for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return The status of a gateway diagnostics operation.
    */
    Future<GatewayDiagnosticsStatus> getDiagnosticsAsync(String networkName);
    
    /**
    * The Get Virtual Network Gateway Operation Status gets information on the
    * status of network gateway operations in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154112.aspx for
    * more information)
    *
    * @param operationId Required. The ID of the network operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse getOperationStatus(String operationId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway Operation Status gets information on the
    * status of network gateway operations in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154112.aspx for
    * more information)
    *
    * @param operationId Required. The ID of the network operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> getOperationStatusAsync(String operationId);
    
    /**
    * The Get Virtual Network Gateway Shared Key operation gets the shared key
    * on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154122.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to the get shared key request.
    */
    GatewayGetSharedKeyResponse getSharedKey(String networkName, String localNetworkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway Shared Key operation gets the shared key
    * on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154122.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @return The response to the get shared key request.
    */
    Future<GatewayGetSharedKeyResponse> getSharedKeyAsync(String networkName, String localNetworkName);
    
    /**
    * The List Connections operation returns a list of the local network
    * connections that can be accessed through the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154120.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a ListConnections request to a Virtual Network
    * Gateway.
    */
    GatewayListConnectionsResponse listConnections(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Connections operation returns a list of the local network
    * connections that can be accessed through the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154120.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return The response to a ListConnections request to a Virtual Network
    * Gateway.
    */
    Future<GatewayListConnectionsResponse> listConnectionsAsync(String networkName);
    
    /**
    * The List Virtual Network Gateway Supported Devices operation lists the
    * supported, on-premise network devices that can connect to the gateway.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj154102.aspx
    * for more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to the list supported devices request.
    */
    GatewayListSupportedDevicesResponse listSupportedDevices() throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Virtual Network Gateway Supported Devices operation lists the
    * supported, on-premise network devices that can connect to the gateway.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj154102.aspx
    * for more information)
    *
    * @return The response to the list supported devices request.
    */
    Future<GatewayListSupportedDevicesResponse> listSupportedDevicesAsync();
    
    /**
    * The Remove Virtual Network Gateway Shared Key operation sets the default
    * sites on the virtual network gateway for the specified virtual network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse removeDefaultSites(String networkName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Remove Virtual Network Gateway Shared Key operation sets the default
    * sites on the virtual network gateway for the specified virtual network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> removeDefaultSitesAsync(String networkName);
    
    /**
    * The Reset Virtual Network Gateway Shared Key operation resets the shared
    * key on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. The parameters to the Virtual Network Gateway
    * Reset Shared Key request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse resetSharedKey(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Reset Virtual Network Gateway Shared Key operation resets the shared
    * key on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. The parameters to the Virtual Network Gateway
    * Reset Shared Key request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> resetSharedKeyAsync(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters);
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Resize Virtual
    * Network Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse resize(String networkName, ResizeGatewayParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Resize Virtual
    * Network Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> resizeAsync(String networkName, ResizeGatewayParameters parameters);
    
    /**
    * The Set Virtual Network Gateway Shared Key operation sets the default
    * sites on the virtual network gateway for the specified virtual network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Default Sites request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse setDefaultSites(String networkName, GatewaySetDefaultSiteListParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Set Virtual Network Gateway Shared Key operation sets the default
    * sites on the virtual network gateway for the specified virtual network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Default Sites request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> setDefaultSitesAsync(String networkName, GatewaySetDefaultSiteListParameters parameters);
    
    /**
    * The Set Virtual Network Gateway Shared Key operation sets the shared key
    * on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. The parameters to the Virtual Network Gateway
    * Set Shared Key request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse setSharedKey(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Set Virtual Network Gateway Shared Key operation sets the shared key
    * on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. The parameters to the Virtual Network Gateway
    * Set Shared Key request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> setSharedKeyAsync(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters);
    
    /**
    * The Update Diagnostics operation starts a diagnostics session for the
    * specified virtual network gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Update Diagnostics
    * operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse updateDiagnostics(String networkName, UpdateGatewayPublicDiagnostics parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Update Diagnostics operation starts a diagnostics session for the
    * specified virtual network gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Update Diagnostics
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> updateDiagnosticsAsync(String networkName, UpdateGatewayPublicDiagnostics parameters);
}
