/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

/**
* The response for the List Client Root Certificates operation.
*/
public class ClientRootCertificateListResponse extends OperationResponse implements Iterable<ClientRootCertificateListResponse.ClientRootCertificate> {
    private ArrayList<ClientRootCertificateListResponse.ClientRootCertificate> clientRootCertificates;
    
    /**
    * Optional. The list of client root certificates.
    * @return The ClientRootCertificates value.
    */
    public ArrayList<ClientRootCertificateListResponse.ClientRootCertificate> getClientRootCertificates() {
        return this.clientRootCertificates;
    }
    
    /**
    * Optional. The list of client root certificates.
    * @param clientRootCertificatesValue The ClientRootCertificates value.
    */
    public void setClientRootCertificates(final ArrayList<ClientRootCertificateListResponse.ClientRootCertificate> clientRootCertificatesValue) {
        this.clientRootCertificates = clientRootCertificatesValue;
    }
    
    /**
    * Initializes a new instance of the ClientRootCertificateListResponse class.
    *
    */
    public ClientRootCertificateListResponse() {
        super();
        this.setClientRootCertificates(new LazyArrayList<ClientRootCertificateListResponse.ClientRootCertificate>());
    }
    
    /**
    * Gets the sequence of ClientRootCertificates.
    *
    */
    public Iterator<ClientRootCertificateListResponse.ClientRootCertificate> iterator() {
        return this.getClientRootCertificates().iterator();
    }
    
    public static class ClientRootCertificate {
        private Calendar expirationTime;
        
        /**
        * Optional. Specifies the time that the certificate will expire.
        * @return The ExpirationTime value.
        */
        public Calendar getExpirationTime() {
            return this.expirationTime;
        }
        
        /**
        * Optional. Specifies the time that the certificate will expire.
        * @param expirationTimeValue The ExpirationTime value.
        */
        public void setExpirationTime(final Calendar expirationTimeValue) {
            this.expirationTime = expirationTimeValue;
        }
        
        private String subject;
        
        /**
        * Optional. Specifies the distinguished name of the certificate issuer.
        * @return The Subject value.
        */
        public String getSubject() {
            return this.subject;
        }
        
        /**
        * Optional. Specifies the distinguished name of the certificate issuer.
        * @param subjectValue The Subject value.
        */
        public void setSubject(final String subjectValue) {
            this.subject = subjectValue;
        }
        
        private String thumbprint;
        
        /**
        * Optional. Specifies the thumbprint of the certificate.
        * @return The Thumbprint value.
        */
        public String getThumbprint() {
            return this.thumbprint;
        }
        
        /**
        * Optional. Specifies the thumbprint of the certificate.
        * @param thumbprintValue The Thumbprint value.
        */
        public void setThumbprint(final String thumbprintValue) {
            this.thumbprint = thumbprintValue;
        }
    }
}
