/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;

/**
* The response structure for the Network Operations List operation.
*/
public class NetworkListResponse extends OperationResponse implements Iterable<NetworkListResponse.VirtualNetworkSite> {
    private ArrayList<NetworkListResponse.VirtualNetworkSite> virtualNetworkSites;
    
    /**
    * Optional.
    * @return The VirtualNetworkSites value.
    */
    public ArrayList<NetworkListResponse.VirtualNetworkSite> getVirtualNetworkSites() {
        return this.virtualNetworkSites;
    }
    
    /**
    * Optional.
    * @param virtualNetworkSitesValue The VirtualNetworkSites value.
    */
    public void setVirtualNetworkSites(final ArrayList<NetworkListResponse.VirtualNetworkSite> virtualNetworkSitesValue) {
        this.virtualNetworkSites = virtualNetworkSitesValue;
    }
    
    /**
    * Initializes a new instance of the NetworkListResponse class.
    *
    */
    public NetworkListResponse() {
        super();
        this.setVirtualNetworkSites(new LazyArrayList<NetworkListResponse.VirtualNetworkSite>());
    }
    
    /**
    * Gets the sequence of VirtualNetworkSites.
    *
    */
    public Iterator<NetworkListResponse.VirtualNetworkSite> iterator() {
        return this.getVirtualNetworkSites().iterator();
    }
    
    public static class AddressSpace {
        private ArrayList<String> addressPrefixes;
        
        /**
        * Optional. Address spaces, in CIDR format in the virtual network.
        * @return The AddressPrefixes value.
        */
        public ArrayList<String> getAddressPrefixes() {
            return this.addressPrefixes;
        }
        
        /**
        * Optional. Address spaces, in CIDR format in the virtual network.
        * @param addressPrefixesValue The AddressPrefixes value.
        */
        public void setAddressPrefixes(final ArrayList<String> addressPrefixesValue) {
            this.addressPrefixes = addressPrefixesValue;
        }
        
        /**
        * Initializes a new instance of the AddressSpace class.
        *
        */
        public AddressSpace() {
            this.setAddressPrefixes(new LazyArrayList<String>());
        }
    }
    
    /**
    * Specifies the type of connection of the local network site. The value of
    * this element can be either IPsec or Dedicated. The default value is
    * IPsec.
    */
    public static class Connection {
        private LocalNetworkConnectionType type;
        
        /**
        * Optional.
        * @return The Type value.
        */
        public LocalNetworkConnectionType getType() {
            return this.type;
        }
        
        /**
        * Optional.
        * @param typeValue The Type value.
        */
        public void setType(final LocalNetworkConnectionType typeValue) {
            this.type = typeValue;
        }
    }
    
    public static class DnsServer {
        private InetAddress address;
        
        /**
        * Optional. The IPv4 address of the DNS server.
        * @return The Address value.
        */
        public InetAddress getAddress() {
            return this.address;
        }
        
        /**
        * Optional. The IPv4 address of the DNS server.
        * @param addressValue The Address value.
        */
        public void setAddress(final InetAddress addressValue) {
            this.address = addressValue;
        }
        
        private String name;
        
        /**
        * Optional. The name of the DNS server.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. The name of the DNS server.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
    }
    
    /**
    * Contains gateway references to the local network sites that the virtual
    * network can connect to.
    */
    public static class Gateway {
        private GatewayProfile profile;
        
        /**
        * Optional. The gateway connection size.
        * @return The Profile value.
        */
        public GatewayProfile getProfile() {
            return this.profile;
        }
        
        /**
        * Optional. The gateway connection size.
        * @param profileValue The Profile value.
        */
        public void setProfile(final GatewayProfile profileValue) {
            this.profile = profileValue;
        }
        
        private ArrayList<NetworkListResponse.LocalNetworkSite> sites;
        
        /**
        * Optional. The list of local network sites that the virtual network
        * can connect to.
        * @return The Sites value.
        */
        public ArrayList<NetworkListResponse.LocalNetworkSite> getSites() {
            return this.sites;
        }
        
        /**
        * Optional. The list of local network sites that the virtual network
        * can connect to.
        * @param sitesValue The Sites value.
        */
        public void setSites(final ArrayList<NetworkListResponse.LocalNetworkSite> sitesValue) {
            this.sites = sitesValue;
        }
        
        private NetworkListResponse.VPNClientAddressPool vPNClientAddressPool;
        
        /**
        * Optional. The VPN Client Address Pool reserves a pool of IP addresses
        * for VPN clients. This object is used for point-to-site connectivity.
        * @return The VPNClientAddressPool value.
        */
        public NetworkListResponse.VPNClientAddressPool getVPNClientAddressPool() {
            return this.vPNClientAddressPool;
        }
        
        /**
        * Optional. The VPN Client Address Pool reserves a pool of IP addresses
        * for VPN clients. This object is used for point-to-site connectivity.
        * @param vPNClientAddressPoolValue The VPNClientAddressPool value.
        */
        public void setVPNClientAddressPool(final NetworkListResponse.VPNClientAddressPool vPNClientAddressPoolValue) {
            this.vPNClientAddressPool = vPNClientAddressPoolValue;
        }
        
        /**
        * Initializes a new instance of the Gateway class.
        *
        */
        public Gateway() {
            this.setSites(new LazyArrayList<NetworkListResponse.LocalNetworkSite>());
        }
    }
    
    /**
    * Contains the list of parameters defining the local network site.
    */
    public static class LocalNetworkSite {
        private NetworkListResponse.AddressSpace addressSpace;
        
        /**
        * Optional. The address space of the local network site.
        * @return The AddressSpace value.
        */
        public NetworkListResponse.AddressSpace getAddressSpace() {
            return this.addressSpace;
        }
        
        /**
        * Optional. The address space of the local network site.
        * @param addressSpaceValue The AddressSpace value.
        */
        public void setAddressSpace(final NetworkListResponse.AddressSpace addressSpaceValue) {
            this.addressSpace = addressSpaceValue;
        }
        
        private ArrayList<NetworkListResponse.Connection> connections;
        
        /**
        * Optional. Specifies the types of connections to the local network
        * site.
        * @return The Connections value.
        */
        public ArrayList<NetworkListResponse.Connection> getConnections() {
            return this.connections;
        }
        
        /**
        * Optional. Specifies the types of connections to the local network
        * site.
        * @param connectionsValue The Connections value.
        */
        public void setConnections(final ArrayList<NetworkListResponse.Connection> connectionsValue) {
            this.connections = connectionsValue;
        }
        
        private String name;
        
        /**
        * Optional. The name of the local network site.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. The name of the local network site.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
        
        private InetAddress vpnGatewayAddress;
        
        /**
        * Optional. The IPv4 address of the local network site.
        * @return The VpnGatewayAddress value.
        */
        public InetAddress getVpnGatewayAddress() {
            return this.vpnGatewayAddress;
        }
        
        /**
        * Optional. The IPv4 address of the local network site.
        * @param vpnGatewayAddressValue The VpnGatewayAddress value.
        */
        public void setVpnGatewayAddress(final InetAddress vpnGatewayAddressValue) {
            this.vpnGatewayAddress = vpnGatewayAddressValue;
        }
        
        /**
        * Initializes a new instance of the LocalNetworkSite class.
        *
        */
        public LocalNetworkSite() {
            this.setConnections(new LazyArrayList<NetworkListResponse.Connection>());
        }
    }
    
    public static class Subnet {
        private String addressPrefix;
        
        /**
        * Optional. Represents an address space, in CIDR format that defines
        * the subnet.
        * @return The AddressPrefix value.
        */
        public String getAddressPrefix() {
            return this.addressPrefix;
        }
        
        /**
        * Optional. Represents an address space, in CIDR format that defines
        * the subnet.
        * @param addressPrefixValue The AddressPrefix value.
        */
        public void setAddressPrefix(final String addressPrefixValue) {
            this.addressPrefix = addressPrefixValue;
        }
        
        private String name;
        
        /**
        * Optional. Name of the subnet.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. Name of the subnet.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
        
        private String networkSecurityGroup;
        
        /**
        * Optional. Name of Network Security Group associated with this subnet.
        * @return The NetworkSecurityGroup value.
        */
        public String getNetworkSecurityGroup() {
            return this.networkSecurityGroup;
        }
        
        /**
        * Optional. Name of Network Security Group associated with this subnet.
        * @param networkSecurityGroupValue The NetworkSecurityGroup value.
        */
        public void setNetworkSecurityGroup(final String networkSecurityGroupValue) {
            this.networkSecurityGroup = networkSecurityGroupValue;
        }
    }
    
    /**
    * Contains the collections of parameters used to configure a virtual
    * network space that is dedicated to your subscription without overlapping
    * with other networks
    */
    public static class VirtualNetworkSite {
        private NetworkListResponse.AddressSpace addressSpace;
        
        /**
        * Optional. The list of network address spaces for a virtual network
        * site. This represents the overall network space contained within the
        * virtual network site.
        * @return The AddressSpace value.
        */
        public NetworkListResponse.AddressSpace getAddressSpace() {
            return this.addressSpace;
        }
        
        /**
        * Optional. The list of network address spaces for a virtual network
        * site. This represents the overall network space contained within the
        * virtual network site.
        * @param addressSpaceValue The AddressSpace value.
        */
        public void setAddressSpace(final NetworkListResponse.AddressSpace addressSpaceValue) {
            this.addressSpace = addressSpaceValue;
        }
        
        private String affinityGroup;
        
        /**
        * Optional. An affinity group, which indirectly refers to the location
        * where the virtual network exists.
        * @return The AffinityGroup value.
        */
        public String getAffinityGroup() {
            return this.affinityGroup;
        }
        
        /**
        * Optional. An affinity group, which indirectly refers to the location
        * where the virtual network exists.
        * @param affinityGroupValue The AffinityGroup value.
        */
        public void setAffinityGroup(final String affinityGroupValue) {
            this.affinityGroup = affinityGroupValue;
        }
        
        private ArrayList<NetworkListResponse.DnsServer> dnsServers;
        
        /**
        * Optional. The list of available DNS Servers associated with the
        * virtual network site.
        * @return The DnsServers value.
        */
        public ArrayList<NetworkListResponse.DnsServer> getDnsServers() {
            return this.dnsServers;
        }
        
        /**
        * Optional. The list of available DNS Servers associated with the
        * virtual network site.
        * @param dnsServersValue The DnsServers value.
        */
        public void setDnsServers(final ArrayList<NetworkListResponse.DnsServer> dnsServersValue) {
            this.dnsServers = dnsServersValue;
        }
        
        private NetworkListResponse.Gateway gateway;
        
        /**
        * Optional. The gateway that contains a list of Local Network Sites
        * which enable the Virtual Network Site to communicate with a
        * customer's on-premise networks.
        * @return The Gateway value.
        */
        public NetworkListResponse.Gateway getGateway() {
            return this.gateway;
        }
        
        /**
        * Optional. The gateway that contains a list of Local Network Sites
        * which enable the Virtual Network Site to communicate with a
        * customer's on-premise networks.
        * @param gatewayValue The Gateway value.
        */
        public void setGateway(final NetworkListResponse.Gateway gatewayValue) {
            this.gateway = gatewayValue;
        }
        
        private String id;
        
        /**
        * Optional. A unique string identifier that represents the virtual
        * network site.
        * @return The Id value.
        */
        public String getId() {
            return this.id;
        }
        
        /**
        * Optional. A unique string identifier that represents the virtual
        * network site.
        * @param idValue The Id value.
        */
        public void setId(final String idValue) {
            this.id = idValue;
        }
        
        private String label;
        
        /**
        * Optional. The friendly identifier for the site.
        * @return The Label value.
        */
        public String getLabel() {
            return this.label;
        }
        
        /**
        * Optional. The friendly identifier for the site.
        * @param labelValue The Label value.
        */
        public void setLabel(final String labelValue) {
            this.label = labelValue;
        }
        
        private String location;
        
        /**
        * Optional. Gets or sets the virtual network location.
        * @return The Location value.
        */
        public String getLocation() {
            return this.location;
        }
        
        /**
        * Optional. Gets or sets the virtual network location.
        * @param locationValue The Location value.
        */
        public void setLocation(final String locationValue) {
            this.location = locationValue;
        }
        
        private String name;
        
        /**
        * Optional. Name of the virtual network site.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. Name of the virtual network site.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
        
        private String state;
        
        /**
        * Optional. Current status of the virtual network. (Created, Creating,
        * Updating, Deleting, or Unavailable.)
        * @return The State value.
        */
        public String getState() {
            return this.state;
        }
        
        /**
        * Optional. Current status of the virtual network. (Created, Creating,
        * Updating, Deleting, or Unavailable.)
        * @param stateValue The State value.
        */
        public void setState(final String stateValue) {
            this.state = stateValue;
        }
        
        private ArrayList<NetworkListResponse.Subnet> subnets;
        
        /**
        * Optional. The list of network subnets for a virtual network site. All
        * network subnets must be contained within the overall virtual network
        * address spaces.
        * @return The Subnets value.
        */
        public ArrayList<NetworkListResponse.Subnet> getSubnets() {
            return this.subnets;
        }
        
        /**
        * Optional. The list of network subnets for a virtual network site. All
        * network subnets must be contained within the overall virtual network
        * address spaces.
        * @param subnetsValue The Subnets value.
        */
        public void setSubnets(final ArrayList<NetworkListResponse.Subnet> subnetsValue) {
            this.subnets = subnetsValue;
        }
        
        /**
        * Initializes a new instance of the VirtualNetworkSite class.
        *
        */
        public VirtualNetworkSite() {
            this.setDnsServers(new LazyArrayList<NetworkListResponse.DnsServer>());
            this.setSubnets(new LazyArrayList<NetworkListResponse.Subnet>());
        }
    }
    
    /**
    * The VPN Client Address Pool reserves a pool of IP addresses for VPN
    * clients. This object is used for point-to-site connectivity.
    */
    public static class VPNClientAddressPool {
        private ArrayList<String> addressPrefixes;
        
        /**
        * Optional. The CIDR identifiers that identify addresses in the pool.
        * @return The AddressPrefixes value.
        */
        public ArrayList<String> getAddressPrefixes() {
            return this.addressPrefixes;
        }
        
        /**
        * Optional. The CIDR identifiers that identify addresses in the pool.
        * @param addressPrefixesValue The AddressPrefixes value.
        */
        public void setAddressPrefixes(final ArrayList<String> addressPrefixesValue) {
            this.addressPrefixes = addressPrefixesValue;
        }
        
        /**
        * Initializes a new instance of the VPNClientAddressPool class.
        *
        */
        public VPNClientAddressPool() {
            this.setAddressPrefixes(new LazyArrayList<String>());
        }
    }
}
