/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

/**
* Parameters supplied to the Create Network Security Group operation.
*/
public class NetworkSecurityGroupCreateParameters {
    private String label;
    
    /**
    * Optional. Gets or sets description for the Network Security Group. The
    * description can be up to 1024 characters in length.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. Gets or sets description for the Network Security Group. The
    * description can be up to 1024 characters in length.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private String location;
    
    /**
    * Required. Gets or sets the data center location where the Network
    * Security Group will be created.
    * @return The Location value.
    */
    public String getLocation() {
        return this.location;
    }
    
    /**
    * Required. Gets or sets the data center location where the Network
    * Security Group will be created.
    * @param locationValue The Location value.
    */
    public void setLocation(final String locationValue) {
        this.location = locationValue;
    }
    
    private String name;
    
    /**
    * Required. Gets or sets name for the Network Security Group that is unique
    * to the subscription.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Required. Gets or sets name for the Network Security Group that is unique
    * to the subscription.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    /**
    * Initializes a new instance of the NetworkSecurityGroupCreateParameters
    * class.
    *
    */
    public NetworkSecurityGroupCreateParameters() {
    }
    
    /**
    * Initializes a new instance of the NetworkSecurityGroupCreateParameters
    * class with required arguments.
    *
    */
    public NetworkSecurityGroupCreateParameters(String name, String location) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setName(name);
        this.setLocation(location);
    }
}
