/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.StreamUtils;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.GatewayOperations;
import com.microsoft.windowsazure.management.network.NetworkManagementClient;
import com.microsoft.windowsazure.management.network.NetworkManagementClientImpl;
import com.microsoft.windowsazure.management.network.models.GatewayConnectDisconnectOrTestParameters;
import com.microsoft.windowsazure.management.network.models.GatewayConnectivityState;
import com.microsoft.windowsazure.management.network.models.GatewayCreateParameters;
import com.microsoft.windowsazure.management.network.models.GatewayDefaultSite;
import com.microsoft.windowsazure.management.network.models.GatewayDiagnosticsState;
import com.microsoft.windowsazure.management.network.models.GatewayDiagnosticsStatus;
import com.microsoft.windowsazure.management.network.models.GatewayEvent;
import com.microsoft.windowsazure.management.network.models.GatewayGenerateVpnClientPackageParameters;
import com.microsoft.windowsazure.management.network.models.GatewayGetDeviceConfigurationScriptParameters;
import com.microsoft.windowsazure.management.network.models.GatewayGetDeviceConfigurationScriptResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetOperationStatusResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetSharedKeyResponse;
import com.microsoft.windowsazure.management.network.models.GatewayListConnectionsResponse;
import com.microsoft.windowsazure.management.network.models.GatewayListSupportedDevicesResponse;
import com.microsoft.windowsazure.management.network.models.GatewayOperationResponse;
import com.microsoft.windowsazure.management.network.models.GatewayOperationStatus;
import com.microsoft.windowsazure.management.network.models.GatewayResetSharedKeyParameters;
import com.microsoft.windowsazure.management.network.models.GatewaySKU;
import com.microsoft.windowsazure.management.network.models.GatewaySetDefaultSiteListParameters;
import com.microsoft.windowsazure.management.network.models.GatewaySetSharedKeyParameters;
import com.microsoft.windowsazure.management.network.models.GatewayType;
import com.microsoft.windowsazure.management.network.models.ResizeGatewayParameters;
import com.microsoft.windowsazure.management.network.models.UpdateGatewayPublicDiagnostics;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GatewayOperationsImpl
implements ServiceOperations<NetworkManagementClientImpl>,
GatewayOperations {
    private NetworkManagementClientImpl client;

    GatewayOperationsImpl(NetworkManagementClientImpl client) {
        this.client = client;
    }

    public NetworkManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<GatewayOperationResponse> beginConnectDisconnectOrTestingAsync(final String networkName, final String localNetworkSiteName, final GatewayConnectDisconnectOrTestParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginConnectDisconnectOrTesting(networkName, localNetworkSiteName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginConnectDisconnectOrTesting(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (localNetworkSiteName == null) {
            throw new NullPointerException("localNetworkSiteName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("localNetworkSiteName", localNetworkSiteName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginConnectDisconnectOrTestingAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/connection/" + localNetworkSiteName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element updateConnectionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateConnection");
        requestDoc.appendChild(updateConnectionElement);
        Element operationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Operation");
        operationElement.appendChild(requestDoc.createTextNode(parameters.getOperation().toString()));
        updateConnectionElement.appendChild(operationElement);
        if (parameters.getIPAddress() != null) {
            Element iPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPAddress");
            iPAddressElement.appendChild(requestDoc.createTextNode(parameters.getIPAddress().getHostAddress()));
            updateConnectionElement.appendChild(iPAddressElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginCreatingAsync(final String networkName, final GatewayCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginCreating(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginCreating(String networkName, GatewayCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element createGatewayParametersElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CreateGatewayParameters");
        requestDoc.appendChild(createGatewayParametersElement);
        Element gatewaySizeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "GatewaySize");
        gatewaySizeElement.appendChild(requestDoc.createTextNode(parameters.getGatewaySKU().toString()));
        createGatewayParametersElement.appendChild(gatewaySizeElement);
        Element gatewayTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "gatewayType");
        gatewayTypeElement.appendChild(requestDoc.createTextNode(parameters.getGatewayType().toString()));
        createGatewayParametersElement.appendChild(gatewayTypeElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 201) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginDeletingAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginDeleting(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginDeleting(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginFailoverAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginFailover(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginFailover(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginFailoverAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?><UpdateGateway xmlns=\"http://schemas.microsoft.com/windowsazure\"><UpdateGatewayOperation>Failover</UpdateGatewayOperation></UpdateGateway>";
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginGenerateVpnClientPackageAsync(final String networkName, final GatewayGenerateVpnClientPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginGenerateVpnClientPackage(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginGenerateVpnClientPackage(String networkName, GatewayGenerateVpnClientPackageParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginGenerateVpnClientPackageAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/vpnclientpackage";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element vpnClientParametersElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VpnClientParameters");
        requestDoc.appendChild(vpnClientParametersElement);
        Element processorArchitectureElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ProcessorArchitecture");
        processorArchitectureElement.appendChild(requestDoc.createTextNode(parameters.getProcessorArchitecture().toString()));
        vpnClientParametersElement.appendChild(processorArchitectureElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginRemoveDefaultSitesAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginRemoveDefaultSites(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginRemoveDefaultSites(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRemoveDefaultSitesAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/defaultsites";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginResetSharedKeyAsync(final String networkName, final String localNetworkName, final GatewayResetSharedKeyParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginResetSharedKey(networkName, localNetworkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginResetSharedKey(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (localNetworkName == null) {
            throw new NullPointerException("localNetworkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("localNetworkName", localNetworkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginResetSharedKeyAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/connection/" + localNetworkName.trim() + "/sharedkey";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element resetSharedKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResetSharedKey");
        requestDoc.appendChild(resetSharedKeyElement);
        Element keyLengthElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyLength");
        keyLengthElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getKeyLength())));
        resetSharedKeyElement.appendChild(keyLengthElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginResizeAsync(final String networkName, final ResizeGatewayParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginResize(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginResize(String networkName, ResizeGatewayParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginResizeAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPatch httpRequest = new HttpPatch(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element updateGatewayParametersElement = requestDoc.createElementNS("", "UpdateGatewayParameters");
        requestDoc.appendChild(updateGatewayParametersElement);
        Element gatewaySizeElement = requestDoc.createElementNS("", "GatewaySize");
        gatewaySizeElement.appendChild(requestDoc.createTextNode(parameters.getGatewaySKU().toString()));
        updateGatewayParametersElement.appendChild(gatewaySizeElement);
        Element operationElement = requestDoc.createElementNS("", "Operation");
        operationElement.appendChild(requestDoc.createTextNode("Resize"));
        updateGatewayParametersElement.appendChild(operationElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginSetDefaultSitesAsync(final String networkName, final GatewaySetDefaultSiteListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginSetDefaultSites(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginSetDefaultSites(String networkName, GatewaySetDefaultSiteListParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginSetDefaultSitesAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/defaultsites";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element defaultSiteListElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DefaultSiteList");
        requestDoc.appendChild(defaultSiteListElement);
        if (parameters.getDefaultSite() != null) {
            Element stringElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "string");
            stringElement.appendChild(requestDoc.createTextNode(parameters.getDefaultSite()));
            defaultSiteListElement.appendChild(stringElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginSetSharedKeyAsync(final String networkName, final String localNetworkName, final GatewaySetSharedKeyParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginSetSharedKey(networkName, localNetworkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginSetSharedKey(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (localNetworkName == null) {
            throw new NullPointerException("localNetworkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("localNetworkName", localNetworkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginSetSharedKeyAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/connection/" + localNetworkName.trim() + "/sharedkey";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element sharedKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SharedKey");
        requestDoc.appendChild(sharedKeyElement);
        if (parameters.getValue() != null) {
            Element valueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
            valueElement.appendChild(requestDoc.createTextNode(parameters.getValue()));
            sharedKeyElement.appendChild(valueElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayOperationResponse> beginUpdateDiagnosticsAsync(final String networkName, final UpdateGatewayPublicDiagnostics parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayOperationResponse>(){

            @Override
            public GatewayOperationResponse call() throws Exception {
                return GatewayOperationsImpl.this.beginUpdateDiagnostics(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayOperationResponse beginUpdateDiagnostics(String networkName, UpdateGatewayPublicDiagnostics parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUpdateDiagnosticsAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/publicdiagnostics";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element updateGatewayPublicDiagnosticsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateGatewayPublicDiagnostics");
        requestDoc.appendChild(updateGatewayPublicDiagnosticsElement);
        if (parameters.getCaptureDurationInSeconds() != null) {
            Element captureDurationInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CaptureDurationInSeconds");
            captureDurationInSecondsElement.appendChild(requestDoc.createTextNode(parameters.getCaptureDurationInSeconds()));
            updateGatewayPublicDiagnosticsElement.appendChild(captureDurationInSecondsElement);
        }
        if (parameters.getContainerName() != null) {
            Element containerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ContainerName");
            containerNameElement.appendChild(requestDoc.createTextNode(parameters.getContainerName()));
            updateGatewayPublicDiagnosticsElement.appendChild(containerNameElement);
        }
        if (parameters.getCustomerStorageKey() != null) {
            Element customerStorageKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CustomerStorageKey");
            customerStorageKeyElement.appendChild(requestDoc.createTextNode(parameters.getCustomerStorageKey()));
            updateGatewayPublicDiagnosticsElement.appendChild(customerStorageKeyElement);
        }
        if (parameters.getCustomerStorageName() != null) {
            Element customerStorageNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CustomerStorageName");
            customerStorageNameElement.appendChild(requestDoc.createTextNode(parameters.getCustomerStorageName()));
            updateGatewayPublicDiagnosticsElement.appendChild(customerStorageNameElement);
        }
        Element operationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Operation");
        operationElement.appendChild(requestDoc.createTextNode(parameters.getOperation().toString()));
        updateGatewayPublicDiagnosticsElement.appendChild(operationElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            Element idElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayOperationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayOperationResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationAsyncResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperationAsyncResponse");
            if (gatewayOperationAsyncResponseElement != null && (idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationAsyncResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID")) != null) {
                String idInstance = idElement.getTextContent();
                result.setOperationId(idInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayOperationResponse gatewayOperationResponse = result;
            return gatewayOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> connectDisconnectOrTestAsync(final String networkName, final String localNetworkSiteName, final GatewayConnectDisconnectOrTestParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.connectDisconnectOrTest(networkName, localNetworkSiteName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse connectDisconnectOrTest(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("localNetworkSiteName", localNetworkSiteName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"connectDisconnectOrTestAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginConnectDisconnectOrTestingAsync(networkName, localNetworkSiteName, parameters).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> createAsync(final String networkName, final GatewayCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.create(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse create(String networkName, GatewayCreateParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException, InterruptedException, ExecutionException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginCreatingAsync(networkName, parameters).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> deleteAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.delete(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse delete(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException, InterruptedException, ExecutionException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginDeletingAsync(networkName).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> failoverAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.failover(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse failover(String networkName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"failoverAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginFailoverAsync(networkName).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> generateVpnClientPackageAsync(final String networkName, final GatewayGenerateVpnClientPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.generateVpnClientPackage(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse generateVpnClientPackage(String networkName, GatewayGenerateVpnClientPackageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"generateVpnClientPackageAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginGenerateVpnClientPackageAsync(networkName, parameters).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetResponse> getAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetResponse>(){

            @Override
            public GatewayGetResponse call() throws Exception {
                return GatewayOperationsImpl.this.get(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetResponse get(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Gateway");
            if (gatewayElement != null) {
                Element defaultSitesElement;
                Element gatewaySizeElement;
                Element gatewayTypeElement;
                Element lastEventElement;
                Element vIPAddressElement;
                Element stateElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State");
                if (stateElement != null) {
                    String stateInstance = stateElement.getTextContent();
                    result.setState(stateInstance);
                }
                if ((vIPAddressElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VIPAddress")) != null) {
                    InetAddress vIPAddressInstance = InetAddress.getByName(vIPAddressElement.getTextContent());
                    result.setVipAddress(vIPAddressInstance);
                }
                if ((lastEventElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastEvent")) != null) {
                    Element dataElement;
                    Element messageElement;
                    Element idElement;
                    GatewayEvent lastEventInstance = new GatewayEvent();
                    result.setLastEvent(lastEventInstance);
                    Element timestampElement = XmlUtility.getElementByTagNameNS((Node)lastEventElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Timestamp");
                    if (timestampElement != null) {
                        Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampElement.getTextContent());
                        lastEventInstance.setTimestamp(timestampInstance);
                    }
                    if ((idElement = XmlUtility.getElementByTagNameNS((Node)lastEventElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                        String idInstance = idElement.getTextContent();
                        lastEventInstance.setId(idInstance);
                    }
                    if ((messageElement = XmlUtility.getElementByTagNameNS((Node)lastEventElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                        String messageInstance = messageElement.getTextContent();
                        lastEventInstance.setMessage(messageInstance);
                    }
                    if ((dataElement = XmlUtility.getElementByTagNameNS((Node)lastEventElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Data")) != null) {
                        String dataInstance = dataElement.getTextContent();
                        lastEventInstance.setData(dataInstance);
                    }
                }
                if ((gatewayTypeElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayType")) != null) {
                    GatewayType gatewayTypeInstance = GatewayType.valueOf(gatewayTypeElement.getTextContent());
                    result.setGatewayType(gatewayTypeInstance);
                }
                if ((gatewaySizeElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewaySize")) != null) {
                    GatewaySKU gatewaySizeInstance = GatewaySKU.valueOf(gatewaySizeElement.getTextContent());
                    result.setGatewaySKU(gatewaySizeInstance);
                }
                if ((defaultSitesElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DefaultSites")) != null) {
                    GatewayDefaultSite defaultSitesInstance = new GatewayDefaultSite();
                    result.setDefaultSite(defaultSitesInstance);
                    Element stringElement = XmlUtility.getElementByTagNameNS((Node)defaultSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"string");
                    if (stringElement != null) {
                        String stringInstance = stringElement.getTextContent();
                        defaultSitesInstance.setName(stringInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayGetResponse gatewayGetResponse = result;
            return gatewayGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayGetDeviceConfigurationScriptResponse> getDeviceConfigurationScriptAsync(final String networkName, final GatewayGetDeviceConfigurationScriptParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetDeviceConfigurationScriptResponse>(){

            @Override
            public GatewayGetDeviceConfigurationScriptResponse call() throws Exception {
                return GatewayOperationsImpl.this.getDeviceConfigurationScript(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetDeviceConfigurationScriptResponse getDeviceConfigurationScript(String networkName, GatewayGetDeviceConfigurationScriptParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getDeviceConfigurationScriptAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/vpndeviceconfigurationscript" + "?";
        if (parameters.getVendor() != null) {
            url = url + "vendor=" + URLEncoder.encode(parameters.getVendor() != null ? parameters.getVendor().trim() : "", "UTF-8");
        }
        if (parameters.getPlatform() != null) {
            url = url + "&" + "platform=" + URLEncoder.encode(parameters.getPlatform() != null ? parameters.getPlatform().trim() : "", "UTF-8");
        }
        if (parameters.getOSFamily() != null) {
            url = url + "&" + "OSfamily=" + URLEncoder.encode(parameters.getOSFamily() != null ? parameters.getOSFamily().trim() : "", "UTF-8");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetDeviceConfigurationScriptResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayGetDeviceConfigurationScriptResponse();
            result.setConfigurationScript(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayGetDeviceConfigurationScriptResponse gatewayGetDeviceConfigurationScriptResponse = result;
            return gatewayGetDeviceConfigurationScriptResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayDiagnosticsStatus> getDiagnosticsAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayDiagnosticsStatus>(){

            @Override
            public GatewayDiagnosticsStatus call() throws Exception {
                return GatewayOperationsImpl.this.getDiagnostics(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayDiagnosticsStatus getDiagnostics(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getDiagnosticsAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/publicdiagnostics";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayDiagnosticsStatus result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayDiagnosticsStatus();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayPublicDiagnosticsStatusElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayPublicDiagnosticsStatus");
            if (gatewayPublicDiagnosticsStatusElement != null) {
                Element publicDiagnosticsUrlElement;
                Element stateElement = XmlUtility.getElementByTagNameNS((Node)gatewayPublicDiagnosticsStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State");
                if (stateElement != null) {
                    GatewayDiagnosticsState stateInstance = GatewayDiagnosticsState.valueOf(stateElement.getTextContent());
                    result.setState(stateInstance);
                }
                if ((publicDiagnosticsUrlElement = XmlUtility.getElementByTagNameNS((Node)gatewayPublicDiagnosticsStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicDiagnosticsUrl")) != null) {
                    String publicDiagnosticsUrlInstance = publicDiagnosticsUrlElement.getTextContent();
                    result.setDiagnosticsUrl(publicDiagnosticsUrlInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayDiagnosticsStatus gatewayDiagnosticsStatus = result;
            return gatewayDiagnosticsStatus;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> getOperationStatusAsync(final String operationId) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.getOperationStatus(operationId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse getOperationStatus(String operationId) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (operationId == null) {
            throw new NullPointerException("operationId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("operationId", operationId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getOperationStatusAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/operation/" + operationId.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayGetOperationStatusResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element gatewayOperationElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"GatewayOperation");
            if (gatewayOperationElement != null) {
                Element errorElement;
                Element httpStatusCodeElement;
                Element statusElement;
                Element idElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID");
                if (idElement != null) {
                    String idInstance = idElement.getTextContent();
                    result.setId(idInstance);
                }
                if ((statusElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                    GatewayOperationStatus statusInstance = GatewayOperationStatus.valueOf(statusElement.getTextContent());
                    result.setStatus(statusInstance);
                }
                if ((httpStatusCodeElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HttpStatusCode")) != null) {
                    Integer httpStatusCodeInstance = Integer.valueOf(httpStatusCodeElement.getTextContent());
                    result.setHttpStatusCode(httpStatusCodeInstance);
                }
                if ((errorElement = XmlUtility.getElementByTagNameNS((Node)gatewayOperationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Error")) != null) {
                    Element messageElement;
                    GatewayGetOperationStatusResponse.ErrorDetails errorInstance = new GatewayGetOperationStatusResponse.ErrorDetails();
                    result.setError(errorInstance);
                    Element codeElement = XmlUtility.getElementByTagNameNS((Node)errorElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code");
                    if (codeElement != null) {
                        String codeInstance = codeElement.getTextContent();
                        errorInstance.setCode(codeInstance);
                    }
                    if ((messageElement = XmlUtility.getElementByTagNameNS((Node)errorElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                        String messageInstance = messageElement.getTextContent();
                        errorInstance.setMessage(messageInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayGetSharedKeyResponse> getSharedKeyAsync(final String networkName, final String localNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetSharedKeyResponse>(){

            @Override
            public GatewayGetSharedKeyResponse call() throws Exception {
                return GatewayOperationsImpl.this.getSharedKey(networkName, localNetworkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetSharedKeyResponse getSharedKey(String networkName, String localNetworkName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (localNetworkName == null) {
            throw new NullPointerException("localNetworkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("localNetworkName", localNetworkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getSharedKeyAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/connection/" + localNetworkName.trim() + "/sharedkey";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            Element valueElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetSharedKeyResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayGetSharedKeyResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element sharedKeyElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"SharedKey");
            if (sharedKeyElement != null && (valueElement = XmlUtility.getElementByTagNameNS((Node)sharedKeyElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value")) != null) {
                String valueInstance = valueElement.getTextContent();
                result.setSharedKey(valueInstance);
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayGetSharedKeyResponse gatewayGetSharedKeyResponse = result;
            return gatewayGetSharedKeyResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayListConnectionsResponse> listConnectionsAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayListConnectionsResponse>(){

            @Override
            public GatewayListConnectionsResponse call() throws Exception {
                return GatewayOperationsImpl.this.listConnections(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayListConnectionsResponse listConnections(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listConnectionsAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/" + networkName.trim() + "/gateway/connections";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayListConnectionsResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayListConnectionsResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element connectionsSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Connections");
            if (connectionsSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)connectionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Connection").size(); ++i1) {
                    Element allocatedIPAddressesSequenceElement;
                    Element lastConnectionEstablishedElement;
                    Element egressBytesTransferredElement;
                    Element ingressBytesTransferredElement;
                    Element lastEventElement;
                    Element connectivityStateElement;
                    Element connectionsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)connectionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Connection").get(i1);
                    GatewayListConnectionsResponse.GatewayConnection connectionInstance = new GatewayListConnectionsResponse.GatewayConnection();
                    result.getConnections().add(connectionInstance);
                    Element localNetworkSiteNameElement = XmlUtility.getElementByTagNameNS((Node)connectionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalNetworkSiteName");
                    if (localNetworkSiteNameElement != null) {
                        String localNetworkSiteNameInstance = localNetworkSiteNameElement.getTextContent();
                        connectionInstance.setLocalNetworkSiteName(localNetworkSiteNameInstance);
                    }
                    if ((connectivityStateElement = XmlUtility.getElementByTagNameNS((Node)connectionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConnectivityState")) != null) {
                        GatewayConnectivityState connectivityStateInstance = GatewayConnectivityState.valueOf(connectivityStateElement.getTextContent());
                        connectionInstance.setConnectivityState(connectivityStateInstance);
                    }
                    if ((lastEventElement = XmlUtility.getElementByTagNameNS((Node)connectionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastEvent")) != null) {
                        Element dataElement;
                        Element messageElement;
                        Element idElement;
                        GatewayEvent lastEventInstance = new GatewayEvent();
                        connectionInstance.setLastEvent(lastEventInstance);
                        Element timestampElement = XmlUtility.getElementByTagNameNS((Node)lastEventElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Timestamp");
                        if (timestampElement != null) {
                            Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampElement.getTextContent());
                            lastEventInstance.setTimestamp(timestampInstance);
                        }
                        if ((idElement = XmlUtility.getElementByTagNameNS((Node)lastEventElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                            String idInstance = idElement.getTextContent();
                            lastEventInstance.setId(idInstance);
                        }
                        if ((messageElement = XmlUtility.getElementByTagNameNS((Node)lastEventElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                            String messageInstance = messageElement.getTextContent();
                            lastEventInstance.setMessage(messageInstance);
                        }
                        if ((dataElement = XmlUtility.getElementByTagNameNS((Node)lastEventElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Data")) != null) {
                            String dataInstance = dataElement.getTextContent();
                            lastEventInstance.setData(dataInstance);
                        }
                    }
                    if ((ingressBytesTransferredElement = XmlUtility.getElementByTagNameNS((Node)connectionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IngressBytesTransferred")) != null) {
                        long ingressBytesTransferredInstance = DatatypeConverter.parseLong((String)ingressBytesTransferredElement.getTextContent());
                        connectionInstance.setIngressBytesTransferred(ingressBytesTransferredInstance);
                    }
                    if ((egressBytesTransferredElement = XmlUtility.getElementByTagNameNS((Node)connectionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EgressBytesTransferred")) != null) {
                        long egressBytesTransferredInstance = DatatypeConverter.parseLong((String)egressBytesTransferredElement.getTextContent());
                        connectionInstance.setEgressBytesTransferred(egressBytesTransferredInstance);
                    }
                    if ((lastConnectionEstablishedElement = XmlUtility.getElementByTagNameNS((Node)connectionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastConnectionEstablished")) != null) {
                        Calendar lastConnectionEstablishedInstance = DatatypeConverter.parseDateTime((String)lastConnectionEstablishedElement.getTextContent());
                        connectionInstance.setLastConnectionEstablished(lastConnectionEstablishedInstance);
                    }
                    if ((allocatedIPAddressesSequenceElement = XmlUtility.getElementByTagNameNS((Node)connectionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AllocatedIPAddresses")) == null) continue;
                    for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)allocatedIPAddressesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"string").size(); ++i2) {
                        Element allocatedIPAddressesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)allocatedIPAddressesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"string").get(i2);
                        connectionInstance.getAllocatedIPAddresses().add(allocatedIPAddressesElement.getTextContent());
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            GatewayListConnectionsResponse gatewayListConnectionsResponse = result;
            return gatewayListConnectionsResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayListSupportedDevicesResponse> listSupportedDevicesAsync() {
        return this.getClient().getExecutorService().submit(new Callable<GatewayListSupportedDevicesResponse>(){

            @Override
            public GatewayListSupportedDevicesResponse call() throws Exception {
                return GatewayOperationsImpl.this.listSupportedDevices();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayListSupportedDevicesResponse listSupportedDevices() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listSupportedDevicesAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/supporteddevices";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayListSupportedDevicesResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GatewayListSupportedDevicesResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element vpnDeviceListElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"", (String)"VpnDeviceList");
            if (vpnDeviceListElement != null) {
                Attr versionAttribute = vpnDeviceListElement.getAttributeNodeNS("", "version");
                if (versionAttribute != null) {
                    result.setVersion(versionAttribute.getValue());
                }
                if (vpnDeviceListElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)vpnDeviceListElement, (String)"", (String)"Vendor").size(); ++i1) {
                        Element vendorsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)vpnDeviceListElement, (String)"", (String)"Vendor").get(i1);
                        GatewayListSupportedDevicesResponse.Vendor vendorInstance = new GatewayListSupportedDevicesResponse.Vendor();
                        result.getVendors().add(vendorInstance);
                        Attr nameAttribute = vendorsElement.getAttributeNodeNS("", "name");
                        if (nameAttribute != null) {
                            vendorInstance.setName(nameAttribute.getValue());
                        }
                        if (vendorsElement == null) continue;
                        for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)vendorsElement, (String)"", (String)"Platform").size(); ++i2) {
                            Element platformsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)vendorsElement, (String)"", (String)"Platform").get(i2);
                            GatewayListSupportedDevicesResponse.Platform platformInstance = new GatewayListSupportedDevicesResponse.Platform();
                            vendorInstance.getPlatforms().add(platformInstance);
                            Attr nameAttribute2 = platformsElement.getAttributeNodeNS("", "name");
                            if (nameAttribute2 != null) {
                                platformInstance.setName(nameAttribute2.getValue());
                            }
                            if (platformsElement == null) continue;
                            for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)platformsElement, (String)"", (String)"OSFamily").size(); ++i3) {
                                Element oSFamiliesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)platformsElement, (String)"", (String)"OSFamily").get(i3);
                                GatewayListSupportedDevicesResponse.OSFamily oSFamilyInstance = new GatewayListSupportedDevicesResponse.OSFamily();
                                platformInstance.getOSFamilies().add(oSFamilyInstance);
                                Attr nameAttribute3 = oSFamiliesElement.getAttributeNodeNS("", "name");
                                if (nameAttribute3 == null) continue;
                                oSFamilyInstance.setName(nameAttribute3.getValue());
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GatewayListSupportedDevicesResponse gatewayListSupportedDevicesResponse = result;
            return gatewayListSupportedDevicesResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> removeDefaultSitesAsync(final String networkName) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.removeDefaultSites(networkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse removeDefaultSites(String networkName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("networkName", networkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"removeDefaultSitesAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginRemoveDefaultSitesAsync(networkName).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> resetSharedKeyAsync(final String networkName, final String localNetworkName, final GatewayResetSharedKeyParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.resetSharedKey(networkName, localNetworkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse resetSharedKey(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("localNetworkName", localNetworkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"resetSharedKeyAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginResetSharedKeyAsync(networkName, localNetworkName, parameters).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> resizeAsync(final String networkName, final ResizeGatewayParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.resize(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse resize(String networkName, ResizeGatewayParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"resizeAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginResizeAsync(networkName, parameters).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> setDefaultSitesAsync(final String networkName, final GatewaySetDefaultSiteListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.setDefaultSites(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse setDefaultSites(String networkName, GatewaySetDefaultSiteListParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"setDefaultSitesAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginSetDefaultSitesAsync(networkName, parameters).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> setSharedKeyAsync(final String networkName, final String localNetworkName, final GatewaySetSharedKeyParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.setSharedKey(networkName, localNetworkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse setSharedKey(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("localNetworkName", localNetworkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"setSharedKeyAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginSetSharedKeyAsync(networkName, localNetworkName, parameters).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GatewayGetOperationStatusResponse> updateDiagnosticsAsync(final String networkName, final UpdateGatewayPublicDiagnostics parameters) {
        return this.getClient().getExecutorService().submit(new Callable<GatewayGetOperationStatusResponse>(){

            @Override
            public GatewayGetOperationStatusResponse call() throws Exception {
                return GatewayOperationsImpl.this.updateDiagnostics(networkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayGetOperationStatusResponse updateDiagnostics(String networkName, UpdateGatewayPublicDiagnostics parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateDiagnosticsAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            GatewayOperationResponse response = client2.getGatewaysOperations().beginUpdateDiagnosticsAsync(networkName, parameters).get();
            GatewayGetOperationStatusResponse result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != GatewayOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getGatewaysOperations().getOperationStatusAsync(response.getOperationId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            if (result.getStatus() != GatewayOperationStatus.Successful) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GatewayGetOperationStatusResponse gatewayGetOperationStatusResponse = result;
            return gatewayGetOperationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

