/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.StreamUtils;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.NetworkManagementClient;
import com.microsoft.windowsazure.management.network.NetworkManagementClientImpl;
import com.microsoft.windowsazure.management.network.NetworkOperations;
import com.microsoft.windowsazure.management.network.models.GatewayProfile;
import com.microsoft.windowsazure.management.network.models.LocalNetworkConnectionType;
import com.microsoft.windowsazure.management.network.models.NetworkGetConfigurationResponse;
import com.microsoft.windowsazure.management.network.models.NetworkListResponse;
import com.microsoft.windowsazure.management.network.models.NetworkSetConfigurationParameters;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NetworkOperationsImpl
implements ServiceOperations<NetworkManagementClientImpl>,
NetworkOperations {
    private NetworkManagementClientImpl client;

    NetworkOperationsImpl(NetworkManagementClientImpl client) {
        this.client = client;
    }

    public NetworkManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> beginSettingConfigurationAsync(final NetworkSetConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return NetworkOperationsImpl.this.beginSettingConfiguration(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginSettingConfiguration(NetworkSetConfigurationParameters parameters) throws IOException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, NetworkSetConfigurationParameters> tracingParameters = new HashMap<String, NetworkSetConfigurationParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginSettingConfigurationAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/media";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/octet-stream");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = parameters.getConfiguration();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/octet-stream");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<NetworkGetConfigurationResponse> getConfigurationAsync() {
        return this.getClient().getExecutorService().submit(new Callable<NetworkGetConfigurationResponse>(){

            @Override
            public NetworkGetConfigurationResponse call() throws Exception {
                return NetworkOperationsImpl.this.getConfiguration();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkGetConfigurationResponse getConfiguration() throws IOException, ServiceException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getConfigurationAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/media";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkGetConfigurationResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new NetworkGetConfigurationResponse();
            result.setConfiguration(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkGetConfigurationResponse networkGetConfigurationResponse = result;
            return networkGetConfigurationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<NetworkListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<NetworkListResponse>(){

            @Override
            public NetworkListResponse call() throws Exception {
                return NetworkOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/virtualnetwork";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new NetworkListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element virtualNetworkSitesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualNetworkSites");
            if (virtualNetworkSitesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)virtualNetworkSitesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualNetworkSite").size(); ++i1) {
                    Element vPNClientAddressPoolElement;
                    Element sitesSequenceElement;
                    Element gatewayElement;
                    Element dnsServersSequenceElement;
                    Element dnsElement;
                    Element subnetsSequenceElement;
                    Element addressSpaceElement;
                    Element stateElement;
                    Element locationElement;
                    Element affinityGroupElement;
                    Element idElement;
                    Element labelElement;
                    Element virtualNetworkSitesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)virtualNetworkSitesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualNetworkSite").get(i1);
                    NetworkListResponse.VirtualNetworkSite virtualNetworkSiteInstance = new NetworkListResponse.VirtualNetworkSite();
                    result.getVirtualNetworkSites().add(virtualNetworkSiteInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        virtualNetworkSiteInstance.setName(nameInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        virtualNetworkSiteInstance.setLabel(labelInstance);
                    }
                    if ((idElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                        String idInstance = idElement.getTextContent();
                        virtualNetworkSiteInstance.setId(idInstance);
                    }
                    if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        virtualNetworkSiteInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        virtualNetworkSiteInstance.setLocation(locationInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        virtualNetworkSiteInstance.setState(stateInstance);
                    }
                    if ((addressSpaceElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressSpace")) != null) {
                        NetworkListResponse.AddressSpace addressSpaceInstance = new NetworkListResponse.AddressSpace();
                        virtualNetworkSiteInstance.setAddressSpace(addressSpaceInstance);
                        Element addressPrefixesSequenceElement = XmlUtility.getElementByTagNameNS((Node)addressSpaceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefixes");
                        if (addressPrefixesSequenceElement != null) {
                            for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)addressPrefixesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix").size(); ++i2) {
                                Element addressPrefixesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)addressPrefixesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix").get(i2);
                                addressSpaceInstance.getAddressPrefixes().add(addressPrefixesElement.getTextContent());
                            }
                        }
                    }
                    if ((subnetsSequenceElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Subnets")) != null) {
                        for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)subnetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Subnet").size(); ++i3) {
                            Element networkSecurityGroupElement;
                            Element addressPrefixElement;
                            Element subnetsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subnetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Subnet").get(i3);
                            NetworkListResponse.Subnet subnetInstance = new NetworkListResponse.Subnet();
                            virtualNetworkSiteInstance.getSubnets().add(subnetInstance);
                            Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)subnetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement2 != null) {
                                String nameInstance2 = nameElement2.getTextContent();
                                subnetInstance.setName(nameInstance2);
                            }
                            if ((addressPrefixElement = XmlUtility.getElementByTagNameNS((Node)subnetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix")) != null) {
                                String addressPrefixInstance = addressPrefixElement.getTextContent();
                                subnetInstance.setAddressPrefix(addressPrefixInstance);
                            }
                            if ((networkSecurityGroupElement = XmlUtility.getElementByTagNameNS((Node)subnetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkSecurityGroup")) == null) continue;
                            String networkSecurityGroupInstance = networkSecurityGroupElement.getTextContent();
                            subnetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                        }
                    }
                    if ((dnsElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Dns")) != null && (dnsServersSequenceElement = XmlUtility.getElementByTagNameNS((Node)dnsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServers")) != null) {
                        for (int i4 = 0; i4 < XmlUtility.getElementsByTagNameNS((Node)dnsServersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServer").size(); ++i4) {
                            Element addressElement;
                            Element dnsServersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dnsServersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServer").get(i4);
                            NetworkListResponse.DnsServer dnsServerInstance = new NetworkListResponse.DnsServer();
                            virtualNetworkSiteInstance.getDnsServers().add(dnsServerInstance);
                            Element nameElement3 = XmlUtility.getElementByTagNameNS((Node)dnsServersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement3 != null) {
                                String nameInstance3 = nameElement3.getTextContent();
                                dnsServerInstance.setName(nameInstance3);
                            }
                            if ((addressElement = XmlUtility.getElementByTagNameNS((Node)dnsServersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) == null) continue;
                            InetAddress addressInstance = InetAddress.getByName(addressElement.getTextContent());
                            dnsServerInstance.setAddress(addressInstance);
                        }
                    }
                    if ((gatewayElement = XmlUtility.getElementByTagNameNS((Node)virtualNetworkSitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Gateway")) == null) continue;
                    NetworkListResponse.Gateway gatewayInstance = new NetworkListResponse.Gateway();
                    virtualNetworkSiteInstance.setGateway(gatewayInstance);
                    Element profileElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Profile");
                    if (profileElement != null) {
                        GatewayProfile profileInstance = GatewayProfile.valueOf(profileElement.getTextContent());
                        gatewayInstance.setProfile(profileInstance);
                    }
                    if ((sitesSequenceElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Sites")) != null) {
                        for (int i5 = 0; i5 < XmlUtility.getElementsByTagNameNS((Node)sitesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalNetworkSite").size(); ++i5) {
                            Element connectionsSequenceElement;
                            Element addressSpaceElement2;
                            Element vpnGatewayAddressElement;
                            Element sitesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)sitesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalNetworkSite").get(i5);
                            NetworkListResponse.LocalNetworkSite localNetworkSiteInstance = new NetworkListResponse.LocalNetworkSite();
                            gatewayInstance.getSites().add(localNetworkSiteInstance);
                            Element nameElement4 = XmlUtility.getElementByTagNameNS((Node)sitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement4 != null) {
                                String nameInstance4 = nameElement4.getTextContent();
                                localNetworkSiteInstance.setName(nameInstance4);
                            }
                            if ((vpnGatewayAddressElement = XmlUtility.getElementByTagNameNS((Node)sitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VpnGatewayAddress")) != null) {
                                InetAddress vpnGatewayAddressInstance = InetAddress.getByName(vpnGatewayAddressElement.getTextContent());
                                localNetworkSiteInstance.setVpnGatewayAddress(vpnGatewayAddressInstance);
                            }
                            if ((addressSpaceElement2 = XmlUtility.getElementByTagNameNS((Node)sitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressSpace")) != null) {
                                NetworkListResponse.AddressSpace addressSpaceInstance2 = new NetworkListResponse.AddressSpace();
                                localNetworkSiteInstance.setAddressSpace(addressSpaceInstance2);
                                Element addressPrefixesSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)addressSpaceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefixes");
                                if (addressPrefixesSequenceElement2 != null) {
                                    for (int i6 = 0; i6 < XmlUtility.getElementsByTagNameNS((Node)addressPrefixesSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix").size(); ++i6) {
                                        Element addressPrefixesElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)addressPrefixesSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix").get(i6);
                                        addressSpaceInstance2.getAddressPrefixes().add(addressPrefixesElement2.getTextContent());
                                    }
                                }
                            }
                            if ((connectionsSequenceElement = XmlUtility.getElementByTagNameNS((Node)sitesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Connections")) == null) continue;
                            for (int i7 = 0; i7 < XmlUtility.getElementsByTagNameNS((Node)connectionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Connection").size(); ++i7) {
                                Element connectionsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)connectionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Connection").get(i7);
                                NetworkListResponse.Connection connectionInstance = new NetworkListResponse.Connection();
                                localNetworkSiteInstance.getConnections().add(connectionInstance);
                                Element typeElement = XmlUtility.getElementByTagNameNS((Node)connectionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type");
                                if (typeElement == null) continue;
                                LocalNetworkConnectionType typeInstance = NetworkManagementClientImpl.parseLocalNetworkConnectionType(typeElement.getTextContent());
                                connectionInstance.setType(typeInstance);
                            }
                        }
                    }
                    if ((vPNClientAddressPoolElement = XmlUtility.getElementByTagNameNS((Node)gatewayElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VPNClientAddressPool")) == null) continue;
                    NetworkListResponse.VPNClientAddressPool vPNClientAddressPoolInstance = new NetworkListResponse.VPNClientAddressPool();
                    gatewayInstance.setVPNClientAddressPool(vPNClientAddressPoolInstance);
                    Element addressPrefixesSequenceElement3 = XmlUtility.getElementByTagNameNS((Node)vPNClientAddressPoolElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefixes");
                    if (addressPrefixesSequenceElement3 == null) continue;
                    for (int i8 = 0; i8 < XmlUtility.getElementsByTagNameNS((Node)addressPrefixesSequenceElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix").size(); ++i8) {
                        Element addressPrefixesElement3 = (Element)XmlUtility.getElementsByTagNameNS((Node)addressPrefixesSequenceElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix").get(i8);
                        vPNClientAddressPoolInstance.getAddressPrefixes().add(addressPrefixesElement3.getTextContent());
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            NetworkListResponse networkListResponse = result;
            return networkListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> setConfigurationAsync(final NetworkSetConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return NetworkOperationsImpl.this.setConfiguration(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse setConfiguration(NetworkSetConfigurationParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, NetworkSetConfigurationParameters> tracingParameters = new HashMap<String, NetworkSetConfigurationParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"setConfigurationAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getNetworksOperations().beginSettingConfigurationAsync(parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

