/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.NetworkManagementClient;
import com.microsoft.windowsazure.management.network.NetworkManagementClientImpl;
import com.microsoft.windowsazure.management.network.ReservedIPOperations;
import com.microsoft.windowsazure.management.network.models.NetworkReservedIPCreateParameters;
import com.microsoft.windowsazure.management.network.models.NetworkReservedIPGetResponse;
import com.microsoft.windowsazure.management.network.models.NetworkReservedIPListResponse;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ReservedIPOperationsImpl
implements ServiceOperations<NetworkManagementClientImpl>,
ReservedIPOperations {
    private NetworkManagementClientImpl client;

    ReservedIPOperationsImpl(NetworkManagementClientImpl client) {
        this.client = client;
    }

    public NetworkManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationStatusResponse> beginCreatingAsync(final NetworkReservedIPCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return ReservedIPOperationsImpl.this.beginCreating(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse beginCreating(NetworkReservedIPCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, NetworkReservedIPCreateParameters> tracingParameters = new HashMap<String, NetworkReservedIPCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/reservedips";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element reservedIPElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ReservedIP");
        requestDoc.appendChild(reservedIPElement);
        if (parameters.getName() != null) {
            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
            nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            reservedIPElement.appendChild(nameElement);
        }
        if (parameters.getLabel() != null) {
            Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
            labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            reservedIPElement.appendChild(labelElement);
        }
        if (parameters.getLocation() != null) {
            Element locationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Location");
            locationElement.appendChild(requestDoc.createTextNode(parameters.getLocation()));
            reservedIPElement.appendChild(locationElement);
        }
        if (parameters.getServiceName() != null) {
            Element serviceNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceName");
            serviceNameElement.appendChild(requestDoc.createTextNode(parameters.getServiceName()));
            reservedIPElement.appendChild(serviceNameElement);
        }
        if (parameters.getDeploymentName() != null) {
            Element deploymentNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DeploymentName");
            deploymentNameElement.appendChild(requestDoc.createTextNode(parameters.getDeploymentName()));
            reservedIPElement.appendChild(deploymentNameElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse result = null;
            result = new OperationStatusResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingAsync(final String ipName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ReservedIPOperationsImpl.this.beginDeleting(ipName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeleting(String ipName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (ipName == null) {
            throw new NullPointerException("ipName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("ipName", ipName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/reservedips/" + ipName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> createAsync(final NetworkReservedIPCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return ReservedIPOperationsImpl.this.create(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse create(NetworkReservedIPCreateParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException, InterruptedException, ExecutionException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, NetworkReservedIPCreateParameters> tracingParameters = new HashMap<String, NetworkReservedIPCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        try {
            OperationStatusResponse response;
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            if ((response = client2.getReservedIPsOperations().beginCreatingAsync(parameters).get()).getStatus() == OperationStatus.Succeeded) {
                OperationStatusResponse operationStatusResponse = response;
                return operationStatusResponse;
            }
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteAsync(final String ipName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return ReservedIPOperationsImpl.this.delete(ipName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse delete(String ipName) throws IOException, ServiceException, ParserConfigurationException, SAXException, InterruptedException, ExecutionException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("ipName", ipName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getReservedIPsOperations().beginDeletingAsync(ipName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<NetworkReservedIPGetResponse> getAsync(final String ipName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkReservedIPGetResponse>(){

            @Override
            public NetworkReservedIPGetResponse call() throws Exception {
                return ReservedIPOperationsImpl.this.get(ipName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkReservedIPGetResponse get(String ipName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (ipName == null) {
            throw new NullPointerException("ipName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("ipName", ipName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/reservedips/" + ipName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkReservedIPGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new NetworkReservedIPGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element reservedIPElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReservedIP");
            if (reservedIPElement != null) {
                Element locationElement;
                Element deploymentNameElement;
                Element serviceNameElement;
                Element inUseElement;
                Element stateElement;
                Element labelElement;
                Element idElement;
                Element addressElement;
                Element nameElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement != null) {
                    String nameInstance = nameElement.getTextContent();
                    result.setName(nameInstance);
                }
                if ((addressElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) != null) {
                    InetAddress addressInstance = InetAddress.getByName(addressElement.getTextContent());
                    result.setAddress(addressInstance);
                }
                if ((idElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                    String idInstance = idElement.getTextContent();
                    result.setId(idInstance);
                }
                if ((labelElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement.getTextContent();
                    result.setLabel(labelInstance);
                }
                if ((stateElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                    String stateInstance = stateElement.getTextContent();
                    result.setState(stateInstance);
                }
                if ((inUseElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InUse")) != null) {
                    boolean inUseInstance = DatatypeConverter.parseBoolean((String)inUseElement.getTextContent().toLowerCase());
                    result.setInUse(inUseInstance);
                }
                if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                    String serviceNameInstance = serviceNameElement.getTextContent();
                    result.setServiceName(serviceNameInstance);
                }
                if ((deploymentNameElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentName")) != null) {
                    String deploymentNameInstance = deploymentNameElement.getTextContent();
                    result.setDeploymentName(deploymentNameInstance);
                }
                if ((locationElement = XmlUtility.getElementByTagNameNS((Node)reservedIPElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                    String locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkReservedIPGetResponse networkReservedIPGetResponse = result;
            return networkReservedIPGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<NetworkReservedIPListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<NetworkReservedIPListResponse>(){

            @Override
            public NetworkReservedIPListResponse call() throws Exception {
                return ReservedIPOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkReservedIPListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/reservedips";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkReservedIPListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new NetworkReservedIPListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element reservedIPsSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReservedIPs");
            if (reservedIPsSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)reservedIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReservedIP").size(); ++i1) {
                    Element locationElement;
                    Element deploymentNameElement;
                    Element serviceNameElement;
                    Element inUseElement;
                    Element stateElement;
                    Element labelElement;
                    Element idElement;
                    Element addressElement;
                    Element reservedIPsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)reservedIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReservedIP").get(i1);
                    NetworkReservedIPListResponse.ReservedIP reservedIPInstance = new NetworkReservedIPListResponse.ReservedIP();
                    result.getReservedIPs().add(reservedIPInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        reservedIPInstance.setName(nameInstance);
                    }
                    if ((addressElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) != null) {
                        InetAddress addressInstance = InetAddress.getByName(addressElement.getTextContent());
                        reservedIPInstance.setAddress(addressInstance);
                    }
                    if ((idElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                        String idInstance = idElement.getTextContent();
                        reservedIPInstance.setId(idInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        reservedIPInstance.setLabel(labelInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        reservedIPInstance.setState(stateInstance);
                    }
                    if ((inUseElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InUse")) != null) {
                        boolean inUseInstance = DatatypeConverter.parseBoolean((String)inUseElement.getTextContent().toLowerCase());
                        reservedIPInstance.setInUse(inUseInstance);
                    }
                    if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                        String serviceNameInstance = serviceNameElement.getTextContent();
                        reservedIPInstance.setServiceName(serviceNameInstance);
                    }
                    if ((deploymentNameElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentName")) != null) {
                        String deploymentNameInstance = deploymentNameElement.getTextContent();
                        reservedIPInstance.setDeploymentName(deploymentNameInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)reservedIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) == null) continue;
                    String locationInstance = locationElement.getTextContent();
                    reservedIPInstance.setLocation(locationInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            NetworkReservedIPListResponse networkReservedIPListResponse = result;
            return networkReservedIPListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

