/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.NetworkManagementClient;
import com.microsoft.windowsazure.management.network.NetworkManagementClientImpl;
import com.microsoft.windowsazure.management.network.RouteOperations;
import com.microsoft.windowsazure.management.network.models.AddRouteTableToSubnetParameters;
import com.microsoft.windowsazure.management.network.models.CreateRouteTableParameters;
import com.microsoft.windowsazure.management.network.models.GetRouteTableForSubnetResponse;
import com.microsoft.windowsazure.management.network.models.GetRouteTableResponse;
import com.microsoft.windowsazure.management.network.models.ListRouteTablesResponse;
import com.microsoft.windowsazure.management.network.models.NextHop;
import com.microsoft.windowsazure.management.network.models.Route;
import com.microsoft.windowsazure.management.network.models.RouteState;
import com.microsoft.windowsazure.management.network.models.RouteTable;
import com.microsoft.windowsazure.management.network.models.RouteTableState;
import com.microsoft.windowsazure.management.network.models.SetRouteParameters;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RouteOperationsImpl
implements ServiceOperations<NetworkManagementClientImpl>,
RouteOperations {
    private NetworkManagementClientImpl client;

    RouteOperationsImpl(NetworkManagementClientImpl client) {
        this.client = client;
    }

    public NetworkManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationStatusResponse> addRouteTableToSubnetAsync(final String vnetName, final String subnetName, final AddRouteTableToSubnetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return RouteOperationsImpl.this.addRouteTableToSubnet(vnetName, subnetName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse addRouteTableToSubnet(String vnetName, String subnetName, AddRouteTableToSubnetParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"addRouteTableToSubnetAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getRoutesOperations().beginAddRouteTableToSubnetAsync(vnetName, subnetName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginAddRouteTableToSubnetAsync(final String vnetName, final String subnetName, final AddRouteTableToSubnetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RouteOperationsImpl.this.beginAddRouteTableToSubnet(vnetName, subnetName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginAddRouteTableToSubnet(String vnetName, String subnetName, AddRouteTableToSubnetParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (vnetName == null) {
            throw new NullPointerException("vnetName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginAddRouteTableToSubnetAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/virtualnetwork/" + vnetName.trim() + "/subnets/" + subnetName.trim() + "/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element routeTableAssociationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RouteTableAssociation");
        requestDoc.appendChild(routeTableAssociationElement);
        if (parameters.getRouteTableName() != null) {
            Element routeTableNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RouteTableName");
            routeTableNameElement.appendChild(requestDoc.createTextNode(parameters.getRouteTableName()));
            routeTableAssociationElement.appendChild(routeTableNameElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginCreateRouteTableAsync(final CreateRouteTableParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RouteOperationsImpl.this.beginCreateRouteTable(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCreateRouteTable(CreateRouteTableParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, CreateRouteTableParameters> tracingParameters = new HashMap<String, CreateRouteTableParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateRouteTableAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element routeTableElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RouteTable");
        requestDoc.appendChild(routeTableElement);
        if (parameters.getName() != null) {
            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
            nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            routeTableElement.appendChild(nameElement);
        }
        if (parameters.getLabel() != null) {
            Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
            labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            routeTableElement.appendChild(labelElement);
        }
        if (parameters.getLocation() != null) {
            Element locationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Location");
            locationElement.appendChild(requestDoc.createTextNode(parameters.getLocation()));
            routeTableElement.appendChild(locationElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeleteRouteAsync(final String routeTableName, final String routeName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RouteOperationsImpl.this.beginDeleteRoute(routeTableName, routeName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeleteRoute(String routeTableName, String routeName) throws IOException, ServiceException {
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (routeName == null) {
            throw new NullPointerException("routeName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeleteRouteAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/routetables/" + routeTableName.trim() + "/routes/" + routeName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeleteRouteTableAsync(final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RouteOperationsImpl.this.beginDeleteRouteTable(routeTableName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeleteRouteTable(String routeTableName) throws IOException, ServiceException {
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeleteRouteTableAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/routetables/" + routeTableName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginRemoveRouteTableFromSubnetAsync(final String vnetName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RouteOperationsImpl.this.beginRemoveRouteTableFromSubnet(vnetName, subnetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginRemoveRouteTableFromSubnet(String vnetName, String subnetName) throws IOException, ServiceException {
        if (vnetName == null) {
            throw new NullPointerException("vnetName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRemoveRouteTableFromSubnetAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/virtualnetwork/" + vnetName.trim() + "/subnets/" + subnetName.trim() + "/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginSetRouteAsync(final String routeTableName, final String routeName, final SetRouteParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RouteOperationsImpl.this.beginSetRoute(routeTableName, routeName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginSetRoute(String routeTableName, String routeName, SetRouteParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (routeName == null) {
            throw new NullPointerException("routeName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginSetRouteAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/routetables/" + routeTableName.trim() + "/routes/" + routeName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element routeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Route");
        requestDoc.appendChild(routeElement);
        if (parameters.getName() != null) {
            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
            nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            routeElement.appendChild(nameElement);
        }
        if (parameters.getAddressPrefix() != null) {
            Element addressPrefixElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AddressPrefix");
            addressPrefixElement.appendChild(requestDoc.createTextNode(parameters.getAddressPrefix()));
            routeElement.appendChild(addressPrefixElement);
        }
        if (parameters.getNextHop() != null) {
            Element nextHopTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NextHopType");
            routeElement.appendChild(nextHopTypeElement);
            if (parameters.getNextHop().getType() != null) {
                Element typeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
                typeElement.appendChild(requestDoc.createTextNode(parameters.getNextHop().getType()));
                nextHopTypeElement.appendChild(typeElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> createRouteTableAsync(final CreateRouteTableParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return RouteOperationsImpl.this.createRouteTable(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse createRouteTable(CreateRouteTableParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, CreateRouteTableParameters> tracingParameters = new HashMap<String, CreateRouteTableParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createRouteTableAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getRoutesOperations().beginCreateRouteTableAsync(parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteRouteAsync(final String routeTableName, final String routeName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return RouteOperationsImpl.this.deleteRoute(routeTableName, routeName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteRoute(String routeTableName, String routeName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteRouteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getRoutesOperations().beginDeleteRouteAsync(routeTableName, routeName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteRouteTableAsync(final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return RouteOperationsImpl.this.deleteRouteTable(routeTableName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteRouteTable(String routeTableName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteRouteTableAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getRoutesOperations().beginDeleteRouteTableAsync(routeTableName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<GetRouteTableResponse> getRouteTableAsync(final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<GetRouteTableResponse>(){

            @Override
            public GetRouteTableResponse call() throws Exception {
                return RouteOperationsImpl.this.getRouteTable(routeTableName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRouteTableResponse getRouteTable(String routeTableName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getRouteTableAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/routetables/" + routeTableName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GetRouteTableResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GetRouteTableResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element routeTableElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTable");
            if (routeTableElement != null) {
                Element routeListSequenceElement;
                Element routeTableStateElement;
                Element locationElement;
                Element labelElement;
                RouteTable routeTableInstance = new RouteTable();
                result.setRouteTable(routeTableInstance);
                Element nameElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement != null) {
                    String nameInstance = nameElement.getTextContent();
                    routeTableInstance.setName(nameInstance);
                }
                if ((labelElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement.getTextContent();
                    routeTableInstance.setLabel(labelInstance);
                }
                if ((locationElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                    String locationInstance = locationElement.getTextContent();
                    routeTableInstance.setLocation(locationInstance);
                }
                if ((routeTableStateElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTableState")) != null) {
                    RouteTableState routeTableStateInstance = RouteTableState.valueOf(routeTableStateElement.getTextContent());
                    routeTableInstance.setRouteTableState(routeTableStateInstance);
                }
                if ((routeListSequenceElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteList")) != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)routeListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Route").size(); ++i1) {
                        Element routeStateElement;
                        Element metricElement;
                        Element nextHopTypeElement;
                        Element addressPrefixElement;
                        Element routeListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)routeListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Route").get(i1);
                        Route routeInstance = new Route();
                        routeTableInstance.getRouteList().add(routeInstance);
                        Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement2 != null) {
                            String nameInstance2 = nameElement2.getTextContent();
                            routeInstance.setName(nameInstance2);
                        }
                        if ((addressPrefixElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix")) != null) {
                            String addressPrefixInstance = addressPrefixElement.getTextContent();
                            routeInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        if ((nextHopTypeElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NextHopType")) != null) {
                            NextHop nextHopTypeInstance = new NextHop();
                            routeInstance.setNextHop(nextHopTypeInstance);
                            Element typeElement = XmlUtility.getElementByTagNameNS((Node)nextHopTypeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type");
                            if (typeElement != null) {
                                String typeInstance = typeElement.getTextContent();
                                nextHopTypeInstance.setType(typeInstance);
                            }
                        }
                        if ((metricElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Metric")) != null) {
                            int metricInstance = DatatypeConverter.parseInt((String)metricElement.getTextContent());
                            routeInstance.setMetric(metricInstance);
                        }
                        if ((routeStateElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteState")) == null) continue;
                        RouteState routeStateInstance = RouteState.valueOf(routeStateElement.getTextContent());
                        routeInstance.setState(routeStateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GetRouteTableResponse getRouteTableResponse = result;
            return getRouteTableResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GetRouteTableForSubnetResponse> getRouteTableForSubnetAsync(final String vnetName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<GetRouteTableForSubnetResponse>(){

            @Override
            public GetRouteTableForSubnetResponse call() throws Exception {
                return RouteOperationsImpl.this.getRouteTableForSubnet(vnetName, subnetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRouteTableForSubnetResponse getRouteTableForSubnet(String vnetName, String subnetName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (vnetName == null) {
            throw new NullPointerException("vnetName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getRouteTableForSubnetAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/virtualnetwork/" + vnetName.trim() + "/subnets/" + subnetName.trim() + "/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            Element routeTableNameElement;
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GetRouteTableForSubnetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GetRouteTableForSubnetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element routeTableAssociationElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTableAssociation");
            if (routeTableAssociationElement != null && (routeTableNameElement = XmlUtility.getElementByTagNameNS((Node)routeTableAssociationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTableName")) != null) {
                String routeTableNameInstance = routeTableNameElement.getTextContent();
                result.setRouteTableName(routeTableNameInstance);
            }
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GetRouteTableForSubnetResponse getRouteTableForSubnetResponse = result;
            return getRouteTableForSubnetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<GetRouteTableResponse> getRouteTableWithDetailsAsync(final String routeTableName, final String detailLevel) {
        return this.getClient().getExecutorService().submit(new Callable<GetRouteTableResponse>(){

            @Override
            public GetRouteTableResponse call() throws Exception {
                return RouteOperationsImpl.this.getRouteTableWithDetails(routeTableName, detailLevel);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRouteTableResponse getRouteTableWithDetails(String routeTableName, String detailLevel) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (detailLevel == null) {
            throw new NullPointerException("detailLevel");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("detailLevel", detailLevel);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getRouteTableWithDetailsAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/routetables/" + routeTableName.trim() + "?";
        url = url + "detailLevel=" + URLEncoder.encode(detailLevel.trim(), "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            GetRouteTableResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GetRouteTableResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element routeTableElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTable");
            if (routeTableElement != null) {
                Element routeListSequenceElement;
                Element routeTableStateElement;
                Element locationElement;
                Element labelElement;
                RouteTable routeTableInstance = new RouteTable();
                result.setRouteTable(routeTableInstance);
                Element nameElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement != null) {
                    String nameInstance = nameElement.getTextContent();
                    routeTableInstance.setName(nameInstance);
                }
                if ((labelElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement.getTextContent();
                    routeTableInstance.setLabel(labelInstance);
                }
                if ((locationElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                    String locationInstance = locationElement.getTextContent();
                    routeTableInstance.setLocation(locationInstance);
                }
                if ((routeTableStateElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTableState")) != null) {
                    RouteTableState routeTableStateInstance = RouteTableState.valueOf(routeTableStateElement.getTextContent());
                    routeTableInstance.setRouteTableState(routeTableStateInstance);
                }
                if ((routeListSequenceElement = XmlUtility.getElementByTagNameNS((Node)routeTableElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteList")) != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)routeListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Route").size(); ++i1) {
                        Element routeStateElement;
                        Element metricElement;
                        Element nextHopTypeElement;
                        Element addressPrefixElement;
                        Element routeListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)routeListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Route").get(i1);
                        Route routeInstance = new Route();
                        routeTableInstance.getRouteList().add(routeInstance);
                        Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement2 != null) {
                            String nameInstance2 = nameElement2.getTextContent();
                            routeInstance.setName(nameInstance2);
                        }
                        if ((addressPrefixElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix")) != null) {
                            String addressPrefixInstance = addressPrefixElement.getTextContent();
                            routeInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        if ((nextHopTypeElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NextHopType")) != null) {
                            NextHop nextHopTypeInstance = new NextHop();
                            routeInstance.setNextHop(nextHopTypeInstance);
                            Element typeElement = XmlUtility.getElementByTagNameNS((Node)nextHopTypeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type");
                            if (typeElement != null) {
                                String typeInstance = typeElement.getTextContent();
                                nextHopTypeInstance.setType(typeInstance);
                            }
                        }
                        if ((metricElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Metric")) != null) {
                            int metricInstance = DatatypeConverter.parseInt((String)metricElement.getTextContent());
                            routeInstance.setMetric(metricInstance);
                        }
                        if ((routeStateElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteState")) == null) continue;
                        RouteState routeStateInstance = RouteState.valueOf(routeStateElement.getTextContent());
                        routeInstance.setState(routeStateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            GetRouteTableResponse getRouteTableResponse = result;
            return getRouteTableResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ListRouteTablesResponse> listRouteTablesAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ListRouteTablesResponse>(){

            @Override
            public ListRouteTablesResponse call() throws Exception {
                return RouteOperationsImpl.this.listRouteTables();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRouteTablesResponse listRouteTables() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listRouteTablesAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/networking/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ListRouteTablesResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ListRouteTablesResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element routeTablesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTables");
            if (routeTablesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)routeTablesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTable").size(); ++i1) {
                    Element routeListSequenceElement;
                    Element routeTableStateElement;
                    Element locationElement;
                    Element labelElement;
                    Element routeTablesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)routeTablesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTable").get(i1);
                    RouteTable routeTableInstance = new RouteTable();
                    result.getRouteTables().add(routeTableInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)routeTablesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        routeTableInstance.setName(nameInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)routeTablesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        routeTableInstance.setLabel(labelInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)routeTablesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        routeTableInstance.setLocation(locationInstance);
                    }
                    if ((routeTableStateElement = XmlUtility.getElementByTagNameNS((Node)routeTablesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteTableState")) != null) {
                        RouteTableState routeTableStateInstance = RouteTableState.valueOf(routeTableStateElement.getTextContent());
                        routeTableInstance.setRouteTableState(routeTableStateInstance);
                    }
                    if ((routeListSequenceElement = XmlUtility.getElementByTagNameNS((Node)routeTablesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteList")) == null) continue;
                    for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)routeListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Route").size(); ++i2) {
                        Element routeStateElement;
                        Element metricElement;
                        Element nextHopTypeElement;
                        Element addressPrefixElement;
                        Element routeListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)routeListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Route").get(i2);
                        Route routeInstance = new Route();
                        routeTableInstance.getRouteList().add(routeInstance);
                        Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement2 != null) {
                            String nameInstance2 = nameElement2.getTextContent();
                            routeInstance.setName(nameInstance2);
                        }
                        if ((addressPrefixElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressPrefix")) != null) {
                            String addressPrefixInstance = addressPrefixElement.getTextContent();
                            routeInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        if ((nextHopTypeElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NextHopType")) != null) {
                            NextHop nextHopTypeInstance = new NextHop();
                            routeInstance.setNextHop(nextHopTypeInstance);
                            Element typeElement = XmlUtility.getElementByTagNameNS((Node)nextHopTypeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type");
                            if (typeElement != null) {
                                String typeInstance = typeElement.getTextContent();
                                nextHopTypeInstance.setType(typeInstance);
                            }
                        }
                        if ((metricElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Metric")) != null) {
                            int metricInstance = DatatypeConverter.parseInt((String)metricElement.getTextContent());
                            routeInstance.setMetric(metricInstance);
                        }
                        if ((routeStateElement = XmlUtility.getElementByTagNameNS((Node)routeListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RouteState")) == null) continue;
                        RouteState routeStateInstance = RouteState.valueOf(routeStateElement.getTextContent());
                        routeInstance.setState(routeStateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            ListRouteTablesResponse listRouteTablesResponse = result;
            return listRouteTablesResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> removeRouteTableFromSubnetAsync(final String vnetName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return RouteOperationsImpl.this.removeRouteTableFromSubnet(vnetName, subnetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse removeRouteTableFromSubnet(String vnetName, String subnetName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"removeRouteTableFromSubnetAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getRoutesOperations().beginRemoveRouteTableFromSubnetAsync(vnetName, subnetName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> setRouteAsync(final String routeTableName, final String routeName, final SetRouteParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return RouteOperationsImpl.this.setRoute(routeTableName, routeName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse setRoute(String routeTableName, String routeName, SetRouteParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"setRouteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkManagementClient)((NetworkManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getRoutesOperations().beginSetRouteAsync(routeTableName, routeName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

