/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.LocationOperations;
import com.microsoft.windowsazure.management.ManagementClientImpl;
import com.microsoft.windowsazure.management.models.ComputeCapabilities;
import com.microsoft.windowsazure.management.models.LocationsListResponse;
import com.microsoft.windowsazure.management.models.StorageCapabilities;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LocationOperationsImpl
implements ServiceOperations<ManagementClientImpl>,
LocationOperations {
    private ManagementClientImpl client;

    LocationOperationsImpl(ManagementClientImpl client) {
        this.client = client;
    }

    public ManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<LocationsListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<LocationsListResponse>(){

            @Override
            public LocationsListResponse call() throws Exception {
                return LocationOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocationsListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/locations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            LocationsListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new LocationsListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element locationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Locations");
            if (locationsSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)locationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location").size(); ++i1) {
                    Element webWorkerRoleSizesSequenceElement;
                    Element computeCapabilitiesElement;
                    Element storageCapabilitiesElement;
                    Element availableServicesSequenceElement;
                    Element displayNameElement;
                    Element locationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)locationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location").get(i1);
                    LocationsListResponse.Location locationInstance = new LocationsListResponse.Location();
                    result.getLocations().add(locationInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)locationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        locationInstance.setName(nameInstance);
                    }
                    if ((displayNameElement = XmlUtility.getElementByTagNameNS((Node)locationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DisplayName")) != null) {
                        String displayNameInstance = displayNameElement.getTextContent();
                        locationInstance.setDisplayName(displayNameInstance);
                    }
                    if ((availableServicesSequenceElement = XmlUtility.getElementByTagNameNS((Node)locationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailableServices")) != null) {
                        for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)availableServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailableService").size(); ++i2) {
                            Element availableServicesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)availableServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailableService").get(i2);
                            locationInstance.getAvailableServices().add(availableServicesElement.getTextContent());
                        }
                    }
                    if ((storageCapabilitiesElement = XmlUtility.getElementByTagNameNS((Node)locationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageCapabilities")) != null) {
                        StorageCapabilities storageCapabilitiesInstance = new StorageCapabilities();
                        locationInstance.setStorageCapabilities(storageCapabilitiesInstance);
                        Element storageAccountTypesSequenceElement = XmlUtility.getElementByTagNameNS((Node)storageCapabilitiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageAccountTypes");
                        if (storageAccountTypesSequenceElement != null) {
                            storageCapabilitiesInstance.setStorageAccountTypes(new ArrayList<String>());
                            for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)storageAccountTypesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageAccountType").size(); ++i3) {
                                Element storageAccountTypesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)storageAccountTypesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageAccountType").get(i3);
                                storageCapabilitiesInstance.getStorageAccountTypes().add(storageAccountTypesElement.getTextContent());
                            }
                        }
                    }
                    if ((computeCapabilitiesElement = XmlUtility.getElementByTagNameNS((Node)locationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComputeCapabilities")) == null) continue;
                    ComputeCapabilities computeCapabilitiesInstance = new ComputeCapabilities();
                    locationInstance.setComputeCapabilities(computeCapabilitiesInstance);
                    Element virtualMachinesRoleSizesSequenceElement = XmlUtility.getElementByTagNameNS((Node)computeCapabilitiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualMachinesRoleSizes");
                    if (virtualMachinesRoleSizesSequenceElement != null) {
                        for (int i4 = 0; i4 < XmlUtility.getElementsByTagNameNS((Node)virtualMachinesRoleSizesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize").size(); ++i4) {
                            Element virtualMachinesRoleSizesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)virtualMachinesRoleSizesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize").get(i4);
                            computeCapabilitiesInstance.getVirtualMachinesRoleSizes().add(virtualMachinesRoleSizesElement.getTextContent());
                        }
                    }
                    if ((webWorkerRoleSizesSequenceElement = XmlUtility.getElementByTagNameNS((Node)computeCapabilitiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"WebWorkerRoleSizes")) == null) continue;
                    for (int i5 = 0; i5 < XmlUtility.getElementsByTagNameNS((Node)webWorkerRoleSizesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize").size(); ++i5) {
                        Element webWorkerRoleSizesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)webWorkerRoleSizesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize").get(i5);
                        computeCapabilitiesInstance.getWebWorkerRoleSizes().add(webWorkerRoleSizesElement.getTextContent());
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            LocationsListResponse locationsListResponse = result;
            return locationsListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

