/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.maven.AuthenticationSetting;
import com.microsoft.azure.maven.auth.AuthConfiguration;
import com.microsoft.azure.maven.auth.AzureAuthHelper;
import com.microsoft.azure.maven.telemetry.AppInsightsProxy;
import com.microsoft.azure.maven.telemetry.GetHashMac;
import com.microsoft.azure.maven.telemetry.TelemetryConfiguration;
import com.microsoft.azure.maven.telemetry.TelemetryProxy;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAzureMojo
extends AbstractMojo
implements TelemetryConfiguration,
AuthConfiguration {
    public static final String AZURE_INIT_FAIL = "Failed to initialize Azure client object.";
    public static final String FAILURE_REASON = "failureReason";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File buildDirectory;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter
    protected AuthenticationSetting authentication;
    @Parameter
    protected String subscriptionId = "";
    @Parameter(property="allowTelemetry", defaultValue="true")
    protected boolean allowTelemetry;
    @Parameter(property="failsOnError", defaultValue="true")
    protected boolean failsOnError;
    private Azure azure;
    private TelemetryProxy telemetryProxy;
    private String sessionId = UUID.randomUUID().toString();
    private String installationId = GetHashMac.getHashMac();

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public String getBuildDirectoryAbsolutePath() {
        return this.buildDirectory.getAbsolutePath();
    }

    public MavenResourcesFiltering getMavenResourcesFiltering() {
        return this.mavenResourcesFiltering;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public AuthenticationSetting getAuthenticationSetting() {
        return this.authentication;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean isTelemetryAllowed() {
        return this.allowTelemetry;
    }

    public boolean isFailingOnError() {
        return this.failsOnError;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getInstallationId() {
        return this.installationId;
    }

    @Override
    public String getPluginName() {
        return this.plugin.getArtifactId();
    }

    @Override
    public String getPluginVersion() {
        return this.plugin.getVersion();
    }

    @Override
    public String getUserAgent() {
        return String.format("%s/%s %s:%s %s:%s", this.getPluginName(), this.getPluginVersion(), "installationId", this.getInstallationId(), "sessionId", this.getSessionId());
    }

    public Azure getAzureClient() {
        if (this.azure == null) {
            this.initAzureClient();
        }
        return this.azure;
    }

    protected void initAzureClient() {
        this.azure = new AzureAuthHelper(this).getAzureClient();
    }

    public TelemetryProxy getTelemetryProxy() {
        if (this.telemetryProxy == null) {
            this.initTelemetry();
        }
        return this.telemetryProxy;
    }

    protected void initTelemetry() {
        this.telemetryProxy = new AppInsightsProxy(this);
        if (!this.isTelemetryAllowed()) {
            this.telemetryProxy.trackEvent("TelemetryNotAllowed");
            this.telemetryProxy.disable();
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.getAzureClient() == null) {
                this.getTelemetryProxy().trackEvent("InitFailure");
                throw new MojoExecutionException(AZURE_INIT_FAIL);
            }
            this.getTelemetryProxy().addDefaultProperty("subscriptionId", this.getAzureClient().subscriptionId());
            this.trackMojoStart();
            this.doExecute();
            this.trackMojoSuccess();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected abstract void doExecute() throws Exception;

    protected void trackMojoStart() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".start");
    }

    protected void trackMojoSuccess() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".success");
    }

    protected void trackMojoFailure(String message) {
        HashMap<String, String> failureReason = new HashMap<String, String>();
        failureReason.put(FAILURE_REASON, message);
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".failure", failureReason);
    }

    protected void handleException(Exception exception) throws MojoExecutionException {
        String message = exception.getMessage();
        if (StringUtils.isEmpty((String)message)) {
            this.trackMojoFailure(exception.toString());
        } else {
            this.trackMojoFailure(message);
        }
        if (this.isFailingOnError()) {
            throw new MojoExecutionException(message, exception);
        }
        this.getLog().error((CharSequence)message);
    }
}

