/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class Utils {
    public static Server getServer(Settings settings, String serverId) {
        if (settings == null || StringUtils.isEmpty((String)serverId)) {
            return null;
        }
        return settings.getServer(serverId);
    }

    public static String getValueFromServerConfiguration(Server server, String key) {
        if (server == null) {
            return null;
        }
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        if (configuration == null) {
            return null;
        }
        Xpp3Dom node = configuration.getChild(key);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public static void copyResources(MavenProject project, MavenSession session, MavenResourcesFiltering filtering, List<Resource> resources, String targetDirectory) throws IOException {
        for (Resource resource : resources) {
            String targetPath = resource.getTargetPath() == null ? "" : resource.getTargetPath();
            resource.setTargetPath(Paths.get(targetDirectory, targetPath).toString());
            resource.setFiltering(false);
        }
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, new File(targetDirectory), project, "UTF-8", null, Collections.EMPTY_LIST, session);
        mavenResourcesExecution.setEscapeWindowsPaths(true);
        mavenResourcesExecution.setInjectProjectBuildFilters(false);
        mavenResourcesExecution.setOverwrite(true);
        mavenResourcesExecution.setIncludeEmptyDirs(false);
        mavenResourcesExecution.setSupportMultiLineFiltering(false);
        try {
            filtering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException ex) {
            throw new IOException("Failed to copy resources", ex);
        }
    }
}

