/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.maven.AbstractAppServiceMojo;
import java.util.UUID;
import org.codehaus.plexus.util.StringUtils;

public class AppServiceUtils {
    public static AppServicePlan getAppServicePlan(AbstractAppServiceMojo mojo) throws Exception {
        String servicePlanName = mojo.getAppServicePlanName();
        if (StringUtils.isNotEmpty((String)servicePlanName)) {
            String servicePlanResGrp = AppServiceUtils.getAppServicePlanResourceGroup(mojo);
            return (AppServicePlan)mojo.getAzureClient().appServices().appServicePlans().getByResourceGroup(servicePlanResGrp, servicePlanName);
        }
        return null;
    }

    public static String getAppServicePlanResourceGroup(AbstractAppServiceMojo mojo) {
        String defaultResourceGroup = mojo.getResourceGroup();
        return StringUtils.isEmpty((String)mojo.getAppServicePlanResourceGroup()) ? defaultResourceGroup : mojo.getAppServicePlanResourceGroup();
    }

    public static String getAppServicePlanName(AbstractAppServiceMojo mojo) {
        return StringUtils.isEmpty((String)mojo.getAppServicePlanName()) ? AppServiceUtils.generateRandomServicePlanName() : mojo.getAppServicePlanName();
    }

    private static String generateRandomServicePlanName() {
        return "ServicePlan" + UUID.randomUUID().toString().substring(0, 18);
    }
}

