/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSenderFactory;
import com.microsoft.azure.maven.telemetry.TelemetryProxy;
import com.microsoft.azure.toolkit.lib.common.utils.InstallationIdUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public enum AppInsightHelper implements TelemetryProxy
{
    INSTANCE;

    private boolean isEnabled = true;
    private String sessionId;
    private TelemetryClient client = new TelemetryClient();
    private Map<String, String> defaultProperties = new HashMap<String, String>();

    private AppInsightHelper() {
        this.sessionId = UUID.randomUUID().toString();
        this.defaultProperties.put("sessionId", this.sessionId);
        this.defaultProperties.put("installationId", InstallationIdUtils.getHashMac());
        this.initTelemetryHttpClient();
    }

    @Override
    public void enable() {
        this.isEnabled = true;
    }

    @Override
    public void disable() {
        this.trackEvent("TelemetryNotAllowed");
        this.isEnabled = false;
    }

    @Override
    public void trackEvent(String eventName) {
        this.trackEvent(eventName, null);
    }

    @Override
    public void trackEvent(String eventName, Map<String, String> customProperties) {
        this.trackEvent(eventName, customProperties, false);
    }

    @Override
    public void trackEvent(String eventName, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Map<String, String> properties = this.mergeProperties(customProperties, overrideDefaultProperties);
            this.client.trackEvent(eventName, properties, null);
            this.client.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initTelemetryHttpClient() {
        try {
            ApacheSenderFactory.INSTANCE.create().getHttpClient();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getInstallationId() {
        return InstallationIdUtils.getHashMac();
    }

    @Override
    public void addDefaultProperty(String key, String value) {
        this.defaultProperties.put(key, value);
    }

    protected Map<String, String> mergeProperties(Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (customProperties == null) {
            return this.defaultProperties;
        }
        Map<String, String> baseMap = overrideDefaultProperties ? this.defaultProperties : customProperties;
        Map<String, String> addMap = overrideDefaultProperties ? customProperties : this.defaultProperties;
        HashMap<String, String> result = new HashMap<String, String>(baseMap);
        result.putAll(addMap);
        return result;
    }

    @Override
    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }
}

