/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.maven.common.messager;

import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenAzureMessager
implements IAzureMessager {
    private static final Logger log = LoggerFactory.getLogger(MavenAzureMessager.class);

    public boolean show(IAzureMessage message) {
        switch (message.getType()) {
            case ALERT: 
            case CONFIRM: 
            case WARNING: {
                log.warn(message.getMessage());
                return true;
            }
            case ERROR: {
                log.error(message.getMessage(), (Throwable)message.getPayload());
                return true;
            }
        }
        log.info(message.getMessage());
        return true;
    }

    public String value(String val) {
        return TextUtils.cyan((String)val);
    }
}

