/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.google.common.base.Preconditions;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.legacy.docker.IDockerCredentialProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class MavenDockerCredentialProvider
implements IDockerCredentialProvider {
    private Server server;
    private Settings settings;
    private String serverId;

    public MavenDockerCredentialProvider(Settings settings, String serverId) {
        if (StringUtils.isNotBlank((CharSequence)serverId)) {
            Preconditions.checkNotNull((Object)settings, (Object)"Maven 'settings' is required");
            this.serverId = serverId;
            this.settings = settings;
        }
    }

    public static MavenDockerCredentialProvider fromMavenSettings(Settings settings, String serverId) {
        return new MavenDockerCredentialProvider(settings, serverId);
    }

    public String getUsername() throws AzureExecutionException {
        if (this.server == null) {
            this.initializeServer();
        }
        return this.server != null ? this.server.getUsername() : null;
    }

    public String getPassword() throws AzureExecutionException {
        if (this.server == null) {
            this.initializeServer();
        }
        return this.server != null ? this.server.getPassword() : null;
    }

    public void validate() throws AzureExecutionException {
        if (this.server == null) {
            this.initializeServer();
        }
    }

    private void initializeServer() throws AzureExecutionException {
        if (StringUtils.isNotBlank((CharSequence)this.serverId)) {
            this.server = this.settings.getServer(this.serverId);
            if (this.server == null) {
                throw new AzureExecutionException(String.format("Server not found in settings.xml. ServerId=%s", this.serverId));
            }
        }
    }
}

