/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.microsoft.azure.maven.JavaProject;
import com.microsoft.azure.toolkit.lib.common.IProject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class ProjectUtils {
    public static IProject convertCommonProject(MavenProject project) {
        if (project == null) {
            return null;
        }
        JavaProject proj = new JavaProject();
        proj.setProjectName(project.getName());
        proj.setBaseDirectory(project.getBasedir().toPath());
        String artifactFileName = project.getBuild().getFinalName() + "." + project.getPackaging();
        proj.setArtifactFile(Paths.get(project.getBuild().getDirectory(), artifactFileName));
        proj.setClassesOutputDirectory(Paths.get(project.getBuild().getOutputDirectory(), new String[0]));
        proj.setDependencies(ProjectUtils.collectDependencyPaths(project.getArtifacts()));
        proj.setBuildDirectory(Paths.get(project.getBuild().getDirectory(), new String[0]));
        return proj;
    }

    private static List<Path> collectDependencyPaths(Set<Artifact> dependencies) {
        ArrayList<Path> results = new ArrayList<Path>();
        for (Artifact artifact : dependencies) {
            results.add(artifact.getFile().toPath());
        }
        return results;
    }
}

