/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.artifacthandler;

import com.microsoft.azure.maven.AbstractAppServiceMojo;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class ArtifactHandlerBase<T extends AbstractAppServiceMojo>
implements ArtifactHandler {
    protected T mojo;

    public ArtifactHandlerBase(@Nonnull T mojo) {
        this.mojo = mojo;
    }

    protected void assureStagingDirectoryNotEmpty() throws MojoExecutionException {
        File stagingDirectory = new File(((AbstractAppServiceMojo)this.mojo).getDeploymentStagingDirectoryPath());
        File[] files = stagingDirectory.listFiles();
        if (!stagingDirectory.exists() || !stagingDirectory.isDirectory() || files == null || files.length == 0) {
            throw new MojoExecutionException(String.format("Staging directory: '%s' is empty.", stagingDirectory.getAbsolutePath()));
        }
    }

    protected void prepareResources() throws IOException, MojoExecutionException {
        List<Resource> resources = ((AbstractAppServiceMojo)this.mojo).getResources();
        if (resources == null || resources.isEmpty()) {
            throw new MojoExecutionException("<resources> is empty. Please make sure it is configured in pom.xml.");
        }
        Utils.copyResources(((AbstractAzureMojo)this.mojo).getProject(), ((AbstractAzureMojo)this.mojo).getSession(), ((AbstractAzureMojo)this.mojo).getMavenResourcesFiltering(), resources, ((AbstractAppServiceMojo)this.mojo).getDeploymentStagingDirectoryPath());
    }
}

