/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.artifacthandler;

import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.maven.AbstractAppServiceMojo;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandlerBase;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.zeroturnaround.zip.ZipUtil;

public class ZIPArtifactHandlerImpl<T extends AbstractAppServiceMojo>
extends ArtifactHandlerBase<T> {
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private static final String LOCAL_SETTINGS_FILE = "local.settings.json";

    public ZIPArtifactHandlerImpl(@Nonnull T mojo) {
        super(mojo);
    }

    protected boolean isResourcesPreparationRequired(DeployTarget target) {
        return !(target.getApp() instanceof FunctionApp);
    }

    public void publish(DeployTarget target) throws MojoExecutionException, IOException {
        int retryCount;
        if (this.isResourcesPreparationRequired(target)) {
            this.prepareResources();
        }
        this.assureStagingDirectoryNotEmpty();
        File zipFile = this.getZipFile();
        for (retryCount = 0; retryCount < 3; ++retryCount) {
            try {
                target.zipDeploy(zipFile);
                return;
            }
            catch (Exception e) {
                this.mojo.getLog().debug((CharSequence)String.format("Exception occurred when deploying the zip package: %s, retrying immediately (%d/%d)", e.getMessage(), retryCount, 3));
                continue;
            }
        }
        throw new MojoExecutionException(String.format("The zip deploy failed after %d times of retry.", retryCount));
    }

    protected File getZipFile() {
        String stagingDirectoryPath = this.mojo.getDeploymentStagingDirectoryPath();
        File zipFile = new File(stagingDirectoryPath + ".zip");
        File stagingDirectory = new File(stagingDirectoryPath);
        ZipUtil.pack((File)stagingDirectory, (File)zipFile);
        ZipUtil.removeEntry((File)zipFile, (String)LOCAL_SETTINGS_FILE);
        return zipFile;
    }
}

