/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.telemetry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetHashMac {
    public static final String MAC_REGEX = "([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}";
    public static final String MAC_REGEX_ZERO = "([0]{2}[:-]){5}[0]{2}";
    public static final String HASHED_MAC_REGEX = "[0-9a-f]{64}";

    public static boolean isValidHashMacFormat(String hashMac) {
        if (hashMac == null || hashMac.isEmpty()) {
            return false;
        }
        Pattern hashedMacPattern = Pattern.compile(HASHED_MAC_REGEX);
        Matcher matcher = hashedMacPattern.matcher(hashMac);
        return matcher.matches();
    }

    public static String getHashMac() {
        String rawMac = GetHashMac.getRawMac();
        if (rawMac == null || rawMac.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile(MAC_REGEX);
        Pattern patternZero = Pattern.compile(MAC_REGEX_ZERO);
        Matcher matcher = pattern.matcher(rawMac);
        String mac = "";
        while (matcher.find() && patternZero.matcher(mac = matcher.group(0)).matches()) {
        }
        return GetHashMac.hash(mac);
    }

    private static String getRawMac() {
        String ret = null;
        try {
            String tmp;
            String os = System.getProperty("os.name").toLowerCase();
            String[] command = new String[]{"ifconfig", "-a"};
            if (os != null && !os.isEmpty() && os.startsWith("win")) {
                command = new String[]{"getmac"};
            }
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader br = new BufferedReader(inputStreamReader);
            while ((tmp = br.readLine()) != null) {
                ret = ret + tmp;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (IOException ex) {
            return null;
        }
        return ret;
    }

    private static String hash(String mac) {
        String ret;
        if (mac == null || mac.isEmpty()) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] bytes = mac.getBytes("UTF-8");
            md.update(bytes);
            byte[] bytesAfterDigest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < bytesAfterDigest.length; ++i) {
                sb.append(Integer.toString((bytesAfterDigest[i] & 0xFF) + 256, 16).substring(1));
            }
            ret = sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        return ret;
    }
}

