/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.queryer;

import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.maven.queryer.MavenPluginQueryer;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;

public class MavenPluginQueryerDefaultImpl
extends MavenPluginQueryer {
    public static final String FOUND_VALID_VALUE = "Found valid value. Skip user input.";
    public static final String PROMPT_STRING_WITH_DEFAULTVALUE = "Define value for %s(Default: %s): ";
    public static final String PROMPT_STRING_WITHOUT_DEFAULTVALUE = "Define value for %s: ";
    public static final String DEFAULT_INPUT_ERROR_MESSAGE = "Invalid input, please check and try again.";
    public static final String DEFAULT_INPUT_ERROR_MESSAGE_WITH_REGEX = "Invalid input, value should match( %s ).";
    private Scanner reader = new Scanner(System.in);

    @Override
    public String assureInputFromUser(String attribute, String defaultValue, List<String> options, String prompt) {
        String initValue = this.getInitValue(attribute);
        if (initValue != null && this.validateInputByOptions(initValue, options)) {
            Log.info((String)FOUND_VALID_VALUE);
            return initValue;
        }
        prompt = StringUtils.isEmpty((CharSequence)prompt) ? this.getPromptString(attribute, defaultValue) : prompt;
        System.out.println(prompt);
        for (int i = 0; i < options.size(); ++i) {
            if (options.get(i) != null && options.get(i).equalsIgnoreCase(defaultValue)) {
                System.out.println(String.format("%d. %s [*]", i + 1, options.get(i)));
                continue;
            }
            System.out.println(String.format("%d. %s", i + 1, options.get(i)));
        }
        while (true) {
            System.out.print("Enter index to use: ");
            System.out.flush();
            try {
                String input = this.reader.nextLine();
                if (StringUtils.isEmpty((CharSequence)input) && this.validateInputByOptions(defaultValue, options)) {
                    return defaultValue;
                }
                int choice = Integer.parseInt(input);
                if (choice > 0 && choice <= options.size()) {
                    return options.get(choice - 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            System.out.println("Invalid index.");
        }
    }

    @Override
    public String assureInputFromUser(String attribute, String defaultValue, String regex, String prompt, String errorMessage) throws MojoFailureException {
        String initValue = this.getInitValue(attribute);
        if (initValue != null && this.validateInputByRegex(initValue, regex)) {
            Log.info((String)FOUND_VALID_VALUE);
            return initValue;
        }
        while (true) {
            prompt = StringUtils.isEmpty((CharSequence)prompt) ? this.getPromptString(attribute, defaultValue) : prompt;
            System.out.print(prompt);
            System.out.flush();
            String input = null;
            input = this.reader.nextLine();
            if (StringUtils.isNotEmpty((CharSequence)defaultValue) && StringUtils.isEmpty((CharSequence)input)) {
                return defaultValue;
            }
            if (this.validateInputByRegex(input, regex)) {
                return input;
            }
            errorMessage = StringUtils.isEmpty((CharSequence)errorMessage) ? this.getErrorMessage(regex) : errorMessage;
            System.out.println(errorMessage);
        }
    }

    private String getPromptString(String attributeName, String defaultValue) {
        return StringUtils.isBlank((CharSequence)defaultValue) ? String.format(PROMPT_STRING_WITHOUT_DEFAULTVALUE, attributeName) : String.format(PROMPT_STRING_WITH_DEFAULTVALUE, attributeName, defaultValue);
    }

    private String getErrorMessage(String regex) {
        return StringUtils.isEmpty((CharSequence)regex) ? DEFAULT_INPUT_ERROR_MESSAGE : String.format(DEFAULT_INPUT_ERROR_MESSAGE_WITH_REGEX, regex);
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

