/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.beryx.textio.TextTerminal;
import org.beryx.textio.console.ConsoleTextTerminalProvider;
import org.beryx.textio.jline.JLineTextTerminalProvider;
import org.beryx.textio.swing.SwingTextTerminalProvider;
import org.beryx.textio.system.SystemTextTerminalProvider;

public class TextIOUtils {
    private static TextTerminal textTerminal;
    private static List<Supplier<TextTerminal>> terminalSupplierList;

    public static synchronized TextTerminal getTextTerminal() {
        if (textTerminal == null) {
            for (Supplier<TextTerminal> supplier : terminalSupplierList) {
                try {
                    textTerminal = supplier.get();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (textTerminal == null) continue;
                break;
            }
        }
        return textTerminal;
    }

    static {
        terminalSupplierList = Arrays.asList(() -> new JLineTextTerminalProvider().getTextTerminal(), () -> new ConsoleTextTerminalProvider().getTextTerminal(), () -> new SwingTextTerminalProvider().getTextTerminal(), () -> new SystemTextTerminalProvider().getTextTerminal());
    }
}

