/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.prompt;

import com.microsoft.azure.maven.prompt.IPrompter;
import com.microsoft.azure.maven.prompt.InputValidateResult;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DefaultPrompter
implements IPrompter {
    private static final String EMPTY_REPLACEMENT = ":";
    private static final Pattern REGEX_COMMA_SEPARATED_INTEGER_RANGES = Pattern.compile("^[0-9]+(?:-[0-9]+)?(?:,[0-9]+(?:-[0-9]+)?)*$");
    private static final Pattern REGEX_NEXT_INTEGER_RANGE = Pattern.compile("([0-9]+)(?:-([0-9]+))?(?:,|$)", 4);
    private BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

    @Override
    public String promoteString(String message, String defaultValue, Function<String, InputValidateResult<String>> verify, boolean isRequired) throws IOException {
        boolean hasDefaultValue = StringUtils.isNotBlank((CharSequence)defaultValue);
        System.out.print(message);
        System.out.flush();
        return this.loopInput(defaultValue, hasDefaultValue, isRequired, "", message, input -> {
            if (!isRequired && StringUtils.equals((CharSequence)EMPTY_REPLACEMENT, (CharSequence)input.trim())) {
                return InputValidateResult.wrap("");
            }
            InputValidateResult result = (InputValidateResult)verify.apply((String)input);
            if (result.getErrorMessage() != null) {
                return InputValidateResult.error(result.getErrorMessage());
            }
            return InputValidateResult.wrap(result.getObj());
        });
    }

    @Override
    public Boolean promoteYesNo(String message, Boolean defaultValue, boolean isRequired) throws IOException {
        boolean hasDefaultValue = defaultValue != null;
        System.out.print(message);
        System.out.flush();
        return this.loopInput(defaultValue, hasDefaultValue, isRequired, "", message, input -> {
            if (input.equalsIgnoreCase("Y")) {
                return InputValidateResult.wrap(Boolean.TRUE);
            }
            if (input.equalsIgnoreCase("N")) {
                return InputValidateResult.wrap(Boolean.FALSE);
            }
            return InputValidateResult.error(String.format("Invalid input (%s).", input));
        });
    }

    @Override
    public <T> List<T> promoteMultipleEntities(String header, String promotePrefix, String selectNoneMessage, List<T> entities, Function<T, String> getNameFunc, boolean allowEmpty, String enterPromote, List<T> defaultValue) throws IOException {
        boolean hasDefaultValue = defaultValue != null && defaultValue.size() > 0;
        ArrayList<T> res = new ArrayList<T>();
        if (!allowEmpty && entities.size() == 1) {
            return entities;
        }
        DefaultPrompter.printOptionList(header, entities, null, getNameFunc);
        String example = TextUtils.blue((String)"[1-2,4,6]");
        String hintMessage = String.format("(input numbers separated by comma, eg: %s, %s %s)", example, TextUtils.blue((String)"ENTER"), enterPromote);
        String promoteMessage = String.format("%s%s: ", promotePrefix, hintMessage);
        while (true) {
            System.out.print(promoteMessage);
            System.out.flush();
            String input = this.reader.readLine();
            if (StringUtils.isBlank((CharSequence)input)) {
                if (hasDefaultValue) {
                    return defaultValue;
                }
                if (allowEmpty) {
                    return res;
                }
                System.out.println(selectNoneMessage);
            }
            if (DefaultPrompter.isValidIntRangeInput(input)) {
                try {
                    for (int i : DefaultPrompter.parseIntRanges(input, entities.size())) {
                        res.add(entities.get(i - 1));
                    }
                    if (res.size() > 0 || allowEmpty) {
                        return res;
                    }
                    System.out.print(selectNoneMessage);
                }
                catch (NumberFormatException ex) {
                    System.out.println(TextUtils.yellow((String)String.format("The input value('%s') is invalid.", input)));
                }
            } else {
                System.out.println(TextUtils.yellow((String)String.format("The input value('%s') is invalid.", input)));
            }
            System.out.flush();
        }
    }

    @Override
    public <T> T promoteSingleEntity(String header, String message, List<T> entities, T defaultEntity, Function<T, String> getNameFunc, boolean isRequired) throws IOException {
        boolean hasDefaultValue = defaultEntity != null;
        DefaultPrompter.printOptionList(header, entities, defaultEntity, getNameFunc);
        int selectedIndex = entities.indexOf(defaultEntity);
        String defaultValueMessage = selectedIndex >= 0 ? " (" + TextUtils.blue((String)Integer.toString(selectedIndex + 1)) + ")" : "";
        String hintMessage = String.format("[1-%d]%s", entities.size(), defaultValueMessage);
        String promoteMessage = String.format("%s %s: ", message, hintMessage);
        System.out.print(promoteMessage);
        System.out.flush();
        return this.loopInput(defaultEntity, hasDefaultValue, isRequired, null, promoteMessage, input -> {
            InputValidateResult<Integer> selectIndex = this.validateUserInputAsInteger((String)input, entities.size(), String.format("You have input a wrong value %s.", TextUtils.red((String)input)));
            if (selectIndex.getErrorMessage() == null) {
                return InputValidateResult.wrap(entities.get(selectIndex.getObj() - 1));
            }
            return InputValidateResult.error(selectIndex.getErrorMessage());
        });
    }

    private <T> T loopInput(T defaultValue, boolean hasDefaultValue, boolean isRequired, String emptyPromoteMessage, String promoteMessage, Function<String, InputValidateResult<T>> handleInput) throws IOException {
        while (true) {
            String input;
            if (StringUtils.isBlank((CharSequence)(input = this.reader.readLine()))) {
                if (hasDefaultValue || !isRequired) {
                    return defaultValue;
                }
                System.out.print(emptyPromoteMessage);
            } else {
                InputValidateResult<T> res = handleInput.apply(input);
                if (res.getErrorMessage() != null) {
                    System.out.println(TextUtils.yellow((String)res.getErrorMessage()));
                } else {
                    return res.getObj();
                }
            }
            System.out.print(promoteMessage);
            System.out.flush();
        }
    }

    private InputValidateResult<Integer> validateUserInputAsInteger(String input, int maxValue, String message) {
        if (!NumberUtils.isDigits((String)input)) {
            return InputValidateResult.error(message);
        }
        try {
            int value = Integer.parseInt(input);
            if (value >= 1 && value <= maxValue) {
                return InputValidateResult.wrap(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return InputValidateResult.error(message);
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isValidIntRangeInput(String text) {
        return REGEX_COMMA_SEPARATED_INTEGER_RANGES.matcher(text).matches();
    }

    private static Collection<Integer> parseIntRanges(String text, int maxValue) {
        Matcher m = REGEX_NEXT_INTEGER_RANGE.matcher(text);
        LinkedHashSet<Integer> values = new LinkedHashSet<Integer>();
        while (m.find()) {
            int s1 = Integer.parseInt(m.group(1));
            if (m.group(2) != null) {
                int s2 = Math.min(maxValue, Integer.parseInt(m.group(2)));
                for (int i = Math.max(1, s1); i <= s2; ++i) {
                    values.add(i);
                }
                continue;
            }
            if (s1 < 1 || s1 > maxValue) continue;
            values.add(s1);
        }
        return values;
    }

    private static <T> void printOptionList(String message, List<T> entities, T defaultEntity, Function<T, String> getNameFunc) {
        int index = 1;
        System.out.println(message);
        for (T entity : entities) {
            String displayLine = String.format("%2d. %s", index++, getNameFunc.apply(entity));
            System.out.println(defaultEntity == entity ? TextUtils.blue((String)(displayLine + "*")) : displayLine);
        }
    }
}

