/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import groovy.lang.MissingPropertyException;
import groovy.text.SimpleTemplateEngine;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(TemplateUtils.class);
    private static final SimpleTemplateEngine engine = new SimpleTemplateEngine();
    private static final String INVALID_TEMPLATE = "error occurs when evaluating template(%s) with bindings(%s)";
    private static final String MISSING_PROPERTY = "some properties are missing when evaluating template(%s) with bindings(%s)";

    public static Boolean evalBoolean(String expr, Map<String, Object> variableMap) {
        String text = TemplateUtils.evalPlainText(expr, variableMap);
        if (text == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(text);
    }

    public static String evalText(String expr, Map<String, Object> variableMap) {
        return TemplateUtils.evalPlainText(expr, variableMap).replaceAll("\\*\\*\\*(.*?)\\*\\*\\*", TextUtils.blue((String)"$1"));
    }

    public static String evalPlainText(String expr, Map<String, Object> variableMap) {
        String prev;
        String text = expr.contains(".") ? TemplateUtils.evalInline(expr, variableMap) : Objects.toString(variableMap.get(expr), null);
        int evalCount = 0;
        while (text != null && text.contains("${") && !StringUtils.equals((CharSequence)(prev = text), (CharSequence)(text = TemplateUtils.eval(text, variableMap))) && ++evalCount <= 5) {
        }
        return text;
    }

    private static String eval(String template, Map<String, Object> bindings) {
        try {
            return engine.createTemplate(template).make(bindings).toString();
        }
        catch (MissingPropertyException e) {
            log.debug(String.format(MISSING_PROPERTY, template, bindings));
        }
        catch (Exception e) {
            log.warn(String.format(INVALID_TEMPLATE, template, bindings), (Throwable)e);
        }
        return template;
    }

    private static String evalInline(String expr, Map<String, Object> variableMap) {
        return TemplateUtils.eval(String.format("${%s}", expr), variableMap);
    }

    public static String evalExpressionValue(@Nonnull String expr, @Nonnull Map<String, Object> variableMap) {
        String result = TemplateUtils.evalText(expr, variableMap);
        return StringUtils.equals((CharSequence)result, (CharSequence)String.format("${%s}", expr)) ? "" : result;
    }

    private TemplateUtils() {
    }
}

