/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;

public class MavenArtifactUtils {
    private static final String[] ARTIFACT_EXTENSIONS = new String[]{"jar"};
    private static final String ARTIFACT_NOT_SUPPORTED = "Target file does not exist or is not executable, please check the configuration.";
    private static final String MULTI_ARTIFACT = "Multiple artifacts(%s) could be deployed, please specify the target artifact in plugin configurations.";

    public static File getArtifactFromTargetFolder(MavenProject project) throws MojoExecutionException {
        String targetFolder = project.getBuild().getDirectory();
        Collection files = FileUtils.listFiles((File)new File(targetFolder), (String[])ARTIFACT_EXTENSIONS, (boolean)true);
        return MavenArtifactUtils.getExecutableJarFiles(files);
    }

    /*
     * Exception decompiling
     */
    public static boolean isExecutableJar(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<File> getArtifacts(List<Resource> resources) {
        ArrayList<File> result = new ArrayList<File>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        for (Resource resource : resources) {
            if (resource.getIncludes() == null || resource.getIncludes().size() <= 0) continue;
            directoryScanner.setBasedir(resource.getDirectory());
            directoryScanner.setIncludes(resource.getIncludes().toArray(new String[0]));
            String[] exclude = resource.getExcludes() == null ? new String[]{} : resource.getExcludes().toArray(new String[0]);
            directoryScanner.setExcludes(exclude);
            directoryScanner.scan();
            List resourceFiles = Arrays.stream(directoryScanner.getIncludedFiles()).map(path -> new File(resource.getDirectory(), (String)path)).collect(Collectors.toList());
            result.addAll(resourceFiles);
        }
        return result;
    }

    public static File getExecutableJarFiles(Collection<File> files) throws MojoExecutionException {
        List executableJars = files.stream().filter(MavenArtifactUtils::isExecutableJar).collect(Collectors.toList());
        if (executableJars.isEmpty()) {
            throw new MojoExecutionException(ARTIFACT_NOT_SUPPORTED);
        }
        if (executableJars.size() > 1) {
            String artifactNameLists = executableJars.stream().map(File::getName).collect(Collectors.joining(","));
            throw new MojoExecutionException(String.format(MULTI_ARTIFACT, artifactNameLists));
        }
        return (File)executableJars.get(0);
    }
}

