/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.common.utils.IndentUtil;
import com.microsoft.azure.common.utils.TextUtils;
import com.microsoft.azure.maven.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultText;
import org.xml.sax.Locator;
import org.xml.sax.XMLReader;

public class PomUtils {
    public static Element getPluginConfigNode(PluginDescriptor plugin, File pom) throws FileNotFoundException, DocumentException {
        CustomSAXReader reader = new CustomSAXReader();
        reader.setDocumentFactory(new LocatorAwareDocumentFactory());
        Document doc = reader.read(new InputStreamReader(new FileInputStream(pom)));
        Element pluginsNode = PomUtils.getOrCreateNode(doc.getRootElement(), "build", "plugins");
        Element pluginConfigNode = null;
        for (Element element : pluginsNode.elements()) {
            String groupId = XmlUtils.getChildValue(element, "groupId");
            String artifactId = XmlUtils.getChildValue(element, "artifactId");
            String version = XmlUtils.getChildValue(element, "version");
            if (!plugin.getGroupId().equals(groupId) || !plugin.getArtifactId().equals(artifactId) || version != null && !StringUtils.equals((CharSequence)plugin.getVersion(), (CharSequence)version)) continue;
            pluginConfigNode = element;
        }
        if (pluginConfigNode == null) {
            pluginConfigNode = PomUtils.addPluginNode(pluginsNode, plugin);
        }
        return pluginConfigNode;
    }

    public static String formatNode(String originalXml, LocationAwareElement parent, Element newNode) {
        String[] originXmlLines = TextUtils.splitLines((String)originalXml);
        String baseIndent = IndentUtil.calcXmlIndent((String[])originXmlLines, (int)(parent.getLineNumber() - 1), (int)(parent.getColumnNumber() - 2));
        String placeHolder = String.format("@PLACEHOLDER_RANDOM_%s@", RandomUtils.nextLong());
        DefaultText placeHolderNode = new DefaultText("\n" + placeHolder);
        parent.content().replaceAll(arg_0 -> PomUtils.lambda$formatNode$0(newNode, (Text)placeHolderNode, arg_0));
        newNode.setParent(null);
        XmlUtils.trimTextBeforeEnd((Element)parent, (Node)placeHolderNode);
        String xmlWithPlaceholder = parent.getDocument().asXML();
        String[] newXmlLines = TextUtils.splitLines((String)XmlUtils.prettyPrintElementNoNamespace(newNode));
        String replacement = Arrays.stream(newXmlLines).map(t -> baseIndent + "    " + t).collect(Collectors.joining("\n")) + "\n" + baseIndent;
        return xmlWithPlaceholder.replace(placeHolder, replacement);
    }

    public static Element addPluginNode(Element pluginsRootNode, PluginDescriptor plugin) {
        DOMElement result = new DOMElement("plugin");
        XmlUtils.addDomWithKeyValue((Element)result, "groupId", plugin.getGroupId());
        XmlUtils.addDomWithKeyValue((Element)result, "artifactId", plugin.getArtifactId());
        XmlUtils.addDomWithKeyValue((Element)result, "version", plugin.getVersion());
        pluginsRootNode.add((Element)result);
        return result;
    }

    public static Element getOrCreateNode(Element node, String ... paths) {
        for (String path : paths) {
            Element newNode = node.element(path);
            if (newNode == null) {
                newNode = new DOMElement(path);
                node.add(newNode);
            }
            node = newNode;
        }
        return node;
    }

    public static void updateNode(Element ele, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            XmlUtils.addDomWithKeyValue(ele, entry.getKey(), entry.getValue());
        }
    }

    private static /* synthetic */ Node lambda$formatNode$0(Element newNode, Text placeHolderNode, Node t) {
        return t == newNode ? placeHolderNode : t;
    }

    public static class LocationAwareElement
    extends DefaultElement {
        private static final long serialVersionUID = 260126644771458700L;
        private int lineNumber;
        private int columnNumber;

        public LocationAwareElement(QName qname) {
            super(qname);
        }

        public LocationAwareElement(QName qname, int attributeCount) {
            super(qname, attributeCount);
        }

        public LocationAwareElement(String name, Namespace namespace) {
            super(name, namespace);
        }

        public LocationAwareElement(String name) {
            super(name);
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public void setColumnNumber(int columnNumber) {
            this.columnNumber = columnNumber;
        }
    }

    static class LocatorAwareDocumentFactory
    extends DocumentFactory {
        private static final long serialVersionUID = 7388661832037675334L;
        private Locator locator;

        public void setLocator(Locator locator) {
            this.locator = locator;
        }

        public Element createElement(QName qname) {
            LocationAwareElement element = new LocationAwareElement(qname);
            if (this.locator != null) {
                element.setLineNumber(this.locator.getLineNumber());
                element.setColumnNumber(this.locator.getColumnNumber());
            }
            return element;
        }
    }

    static class CustomSAXContentHandler
    extends SAXContentHandler {
        private DocumentFactory documentFactory;

        public CustomSAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler) {
            super(documentFactory, elementHandler);
            this.documentFactory = documentFactory;
        }

        public void setDocumentLocator(Locator documentLocator) {
            super.setDocumentLocator(documentLocator);
            if (this.documentFactory instanceof LocatorAwareDocumentFactory) {
                ((LocatorAwareDocumentFactory)this.documentFactory).setLocator(documentLocator);
            }
        }
    }

    static class CustomSAXReader
    extends SAXReader {
        CustomSAXReader() {
        }

        protected SAXContentHandler createContentHandler(XMLReader reader) {
            return new CustomSAXContentHandler(this.getDocumentFactory(), (ElementHandler)this.getDispatchHandler());
        }

        public void setDocumentFactory(DocumentFactory documentFactory) {
            super.setDocumentFactory(documentFactory);
        }
    }
}

