/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.common.utils.TextUtils;
import java.util.Map;
import java.util.Objects;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;

public class TemplateUtils {
    public static Boolean evalBoolean(String expr, Map<String, Object> variableMap) {
        String text = TemplateUtils.evalPlainText(expr, variableMap);
        if (text == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(text);
    }

    public static String evalText(String expr, Map<String, Object> variableMap) {
        return TemplateUtils.evalPlainText(expr, variableMap).replaceAll("\\*\\*\\*(.*?)\\*\\*\\*", TextUtils.blue((String)"$1"));
    }

    public static String evalPlainText(String expr, Map<String, Object> variableMap) {
        String text = expr.contains(".") ? TemplateUtils.evalInline(expr, variableMap) : Objects.toString(variableMap.get(expr), null);
        int evalCount = 0;
        while (text != null && text.contains("{{")) {
            text = TemplateUtils.eval(text, variableMap);
            if (++evalCount <= 5) continue;
            break;
        }
        return text;
    }

    private static String eval(String expr, Map<String, Object> variableMap) {
        JtwigTemplate template = JtwigTemplate.inlineTemplate((String)expr);
        JtwigModel model = JtwigModel.newModel();
        variableMap.entrySet().forEach(t -> model.with((String)t.getKey(), t.getValue()));
        return template.render(model);
    }

    private static String evalInline(String expr, Map<String, Object> variableMap) {
        return TemplateUtils.eval(String.format("{{%s}}", expr), variableMap);
    }

    private TemplateUtils() {
    }
}

