/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.implementation;

import com.microsoft.windowsazure.core.RFC1123DateConverter;
import com.microsoft.windowsazure.core.UserAgentFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterRequestAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterResponseAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.HttpURLConnectionClient;
import com.microsoft.windowsazure.core.pipeline.jersey.ServiceFilter;
import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.implementation.BlobOperationRestProxy;
import com.microsoft.windowsazure.services.blob.implementation.SharedKeyFilter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;

public class BlobRestProxy
extends BlobOperationRestProxy
implements BlobContract {
    private final SharedKeyFilter sharedKeyFilter;

    @Inject
    public BlobRestProxy(HttpURLConnectionClient channel, @Named(value="blob.accountName") String accountName, @Named(value="blob.uri") String url, SharedKeyFilter sharedKeyFilter, UserAgentFilter userAgentFilter) {
        super((Client)channel, accountName, url);
        this.sharedKeyFilter = sharedKeyFilter;
        channel.addFilter((ClientFilter)sharedKeyFilter);
        channel.addFilter((ClientFilter)new ClientFilterRequestAdapter((ServiceRequestFilter)userAgentFilter));
    }

    public BlobRestProxy(Client client, ClientFilter[] filters, String accountName, String url, SharedKeyFilter sharedKeyFilter, RFC1123DateConverter dateMapper) {
        super(client, filters, accountName, url, dateMapper);
        this.sharedKeyFilter = sharedKeyFilter;
    }

    public BlobContract withFilter(ServiceFilter filter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterAdapter(filter);
        return new BlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.sharedKeyFilter, this.getDateMapper());
    }

    @Override
    public BlobContract withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = new ClientFilter[currentFilters.length + 1];
        System.arraycopy(currentFilters, 0, newFilters, 1, currentFilters.length);
        newFilters[0] = new ClientFilterRequestAdapter(serviceRequestFilter);
        return new BlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.sharedKeyFilter, this.getDateMapper());
    }

    @Override
    public BlobContract withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterRequestAdapter(serviceRequestFilter);
        return new BlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.sharedKeyFilter, this.getDateMapper());
    }

    @Override
    public BlobContract withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = new ClientFilter[currentFilters.length + 1];
        System.arraycopy(currentFilters, 0, newFilters, 1, currentFilters.length);
        newFilters[0] = new ClientFilterResponseAdapter(serviceResponseFilter);
        return new BlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.sharedKeyFilter, this.getDateMapper());
    }

    @Override
    public BlobContract withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterResponseAdapter(serviceResponseFilter);
        return new BlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.sharedKeyFilter, this.getDateMapper());
    }
}

