/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.implementation;

import com.microsoft.windowsazure.core.RFC1123DateConverter;
import com.microsoft.windowsazure.core.pipeline.jersey.EntityStreamingListener;
import com.microsoft.windowsazure.services.blob.implementation.HmacSHA256Sign;
import com.microsoft.windowsazure.services.blob.implementation.SharedKeyUtils;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Date;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedKeyLiteFilter
extends ClientFilter
implements EntityStreamingListener {
    private static Log log = LogFactory.getLog(SharedKeyLiteFilter.class);
    private final String accountName;
    private final HmacSHA256Sign signer;

    public SharedKeyLiteFilter(@Named(value="blob.accountName") String accountName, @Named(value="blob.accountKey") String accountKey) {
        this.accountName = accountName;
        this.signer = new HmacSHA256Sign(accountKey);
    }

    public ClientResponse handle(ClientRequest cr) {
        if (cr.getProperties().get(SharedKeyUtils.AUTHORIZATION_FILTER_MARKER) == null) {
            cr.getProperties().put(SharedKeyUtils.AUTHORIZATION_FILTER_MARKER, null);
            if (cr.getProperties().get(EntityStreamingListener.class.getName()) == null) {
                cr.getProperties().put(EntityStreamingListener.class.getName(), this);
            }
        }
        return this.getNext().handle(cr);
    }

    public void onBeforeStreamingEntity(ClientRequest clientRequest) {
        this.sign(clientRequest);
    }

    public void sign(ClientRequest cr) {
        String requestMethod = cr.getMethod();
        String contentMD5 = this.getHeader(cr, "Content-MD5");
        String contentType = this.getHeader(cr, "Content-Type");
        String date = this.getHeader(cr, "Date");
        if (date == "") {
            date = new RFC1123DateConverter().format(new Date());
            cr.getHeaders().add((Object)"Date", (Object)date);
        }
        String stringToSign = requestMethod + "\n" + contentMD5 + "\n" + contentType + "\n" + date + "\n";
        stringToSign = stringToSign + this.addCanonicalizedHeaders(cr);
        stringToSign = stringToSign + this.addCanonicalizedResource(cr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("String to sign: \"%s\"", stringToSign));
        }
        String signature = this.signer.sign(stringToSign);
        cr.getHeaders().putSingle((Object)"Authorization", (Object)("SharedKeyLite " + this.accountName + ":" + signature));
    }

    private String addCanonicalizedHeaders(ClientRequest cr) {
        return SharedKeyUtils.getCanonicalizedHeaders(cr);
    }

    private String addCanonicalizedResource(ClientRequest cr) {
        String result = "/" + this.accountName;
        result = result + cr.getURI().getPath();
        List<SharedKeyUtils.QueryParam> queryParams = SharedKeyUtils.getQueryParams(cr.getURI().getQuery());
        for (SharedKeyUtils.QueryParam p : queryParams) {
            if (!"comp".equals(p.getName())) continue;
            result = result + "?" + p.getName() + "=" + p.getValues().get(0);
        }
        return result;
    }

    private String getHeader(ClientRequest cr, String headerKey) {
        return SharedKeyUtils.getHeader(cr, headerKey);
    }
}

