/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.MediaContract;
import com.microsoft.windowsazure.services.media.entityoperations.EntityWithOperationIdentifier;
import com.microsoft.windowsazure.services.media.models.Operation;
import com.microsoft.windowsazure.services.media.models.OperationInfo;
import com.microsoft.windowsazure.services.media.models.OperationState;

public final class OperationUtils {
    private OperationUtils() {
    }

    public static OperationState await(MediaContract service, String operationId) throws ServiceException {
        OperationInfo opinfo;
        if (operationId == null) {
            return OperationState.Succeeded;
        }
        do {
            opinfo = (OperationInfo)service.get(Operation.get(operationId));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (opinfo.getState().equals((Object)OperationState.InProgress));
        return opinfo.getState();
    }

    public static OperationState await(MediaContract service, EntityWithOperationIdentifier entity) throws ServiceException {
        if (entity.hasOperationIdentifier()) {
            return OperationUtils.await(service, entity.getOperationId());
        }
        return OperationState.Succeeded;
    }
}

