/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.core.pipeline.jersey.IdempotentClientFilter;
import com.microsoft.windowsazure.services.media.authentication.AzureAdAccessToken;
import com.microsoft.windowsazure.services.media.authentication.TokenProvider;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import javax.inject.Named;

public class OAuthFilter
extends IdempotentClientFilter {
    private final TokenProvider azureAdTokenProvider;

    public OAuthFilter(@Named(value="media.azuread.tokenprovider") TokenProvider azureAdTokenProvider) {
        this.azureAdTokenProvider = azureAdTokenProvider;
    }

    public ClientResponse doHandle(ClientRequest clientRequest) {
        AzureAdAccessToken accessToken;
        try {
            accessToken = this.azureAdTokenProvider.acquireAccessToken();
        }
        catch (Exception e) {
            throw new ClientHandlerException("Failed to acquire access token", (Throwable)e);
        }
        clientRequest.getHeaders().add((Object)"Authorization", (Object)("Bearer " + accessToken.getAccessToken()));
        return this.getNext().handle(clientRequest);
    }
}

