/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation.templates.playreadylicense;

import com.microsoft.windowsazure.services.media.implementation.templates.playreadylicense.PlayReadyLicenseResponseTemplate;
import com.microsoft.windowsazure.services.media.implementation.templates.playreadylicense.PlayReadyLicenseTemplate;
import com.microsoft.windowsazure.services.media.implementation.templates.playreadylicense.PlayReadyLicenseType;
import com.microsoft.windowsazure.services.media.implementation.templates.playreadylicense.UnknownOutputPassingOption;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class MediaServicesLicenseTemplateSerializer {
    private MediaServicesLicenseTemplateSerializer() {
    }

    public static String serialize(PlayReadyLicenseResponseTemplate template) throws JAXBException {
        MediaServicesLicenseTemplateSerializer.validateLicenseResponseTemplate(template);
        StringWriter writer = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PlayReadyLicenseResponseTemplate.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapper(){

            public String[] getPreDeclaredNamespaceUris() {
                return new String[]{"http://www.w3.org/2001/XMLSchema-instance"};
            }

            public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
                if (namespaceUri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    return "i";
                }
                return suggestion;
            }
        });
        m.marshal((Object)template, (Writer)writer);
        return writer.toString();
    }

    public static PlayReadyLicenseResponseTemplate deserialize(String xml) throws JAXBException {
        try {
            return MediaServicesLicenseTemplateSerializer.deserialize(xml, null);
        }
        catch (SAXException e) {
            return null;
        }
    }

    public static PlayReadyLicenseResponseTemplate deserialize(String xml, String validationSchemaFileName) throws JAXBException, SAXException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PlayReadyLicenseResponseTemplate.class});
        Unmarshaller u = context.createUnmarshaller();
        if (validationSchemaFileName != null) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new File(validationSchemaFileName));
            u.setSchema(schema);
        }
        PlayReadyLicenseResponseTemplate template = (PlayReadyLicenseResponseTemplate)u.unmarshal((Reader)new StringReader(xml));
        MediaServicesLicenseTemplateSerializer.validateLicenseResponseTemplate(template);
        return template;
    }

    private static void validateLicenseResponseTemplate(PlayReadyLicenseResponseTemplate templateToValidate) {
        if (templateToValidate.getLicenseTemplates().size() <= 0) {
            throw new IllegalArgumentException("A PlayReadyLicenseResponseTemplate must have at least one PlayReadyLicenseTemplate");
        }
        for (PlayReadyLicenseTemplate template : templateToValidate.getLicenseTemplates()) {
            if (template.getContentKey() == null) {
                throw new IllegalArgumentException("Each PlayReadyLicenseTemplate in the PlayReadyLicenseResponseTemplate must have either a ContentEncryptionKeyFromHeader or a ContentEncryptionKeyFromKeyIdentifier");
            }
            if (template.getPlayRight() == null) {
                throw new IllegalArgumentException("Each PlayReadyLicenseTemplate in the PlayReadyLicenseResponseTemplate must have a PlayReadyPlayRight");
            }
            if (template.getPlayRight().isDigitalVideoOnlyContentRestriction() && (template.getPlayRight().getAllowPassingVideoContentToUnknownOutput() == UnknownOutputPassingOption.Allowed || template.getPlayRight().getAllowPassingVideoContentToUnknownOutput() == UnknownOutputPassingOption.AllowedWithVideoConstriction)) {
                throw new IllegalArgumentException("PlayReady does not allow passing to unknown outputs if the DigitalVideoOnlyContentRestriction is enabled.");
            }
            if (template.getLicenseType() != PlayReadyLicenseType.Nonpersistent) continue;
            if (template.getPlayRight().getFirstPlayExpiration() != null) {
                throw new IllegalArgumentException("FirstPlayExpiration cannot be set on the PlayRight of a Non Persistent license.");
            }
            if (template.getGracePeriod() != null) {
                throw new IllegalArgumentException("GracePeriod cannot be set on Non Persistent licenses.");
            }
            if (template.getBeginDate() != null) {
                throw new IllegalArgumentException("BeginDate cannot be set on Non Persistent licenses.");
            }
            if (template.getExpirationDate() == null) continue;
            throw new IllegalArgumentException("ExpirationDate cannot be set on Non Persistent licenses.");
        }
    }
}

