/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction;

import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.SymmetricVerificationKey;
import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.TokenClaim;
import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.TokenRestrictionTemplate;
import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.TokenType;
import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.TokenVerificationKey;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class TokenRestrictionTemplateSerializer {
    private TokenRestrictionTemplateSerializer() {
    }

    public static String serialize(TokenRestrictionTemplate template) throws JAXBException {
        TokenRestrictionTemplateSerializer.validateTokenRestrictionTemplate(template);
        StringWriter writer = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TokenRestrictionTemplate.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapper(){

            public String[] getPreDeclaredNamespaceUris() {
                return new String[]{"http://www.w3.org/2001/XMLSchema-instance"};
            }

            public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
                if (namespaceUri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    return "i";
                }
                return suggestion;
            }
        });
        m.marshal((Object)template, (Writer)writer);
        return writer.toString();
    }

    private static void validateTokenRestrictionTemplate(TokenRestrictionTemplate template) {
        if (template.getPrimaryVerificationKey() == null && template.getOpenIdConnectDiscoveryDocument() == null) {
            throw new IllegalArgumentException("Both PrimaryVerificationKey and OpenIdConnectDiscoveryDocument are null.");
        }
        if (template.getOpenIdConnectDiscoveryDocument() != null) {
            if (template.getOpenIdConnectDiscoveryDocument().getOpenIdDiscoveryUri() == null || template.getOpenIdConnectDiscoveryDocument().getOpenIdDiscoveryUri().isEmpty()) {
                throw new IllegalArgumentException("OpenIdConnectDiscoveryDocument.OpenIdDiscoveryUri string value is null or empty.");
            }
            boolean openIdDiscoveryUrlValid = true;
            try {
                new URL(template.getOpenIdConnectDiscoveryDocument().getOpenIdDiscoveryUri());
            }
            catch (MalformedURLException e) {
                openIdDiscoveryUrlValid = false;
            }
            if (!openIdDiscoveryUrlValid) {
                throw new IllegalArgumentException("String representation of OpenIdConnectDiscoveryDocument.OpenIdDiscoveryUri is not valid absolute Uri.");
            }
        }
    }

    public static TokenRestrictionTemplate deserialize(String xml) throws JAXBException {
        try {
            return TokenRestrictionTemplateSerializer.deserialize(xml, null);
        }
        catch (SAXException e) {
            return null;
        }
    }

    public static TokenRestrictionTemplate deserialize(String xml, String validationSchemaFileName) throws JAXBException, SAXException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TokenRestrictionTemplate.class});
        Unmarshaller u = context.createUnmarshaller();
        if (validationSchemaFileName != null) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new File(validationSchemaFileName));
            u.setSchema(schema);
        }
        TokenRestrictionTemplate template = (TokenRestrictionTemplate)u.unmarshal((Reader)new StringReader(xml));
        TokenRestrictionTemplateSerializer.validateTokenRestrictionTemplate(template);
        return template;
    }

    private static String generateTokenExpiry(Date expiry) {
        return Long.toString(expiry.getTime() / 1000L);
    }

    private static String urlEncode(String toEncode) {
        StringBuilder encoded = new StringBuilder(URLEncoder.encode(toEncode));
        for (int i = 0; i < encoded.length() - 2; ++i) {
            if (encoded.charAt(i) != '%') continue;
            encoded.setCharAt(i + 1, Character.toLowerCase(encoded.charAt(i + 1)));
            encoded.setCharAt(i + 2, Character.toLowerCase(encoded.charAt(i + 2)));
        }
        return encoded.toString();
    }

    public static String generateTestToken(TokenRestrictionTemplate tokenTemplate, TokenVerificationKey signingKeyToUse, UUID keyIdForContentKeyIdentifierClaim, Date tokenExpiration, Date notBefore) {
        Calendar cal;
        if (tokenTemplate == null) {
            throw new NullPointerException("tokenTemplate");
        }
        if (signingKeyToUse == null) {
            signingKeyToUse = tokenTemplate.getPrimaryVerificationKey();
        }
        if (tokenExpiration == null) {
            cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(12, 10);
            tokenExpiration = cal.getTime();
        }
        if (notBefore == null) {
            cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(12, -5);
            notBefore = cal.getTime();
        }
        if (tokenTemplate.getTokenType().equals((Object)TokenType.SWT)) {
            return TokenRestrictionTemplateSerializer.generateTestTokenSWT(tokenTemplate, signingKeyToUse, keyIdForContentKeyIdentifierClaim, tokenExpiration);
        }
        return TokenRestrictionTemplateSerializer.generateTestTokenJWT(tokenTemplate, signingKeyToUse, keyIdForContentKeyIdentifierClaim, tokenExpiration, notBefore);
    }

    public static String generateTestTokenJWT(TokenRestrictionTemplate tokenTemplate, TokenVerificationKey signingKeyToUse, UUID keyIdForContentKeyIdentifierClaim, Date tokenExpiration, Date notBefore) {
        SymmetricVerificationKey signingKey = (SymmetricVerificationKey)signingKeyToUse;
        SecretKeySpec secretKey = new SecretKeySpec(signingKey.getKeyValue(), "HmacSHA256");
        HashMap<String, String> claims = new HashMap<String, String>();
        for (TokenClaim claim : tokenTemplate.getRequiredClaims()) {
            String claimValue = claim.getClaimValue();
            if (claimValue == null && claim.getClaimType().equals(TokenClaim.getContentKeyIdentifierClaimType())) {
                if (keyIdForContentKeyIdentifierClaim == null) {
                    throw new IllegalArgumentException(String.format("The 'keyIdForContentKeyIdentifierClaim' parameter cannot be null when the token template contains a required '%s' claim type.", TokenClaim.getContentKeyIdentifierClaimType()));
                }
                claimValue = keyIdForContentKeyIdentifierClaim.toString();
            }
            claims.put(claim.getClaimType(), claimValue);
        }
        return Jwts.builder().setHeaderParam("typ", (Object)"JWT").setClaims(claims).setIssuer(tokenTemplate.getIssuer().toString()).setAudience(tokenTemplate.getAudience().toString()).setIssuedAt(notBefore).setExpiration(tokenExpiration).signWith(SignatureAlgorithm.HS256, (Key)secretKey).compact();
    }

    public static String generateTestTokenSWT(TokenRestrictionTemplate tokenTemplate, TokenVerificationKey signingKeyToUse, UUID keyIdForContentKeyIdentifierClaim, Date tokenExpiration) {
        Mac mac;
        StringBuilder builder = new StringBuilder();
        for (TokenClaim claim : tokenTemplate.getRequiredClaims()) {
            String claimValue = claim.getClaimValue();
            if (claim.getClaimType().equals(TokenClaim.getContentKeyIdentifierClaimType())) {
                if (keyIdForContentKeyIdentifierClaim == null) {
                    throw new IllegalArgumentException(String.format("The 'keyIdForContentKeyIdentifierClaim' parameter cannot be null when the token template contains a required '%s' claim type.", TokenClaim.getContentKeyIdentifierClaimType()));
                }
                claimValue = keyIdForContentKeyIdentifierClaim.toString();
            }
            builder.append(String.format("%s=%s&", TokenRestrictionTemplateSerializer.urlEncode(claim.getClaimType()), TokenRestrictionTemplateSerializer.urlEncode(claimValue)));
        }
        builder.append(String.format("Audience=%s&", TokenRestrictionTemplateSerializer.urlEncode(tokenTemplate.getAudience().toString())));
        builder.append(String.format("ExpiresOn=%s&", TokenRestrictionTemplateSerializer.generateTokenExpiry(tokenExpiration)));
        builder.append(String.format("Issuer=%s", TokenRestrictionTemplateSerializer.urlEncode(tokenTemplate.getIssuer().toString())));
        SymmetricVerificationKey signingKey = (SymmetricVerificationKey)signingKeyToUse;
        SecretKeySpec secretKey = new SecretKeySpec(signingKey.getKeyValue(), "HmacSHA256");
        try {
            mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        byte[] unsignedTokenAsBytes = builder.toString().getBytes();
        byte[] signatureBytes = mac.doFinal(unsignedTokenAsBytes);
        String encoded = new String(Base64.encode((byte[])signatureBytes));
        builder.append(String.format("&HMACSHA256=%s", TokenRestrictionTemplateSerializer.urlEncode(encoded)));
        return builder.toString();
    }
}

